/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.outputValue.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.outputValue.bean.PcMonthActualOutputValueEntity;
import com.ejianc.business.outputValue.service.IPcMonthActualOutputValueRecordService;
import com.ejianc.business.outputValue.service.IPcMonthActualOutputValueService;
import com.ejianc.business.outputValue.vo.PcMonthActualOutputValueRecordVO;
import com.ejianc.business.outputValue.vo.PcMonthActualOutputValueVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"pcMonthActualOutputValue"})
public class PcMonthActualOutputValueController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IPcMonthActualOutputValueService service;
    @Autowired
    private IPcMonthActualOutputValueRecordService recordService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PcMonthActualOutputValueVO> saveOrUpdate(@RequestBody PcMonthActualOutputValueVO saveorUpdateVO) {
        PcMonthActualOutputValueEntity entity = (PcMonthActualOutputValueEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), PcMonthActualOutputValueEntity.class));
        QueryWrapper wrapper = new QueryWrapper();
        if (entity.getId() != null) {
            wrapper.ne((Object)"id", (Object)entity.getId());
        }
        wrapper.eq((Object)"year", (Object)entity.getYear());
        wrapper.eq((Object)"month", (Object)entity.getMonth());
        wrapper.eq((Object)"project_id", (Object)entity.getProjectId());
        Integer count = this.service.count((Wrapper)wrapper);
        if (count > 0) {
            throw new BusinessException("\u8be5\u9879\u76ee\u672c\u5e74\u5df2\u5b58\u5728\u5de5\u5382\u6708\u5ea6\u5b9e\u9645\u4ea7\u503c\uff01");
        }
        CommonResponse orgResponse = this.iOrgApi.detailById(saveorUpdateVO.getOrgId());
        if (orgResponse.isSuccess() && orgResponse.getData() != null) {
            String innerCode = ((OrgVO)orgResponse.getData()).getInnerCode();
            String[] orgIds = innerCode.split("\\|");
            if (orgIds.length > 1) {
                Long twoOrgId = Long.parseLong(orgIds[1]);
                String twoOrgName = null;
                CommonResponse twoOrgResponse = this.iOrgApi.detailById(twoOrgId);
                if (twoOrgResponse.isSuccess() && twoOrgResponse.getData() != null) {
                    twoOrgName = ((OrgVO)twoOrgResponse.getData()).getName();
                }
                entity.setTwoOrgId(twoOrgId);
                entity.setTwoOrgName(twoOrgName);
            } else {
                entity.setTwoOrgId(entity.getOrgId());
                entity.setTwoOrgName(entity.getOrgName());
            }
        }
        if (StringUtils.isBlank((CharSequence)entity.getChangeState())) {
            entity.setChangeState("1");
        }
        this.service.saveOrUpdate((Object)entity, false);
        PcMonthActualOutputValueVO vo = (PcMonthActualOutputValueVO)((Object)BeanMapper.map((Object)((Object)entity), PcMonthActualOutputValueVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PcMonthActualOutputValueVO> queryDetail(Long id) {
        PcMonthActualOutputValueEntity entity = (PcMonthActualOutputValueEntity)((Object)this.service.selectById(id));
        PcMonthActualOutputValueVO vo = (PcMonthActualOutputValueVO)((Object)BeanMapper.map((Object)((Object)entity), PcMonthActualOutputValueVO.class));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.eq((Object)"data_id", (Object)id);
        List records = this.recordService.list((Wrapper)queryWrapper);
        if (records != null && records.size() > 0) {
            vo.setRecordList(BeanMapper.mapList((Iterable)records, PcMonthActualOutputValueRecordVO.class));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PcMonthActualOutputValueVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PcMonthActualOutputValueVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("twoOrgName");
        fuzzyFields.add("year");
        fuzzyFields.add("month");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PcMonthActualOutputValueVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }
}

