package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.material.bean.*;
import com.ejianc.business.material.mapper.MonthProjectMapper;
import com.ejianc.business.material.service.*;
import com.ejianc.business.material.utils.ComputeUtil;
import com.ejianc.business.material.vo.*;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.share.api.IShareMaterialApi;
import com.ejianc.foundation.share.vo.MaterialCategoryVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.time.YearMonth;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 物资消耗月度分析表-项目
 * 
 * @author generator
 * 
 */
@Service("monthProjectService")
public class MonthProjectServiceImpl extends BaseServiceImpl<MonthProjectMapper, MonthProjectEntity> implements IMonthProjectService{

    @Autowired
    private IShareMaterialApi shareMaterialApi;
    @Autowired
    private IMaterialsreturnService materialsreturnService;
    @Autowired
    private IMaterialsreturndetailService materialsreturndetailService;

    @Autowired
    private IMonthProjectDetailService monthProjectDetailService;
    @Autowired
    private IMonthOrgDetailService orgDetailService;
    @Autowired
    private MonthProjectMapper monthProjectMapper;
    @Autowired
    private IFlowmeterService flowmeterService;
    @Autowired
    private IOrgApi iOrgApi;


    @Override
    public List<MonthProjectDetailVO> queryDataById(Long projectId,String month) {
        List<MonthProjectDetailVO> projectDetailList = new ArrayList<>();
        MonthProjectDetailVO monthProjectDetailHntVO = new MonthProjectDetailVO();
        MonthProjectDetailVO monthProjectDetailGjVO = new MonthProjectDetailVO();

        //混凝土
        String code = "WL103";
        String codeGj = "WL10101";
        String unit = "平方米";
        String unitGj = "吨";
        getDataByCode(code,projectId, monthProjectDetailHntVO, month,unit);
        getDataByCode(codeGj,projectId, monthProjectDetailGjVO, month,unitGj);
        projectDetailList.add(monthProjectDetailHntVO);
        projectDetailList.add(monthProjectDetailGjVO);
        return projectDetailList;
    }

    private void getDataByCode(String code,Long projectId, MonthProjectDetailVO monthProjectDetailHntVO, String month,String unit) {
        //根据项目查询月计划量
        String previousMonth = getPreviousMonth(month);
        //上上期年月
        String previousLastMonth = getPreviousMonth(previousMonth);

        CommonResponse<MaterialCategoryVO> hntMaterial = shareMaterialApi.queryCategoryByCode(code);
        if (!hntMaterial.isSuccess()){
            throw new BusinessException("获取物资分类信息失败");
        }
        MaterialCategoryVO hntMaterialData = hntMaterial.getData();

        List<Long> listBycategoryHntId = monthProjectMapper.getListBycategoryId(hntMaterialData.getId());

        BigDecimal planHntNum = monthProjectMapper.getPlanNum(null,projectId,listBycategoryHntId,previousMonth);

        monthProjectDetailHntVO.setId(IdWorker.getId());
        monthProjectDetailHntVO.setMonthPlanNum(planHntNum);
        monthProjectDetailHntVO.setMaterialCategoryId(hntMaterialData.getId());
        monthProjectDetailHntVO.setMaterialCategoryName(hntMaterialData.getName());
        monthProjectDetailHntVO.setMaterialSpec("综合");
        monthProjectDetailHntVO.setMaterialUnit(unit);

        //取库存量
        LambdaQueryWrapper<MonthProjectEntity> lastMonthProLambda = Wrappers.<MonthProjectEntity>lambdaQuery();
        lastMonthProLambda.in(MonthProjectEntity::getBillState, 1,3);
        lastMonthProLambda.orderByDesc(MonthProjectEntity::getMonth);
        List<MonthProjectEntity> monthProjectEntities = super.list(lastMonthProLambda);
        Map<Long, MonthProjectDetailEntity> monthDetailLastMap = new HashMap<>();
        if (CollectionUtils.isNotEmpty(monthProjectEntities)){
            MonthProjectEntity monthProjectEntity = monthProjectEntities.stream().findFirst().get();
            LambdaQueryWrapper<MonthProjectDetailEntity> lastMonthProDetailLambda = Wrappers.<MonthProjectDetailEntity>lambdaQuery();
            lastMonthProDetailLambda.eq(MonthProjectDetailEntity::getMid, monthProjectEntity.getId());
            List<MonthProjectDetailEntity> monthProjectDetailEntities = monthProjectDetailService.list(lastMonthProDetailLambda);
            monthDetailLastMap = monthProjectDetailEntities.stream().collect(Collectors.toMap(MonthProjectDetailEntity::getMaterialCategoryId, Function.identity()));
        }
        if(monthDetailLastMap.containsKey(monthProjectDetailHntVO.getMaterialCategoryId())){
            MonthProjectDetailEntity monthProjectDetailHntEntity = monthDetailLastMap.get(monthProjectDetailHntVO.getMaterialCategoryId());
            monthProjectDetailHntVO.setLastStoreNum(monthProjectDetailHntEntity.getStoreNum());
        }

        //已完工部分消耗量-本月实际进场量(含调入)
        LambdaQueryWrapper<FlowmeterEntity> lastFlowhntLambda = Wrappers.<FlowmeterEntity>lambdaQuery();
        lastFlowhntLambda.eq(FlowmeterEntity::getBillStatus, 1);
        lastFlowhntLambda.eq(FlowmeterEntity::getProjectId, projectId);
        lastFlowhntLambda.in(FlowmeterEntity::getMaterialCategoryId, listBycategoryHntId);
        lastFlowhntLambda.apply("DATE_FORMAT(approve_time, '%Y-%m') = '" + previousMonth + "'");
        List<FlowmeterEntity> flowmeterhntEntities = flowmeterService.list(lastFlowhntLambda);
        //
        BigDecimal currentstoreNum = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(flowmeterhntEntities)){
            BigDecimal inNum = flowmeterhntEntities.stream().filter(s ->s.getOperationType().equals("入库")).map(FlowmeterEntity::getQuantity)
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal outNum = flowmeterhntEntities.stream().filter(s ->s.getOperationType().equals("出库")).map(FlowmeterEntity::getQuantity)
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
            currentstoreNum = ComputeUtil.safeSub(inNum,outNum);
            monthProjectDetailHntVO.setInNum(inNum);
        }

        //已完工部分消耗量-本月库存量
        //获取上期之前所有数据
        LambdaQueryWrapper<FlowmeterEntity> preFlowLambda = Wrappers.<FlowmeterEntity>lambdaQuery();
        preFlowLambda.eq(FlowmeterEntity::getBillStatus, 1);
        preFlowLambda.eq(FlowmeterEntity::getProjectId, projectId);
        preFlowLambda.in(FlowmeterEntity::getMaterialCategoryId, listBycategoryHntId);
        preFlowLambda.apply("DATE_FORMAT(approve_time, '%Y-%m') <= '" + previousLastMonth + "'");
        List<FlowmeterEntity> flowmeterPreEntities = flowmeterService.list(preFlowLambda);
        //上期结存
        BigDecimal lastNum = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(flowmeterPreEntities)){
            BigDecimal inNum = flowmeterhntEntities.stream().filter(s ->s.getOperationType().equals("入库")).map(FlowmeterEntity::getQuantity)
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal outNum = flowmeterhntEntities.stream().filter(s ->s.getOperationType().equals("出库")).map(FlowmeterEntity::getQuantity)
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
            lastNum = ComputeUtil.safeSub(inNum,outNum);
        }

        // 已完工部分消耗量-本月库存量
        monthProjectDetailHntVO.setStoreNum(ComputeUtil.safeAdd(lastNum,currentstoreNum));

        //调出量
        LambdaQueryWrapper<FlowmeterEntity> transforFlowLambda = Wrappers.<FlowmeterEntity>lambdaQuery();
        transforFlowLambda.eq(FlowmeterEntity::getBillStatus, 1);
        transforFlowLambda.eq(FlowmeterEntity::getProjectId, projectId);
        transforFlowLambda.eq(FlowmeterEntity::getTransferorderType, "调拨出库");
        transforFlowLambda.eq(FlowmeterEntity::getOperationType, "出库");
        transforFlowLambda.in(FlowmeterEntity::getMaterialCategoryId, listBycategoryHntId);
        transforFlowLambda.apply("DATE_FORMAT(approve_time, '%Y-%m') = '" + previousMonth + "'");
        List<FlowmeterEntity> flowmeterTransfor = flowmeterService.list(preFlowLambda);
        BigDecimal outNum = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(flowmeterTransfor)){
            outNum = flowmeterTransfor.stream().map(FlowmeterEntity::getQuantity)
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
            monthProjectDetailHntVO.setOutNum(outNum);
        }
        //当月废旧物资处置量
        LambdaQueryWrapper<FlowmeterEntity> dealFlowLambda = Wrappers.<FlowmeterEntity>lambdaQuery();
        dealFlowLambda.eq(FlowmeterEntity::getBillStatus, 1);
        dealFlowLambda.eq(FlowmeterEntity::getProjectId, projectId);
        dealFlowLambda.eq(FlowmeterEntity::getAccessType, "处置");
        dealFlowLambda.eq(FlowmeterEntity::getOperationType, "出库");
        dealFlowLambda.in(FlowmeterEntity::getMaterialCategoryId, listBycategoryHntId);
        dealFlowLambda.apply("DATE_FORMAT(approve_time, '%Y-%m') = '" + previousMonth + "'");
        List<FlowmeterEntity> flowmeterDeal = flowmeterService.list(preFlowLambda);
        BigDecimal dealNum = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(flowmeterDeal)){
            dealNum = flowmeterDeal.stream().map(FlowmeterEntity::getQuantity)
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
            monthProjectDetailHntVO.setDealNum(dealNum);
        }
        //消耗量
        BigDecimal bigDecimal = ComputeUtil.safeAdd(monthProjectDetailHntVO.getLastStoreNum(), monthProjectDetailHntVO.getInNum());
        BigDecimal bigDecimal1 = ComputeUtil.safeSub(bigDecimal, monthProjectDetailHntVO.getStoreNum());
        BigDecimal bigDecimal2 = ComputeUtil.safeSub(bigDecimal1, monthProjectDetailHntVO.getOutNum());
        BigDecimal useNum = ComputeUtil.safeSub(bigDecimal2, monthProjectDetailHntVO.getDealNum());
        monthProjectDetailHntVO.setUseNum(useNum);
        //实际节超量
        monthProjectDetailHntVO.setDiffNum(ComputeUtil.safeSub(BigDecimal.ZERO,monthProjectDetailHntVO.getUseNum()));
        monthProjectDetailHntVO.setDiffRate(ComputeUtil.safeSub(monthProjectDetailHntVO.getDiffNum(),BigDecimal.ZERO));
        monthProjectDetailHntVO.setSumInRate(ComputeUtil.safeDiv(monthProjectDetailHntVO.getInNum(),monthProjectDetailHntVO.getMonthPlanNum()));
    }

    @Override
    public List<Long> getListByCode(String code) {

        return null;
    }

    @Override
    public List<MonthOrgDetailVO> queryDetailByOrgId(Long orgId, String month) {
//        CommonResponse<List<OrgVO>> childrenByParentIdWithoutProjectDept = iOrgApi.findChildrenByParentIdWithoutProjectDept(orgId);
//        if (!childrenByParentIdWithoutProjectDept.isSuccess()){
//            throw new BusinessException("获取组织信息失败!");
//        }
//        List<Long> orgIds = new ArrayList<>();
//        List<OrgVO> data = childrenByParentIdWithoutProjectDept.getData();
//        if (CollectionUtils.isNotEmpty(data)){
//            orgIds = data.stream().map(OrgVO::getId).collect(Collectors.toList());
//        }
        List<Long> orgIds = getOrgIds();
        List<MonthOrgDetailVO> list = monthProjectMapper.queryDetailByOrgId(orgIds,month);
        for (MonthOrgDetailVO monthOrgDetailVO : list){
            monthOrgDetailVO.setId(IdWorker.getId());
        }

        return list;
    }

    @Override
    public List<BigScreenVO> getInNumByOrgId() {
        List<Long> orgIds = getOrgIds();
//
        List<BigScreenVO> codeList = new ArrayList<>();
        getBigScreenList(codeList);

        for (BigScreenVO bigScreenVO : codeList){

            List<Long> categoryIds = getCategoryIds(bigScreenVO.getMaterialCode());
            //入库数量
            LambdaQueryWrapper<FlowmeterEntity> inFlowLambda = Wrappers.<FlowmeterEntity>lambdaQuery();
            List<String> operationType = new ArrayList<>();
            operationType.add("入库");
            operationType.add("出库");
            List<String> accessType = new ArrayList<>();
            accessType.add("直入直出退供应商");
            accessType.add("退供应商");
            inFlowLambda.eq(FlowmeterEntity::getBillStatus, 1);
            inFlowLambda.in(FlowmeterEntity::getProjectDepartmentId, orgIds);
            inFlowLambda.in(FlowmeterEntity::getOperationType, operationType);
            inFlowLambda.in(FlowmeterEntity::getAccessType, accessType);
            inFlowLambda.in(FlowmeterEntity::getMaterialCategoryId, categoryIds);
            List<FlowmeterEntity> flowmeterInList = flowmeterService.list(inFlowLambda);
            BigDecimal inNum = BigDecimal.ZERO;
//            BigDecimal returnCountNum = BigDecimal.ZERO;
            if (CollectionUtils.isNotEmpty(flowmeterInList)){
                inNum = flowmeterInList.stream().map(FlowmeterEntity::getQuantity)
                        .reduce(BigDecimal.ZERO, BigDecimal::add);
            }

            //退场量
//            LambdaQueryWrapper<MaterialsreturnEntity> materialReturnLambda = Wrappers.<MaterialsreturnEntity>lambdaQuery();
//            materialReturnLambda.in(MaterialsreturnEntity::getBillState, 1,3);
//            materialReturnLambda.in(MaterialsreturnEntity::getProjectDepartmentId, orgIds);
//            List<MaterialsreturnEntity> materialsreturnEntities = materialsreturnService.list(materialReturnLambda);
//
//            Map<Long, MonthProjectDetailEntity> monthDetailLastMap = new HashMap<>();
//            if (CollectionUtils.isNotEmpty(materialsreturnEntities)){
//                List<Long> ids = materialsreturnEntities.stream().map(MaterialsreturnEntity::getId).collect(Collectors.toList());
//                LambdaQueryWrapper<MaterialsreturndetailEntity> materialDetailLambda  = Wrappers.<MaterialsreturndetailEntity>lambdaQuery();
//                materialDetailLambda.eq(MaterialsreturndetailEntity::getMid, ids);
//                materialDetailLambda.in(MaterialsreturndetailEntity::getMaterialClassId, categoryIds);
//                List<MaterialsreturndetailEntity> monthProjectDetailEntities = materialsreturndetailService.list(materialDetailLambda);
//                returnCountNum = monthProjectDetailEntities.stream().map(MaterialsreturndetailEntity::getReturnCount)
//                        .reduce(BigDecimal.ZERO, BigDecimal::add);
//            }

            bigScreenVO.setInNum(inNum);

            //总控计划量
            BigDecimal totalPlanNum = monthProjectMapper.getTotalPlanNum(orgIds,categoryIds);
            bigScreenVO.setTotalPlanNum(totalPlanNum);
        }

        return codeList;
    }

    private void getBigScreenList(List<BigScreenVO> codeList) {
        BigScreenVO bigScreenVO1 = new BigScreenVO();
        bigScreenVO1.setMaterialName("混凝土(立方米)");
        bigScreenVO1.setMaterialCode("WL103");
        BigScreenVO bigScreenVO2 = new BigScreenVO();
        bigScreenVO2.setMaterialName("钢筋(吨)");
        bigScreenVO2.setMaterialCode("WL10101");
        BigScreenVO bigScreenVO3 = new BigScreenVO();
        bigScreenVO3.setMaterialName("砌块(立方米)");
        bigScreenVO3.setMaterialCode("WL10603");
        BigScreenVO bigScreenVO4 = new BigScreenVO();
        bigScreenVO4.setMaterialName("电缆线(米/m)");
        bigScreenVO4.setMaterialCode("WL11002");
        BigScreenVO bigScreenVO5 = new BigScreenVO();
        bigScreenVO5.setMaterialName("配电箱(台)");
        bigScreenVO5.setMaterialCode("WL11028");
        codeList.add(bigScreenVO1);
        codeList.add(bigScreenVO2);
        codeList.add(bigScreenVO3);
        codeList.add(bigScreenVO4);
        codeList.add(bigScreenVO5);
    }

    @Override
    public List<BigScreenVO> getPlanRateByOrgId(Integer type, String month) {
        List<Long> orgIds = getOrgIds();
        List<BigScreenVO> codeList = new ArrayList<>();
        getBigScreenList(codeList);

        for (BigScreenVO bigScreenVO : codeList){
            List<Long> categoryIds = getCategoryIds(bigScreenVO.getMaterialCode());

            //月度计划
            //type 1-总计划 2- 月度计划
            if (type == 1){
                //计划
                BigDecimal totalPlanNum = monthProjectMapper.getTotalPlanNum(orgIds,categoryIds);
                bigScreenVO.setTotalPlanNum(totalPlanNum);

                //订单量
                BigDecimal orderNum = monthProjectMapper.getOrderNum(orgIds,categoryIds,null);
                bigScreenVO.setOrderNum(orderNum);

                //验收量
//                BigDecimal checkNum = monthProjectMapper.getcheckNum(orgIds,categoryIds,null);
                //入库数量
                BigDecimal inNum = BigDecimal.ZERO;
                inNum = getFlowNum(type, month, orgIds, categoryIds, inNum);

                bigScreenVO.setCheckNum(inNum);
            }
            if (type == 2){
                BigDecimal monthPlanNum = monthProjectMapper.getPlanNum(orgIds,null,categoryIds,month);
                bigScreenVO.setTotalPlanNum(monthPlanNum);
                //订单量
                BigDecimal orderNum = monthProjectMapper.getOrderNum(orgIds,categoryIds,month);
                bigScreenVO.setOrderNum(orderNum);
                //验收量
//                BigDecimal checkNum = monthProjectMapper.getcheckNum(orgIds,categoryIds,month);
                BigDecimal inNum = BigDecimal.ZERO;

                inNum = getFlowNum(type, month, orgIds, categoryIds, inNum);

                bigScreenVO.setCheckNum(inNum);
            }

            bigScreenVO.setRate(ComputeUtil.safeMultiply(ComputeUtil.safeDiv(bigScreenVO.getCheckNum(),bigScreenVO.getTotalPlanNum()),new BigDecimal(100)));
        }

        return codeList;
    }

    @Override
    public List<BigScreenVO> getDiffRateOrgId(String month) {
        List<Integer> typeList = new ArrayList<>();
        typeList.add(2);
        CommonResponse<List<OrgVO>> orgByType = iOrgApi.findOrgByType(InvocationInfoProxy.getTenantid(), typeList, null);
        if (!orgByType.isSuccess()){
            throw new BusinessException("获取组织信息失败!");
        }
        List<Long> orgIds = getOrgIds();
        List<OrgVO> orgByTypeData = orgByType.getData();
        List<OrgVO> orgVOList = orgByTypeData.stream().filter(s -> orgIds.contains(s.getId())).collect(Collectors.toList());

        List<BigScreenVO> list = monthProjectMapper.getMonthOrgByMonth(orgIds,month);
        Map<String, BigDecimal> dataMap = new HashMap<>();
        Map<String, List<BigScreenVO>> dataListMap = new HashMap<>();
        List<BigScreenVO> list1 = new ArrayList<BigScreenVO>();
        if (CollectionUtils.isNotEmpty(list)) {
            dataMap = list.stream().collect(Collectors.groupingBy((score -> score.getOrgId() + "_" + score.getMaterialCategoryName()),
                    Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getRate()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            dataListMap = list.stream().collect(Collectors.groupingBy((score -> score.getOrgId() + "_" + score.getMaterialCategoryName())));
        }
        for (OrgVO orgVO : orgVOList) {
            BigScreenVO bigScreenVO = new BigScreenVO();
            bigScreenVO.setId(orgVO.getId());
            bigScreenVO.setOrgName(orgVO.getName());
            String keyHnt = orgVO.getId() + "_" +  "混凝土";
            String keyGj = orgVO.getId() + "_" +  "钢筋";
            if (dataMap.containsKey(keyHnt)){
                BigDecimal hntRate = dataMap.get(keyHnt);
                bigScreenVO.setHntRate(hntRate);
            }
            if (dataListMap.containsKey(keyHnt)){
                List<BigScreenVO> bigScreenVOList = dataListMap.get(keyHnt);
                bigScreenVO.setId(bigScreenVOList.stream().findFirst().get().getId());
            }
            if (dataMap.containsKey(keyGj)){
                BigDecimal gjRate = dataMap.get(keyGj);
                bigScreenVO.setGjRate(gjRate);
            }

            if (dataListMap.containsKey(keyGj)){
                List<BigScreenVO> bigScreenVOList = dataListMap.get(keyGj);
                bigScreenVO.setId(bigScreenVOList.stream().findFirst().get().getId());
            }

            list1.add(bigScreenVO);
        }
        return list1;
    }

    @Override
    public List<BigScreenVO> getDiffRateProjectId(Long id) {
        LambdaQueryWrapper<MonthOrgDetailEntity> inDetailLambda = Wrappers.<MonthOrgDetailEntity>lambdaQuery();
        inDetailLambda.eq(MonthOrgDetailEntity::getMid, id);
        List<MonthOrgDetailEntity> monthOrgDetailEntities = orgDetailService.list(inDetailLambda);
        ArrayList<BigScreenVO> screenVOArrayList = new ArrayList<>();
        if (CollectionUtils.isNotEmpty(monthOrgDetailEntities)){
            Map<Long, List<MonthOrgDetailEntity>> listMap = monthOrgDetailEntities.stream().collect(Collectors.groupingBy((score -> score.getProjectId())));
            listMap.forEach((projectId, details) -> {
                BigScreenVO bigScreenVO = new BigScreenVO();
                bigScreenVO.setProjectId(projectId);
                bigScreenVO.setProjectName(details.stream().findFirst().get().getProjectName());
                List<MonthOrgDetailEntity> listHnt = details.stream().filter(s -> s.getMaterialCategoryName().equals("混凝土")).collect(Collectors.toList());
                bigScreenVO.setHntRate(listHnt.stream().findFirst().get().getDiffRate());
                List<MonthOrgDetailEntity> listGj = details.stream().filter(s -> s.getMaterialCategoryName().equals("钢筋")).collect(Collectors.toList());
                bigScreenVO.setGjRate(listGj.stream().findFirst().get().getDiffRate());
                screenVOArrayList.add(bigScreenVO);
            });
        }

        return screenVOArrayList;
    }

    private BigDecimal getFlowNum(Integer type, String month, List<Long> orgIds, List<Long> categoryIds, BigDecimal inNum) {
        LambdaQueryWrapper<FlowmeterEntity> inFlowLambda = Wrappers.<FlowmeterEntity>lambdaQuery();
        List<String> operationType = new ArrayList<>();
        operationType.add("入库");
        operationType.add("出库");
        List<String> accessType = new ArrayList<>();
        accessType.add("直入直出退供应商");
        accessType.add("退供应商");
        inFlowLambda.eq(FlowmeterEntity::getBillStatus, 1);
        inFlowLambda.in(FlowmeterEntity::getProjectDepartmentId, orgIds);
        inFlowLambda.in(FlowmeterEntity::getOperationType, operationType);
        inFlowLambda.in(FlowmeterEntity::getAccessType, accessType);
        inFlowLambda.in(FlowmeterEntity::getMaterialCategoryId, categoryIds);
        if (type == 2){
            inFlowLambda.apply("DATE_FORMAT(time, '%Y-%m-%d') = '" + month + "'");
        }
        List<FlowmeterEntity> flowmeterInList = flowmeterService.list(inFlowLambda);

//            BigDecimal returnCountNum = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(flowmeterInList)){
            inNum = flowmeterInList.stream().map(FlowmeterEntity::getQuantity)
                    .reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        return inNum;
    }

    //获取组织id
    private List<Long> getOrgIds() {
        CommonResponse<List<OrgVO>> childrenByParentIdWithoutProjectDept = iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId());
        if (!childrenByParentIdWithoutProjectDept.isSuccess()){
            throw new BusinessException("获取组织信息失败!");
        }
        List<Long> orgIds = new ArrayList<>();
        List<OrgVO> data = childrenByParentIdWithoutProjectDept.getData();
        if (CollectionUtils.isNotEmpty(data)){
            orgIds = data.stream().map(OrgVO::getId).collect(Collectors.toList());
        }
        return orgIds;
    }
    //根据物资分类编码获取本下分类的id
    private List<Long> getCategoryIds(String code) {
        CommonResponse<MaterialCategoryVO> hntMaterial = shareMaterialApi.queryCategoryByCode(code);
        if (!hntMaterial.isSuccess()){
            throw new BusinessException("获取物资分类信息失败");
        }
        MaterialCategoryVO hntMaterialData = hntMaterial.getData();

        List<Long> listBycategoryId = monthProjectMapper.getListBycategoryId(hntMaterialData.getId());
        return listBycategoryId;
    }


    private static String getPreviousMonth(String month) {
        // 解析输入字符串为YearMonth对象
        YearMonth yearMonth = YearMonth.parse(month);
        // 获取上个月的YearMonth对象
        YearMonth previousMonth = yearMonth.minusMonths(1);
        // 转换为"yyyy-MM"格式的字符串
        return previousMonth.toString();
    }

}
