package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.material.bean.*;
import com.ejianc.business.material.service.IFlowmeterService;
import com.ejianc.business.material.service.IRealtimebalanceService;
import com.ejianc.business.material.service.IStoreService;
import com.ejianc.business.material.service.ISurplusmaterialrecordService;
import com.ejianc.framework.core.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

@Service("surplusmaterialrecord") 
public class SurplusmaterialrecordBpmServiceImpl implements ICommonBusinessService {
	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IRealtimebalanceService realtimebalanceService;
	@Autowired
	private IFlowmeterService flowmeterService;
	@Autowired
	private ISurplusmaterialrecordService surplusmaterialrecordService;
	@Autowired
	IStoreService storeService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){

		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		flowmeterService.updateFlow(billId,new Date(),1);
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		flowmeterService.updateFlow(billId,null,0);
		return CommonResponse.success();
	}

	public FlowmeterEntity createrFlowmeter(SurplusmaterialrecordEntity surplusmaterialrecordEntity,SurplusmaterialrecordtailEntity entity,Integer billStatus,Date approveTime){
		FlowmeterEntity flowmeterEntity = new FlowmeterEntity();
		flowmeterEntity.setMid(surplusmaterialrecordEntity.getId());
		flowmeterEntity.setDetailId(entity.getId());
		flowmeterEntity.setBillCode(surplusmaterialrecordEntity.getBillCode());
		flowmeterEntity.setProjectId(surplusmaterialrecordEntity.getProjectId());
		flowmeterEntity.setProjectName(surplusmaterialrecordEntity.getProjectName());
		flowmeterEntity.setStoreId(surplusmaterialrecordEntity.getStoreId());
		flowmeterEntity.setStoreName(surplusmaterialrecordEntity.getStoreName());
		flowmeterEntity.setMaterialCode(entity.getMaterialCode());
		flowmeterEntity.setMaterialName(entity.getMaterialName());
		flowmeterEntity.setMaterialId(entity.getMaterialId());
		flowmeterEntity.setMaterialCategoryId(entity.getMaterialCategoryId());
		flowmeterEntity.setMaterialCategoryCode(entity.getMaterialCategoryCode());
		flowmeterEntity.setMaterialCategoryName(entity.getMaterialCategoryName());
		flowmeterEntity.setOperationType("出库");
		flowmeterEntity.setAccessType("处置");
		flowmeterEntity.setBillStatus(billStatus);
		flowmeterEntity.setApproveTime(approveTime);
		flowmeterEntity.setBillTime(surplusmaterialrecordEntity.getCreateTime());
		if(surplusmaterialrecordEntity.getIsRebarManagement() == 0){
			flowmeterEntity.setQuantity(entity.getSuttle());
		}else{
			flowmeterEntity.setQuantity(entity.getMaterialNumber());
		}

		flowmeterEntity.setUnitPriceIncluetax(entity.getUnitPriceIncluetax());
		flowmeterEntity.setUnitPriceExcluetax(entity.getUnitPriceExcluetax());
		flowmeterEntity.setAmountIncluetax(entity.getAmountIncluetax());
		flowmeterEntity.setAmountExcluetax(entity.getAmountExcluetax());
		flowmeterEntity.setTime(surplusmaterialrecordEntity.getDealDate());
		flowmeterEntity.setOrgId(surplusmaterialrecordEntity.getOrgId());
		flowmeterEntity.setOrgName(surplusmaterialrecordEntity.getOrgName());
		flowmeterEntity.setMeasurementUnit(entity.getMaterialUnit());
		flowmeterEntity.setSpecialModel(entity.getMaterialSpecifications());
		flowmeterEntity.setProjectDepartmentId(surplusmaterialrecordEntity.getProjectDepartmentId());
		//查询仓库类型
		StoreEntity storeEntity = storeService.selectById(flowmeterEntity.getStoreId());
		flowmeterEntity.setStoreType(storeEntity.getStoreType());
		flowmeterEntity.setBillType(3);
		return  flowmeterEntity;
	}


}
