package com.ejianc.business.material.vo;

import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.material.vo.MaterialinventorydetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 物资库存及可调拨材料记录
 * 
 * @author generator
 * 
 */
public class MaterialInventoryVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private java.lang.String billCode; // 单据编号
    private java.lang.Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private java.util.Date approveTime; // 审批通过日期
    private java.lang.Long agentdeptId; // 经办人部门id
    private java.lang.String agentdeptName; // 经办人部门
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date billsTime; // 单据日期
    private java.lang.String projectCode; // 项目编码
    private java.lang.Long projectId; // 项目id
    private java.lang.String projectName; // 项目名称
    private java.lang.Long orgId; // 所属组织id
    private java.lang.String orgName; // 所属组织名称
    private java.lang.Long projectDepartmentId; // 项目部id
    private java.lang.Long changeId; // 变更单据id
    private java.lang.String changeState; // 变更状态，1:未变更;2:变更中;3:已变更
    private java.lang.String remarks; // 备注
    private java.lang.Long agentId; // 经办人
    private java.lang.String agentName; // 经办人姓名
    private java.lang.String signatureKeeper; // 库管员签字
    private java.lang.String projectDepartment; // 项目物资部
    private java.lang.String projectEngineer; // 项目工程部
    private java.lang.String commerce; // 商务部
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date approvalDate; // 审批日期
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date dataDate; // 单据日期

    private java.lang.String num; // 序号
    private java.lang.String createTimeShow;
    private java.lang.String billStateStr;
    private java.lang.String resultDateShow;

    private Long storeId; //仓库id
    private java.lang.String storeName;//仓库名称

    
    private List<MaterialinventorydetailVO> materialinventorydetailEntities = new ArrayList<>(); // 物资库存及可调拨材料记录子表

    /**
     * 单据编号
     */
    public java.lang.String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(java.lang.String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public java.lang.Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public void setBillState(java.lang.Integer billState) {
        this.billState = billState;
    }
    /**
     * 审批通过日期
     */
    public java.util.Date getApproveTime() {
        return approveTime;
    }

    /**
     * 审批通过日期
     */
    public void setApproveTime(java.util.Date approveTime) {
        this.approveTime = approveTime;
    }
    /**
     * 经办人部门id
     */
    @ReferSerialTransfer(referCode = "idm-dept")
    public java.lang.Long getAgentdeptId() {
        return agentdeptId;
    }

    /**
     * 经办人部门id
     */
    @ReferDeserialTransfer
    public void setAgentdeptId(java.lang.Long agentdeptId) {
        this.agentdeptId = agentdeptId;
    }
    /**
     * 经办人部门
     */
    public java.lang.String getAgentdeptName() {
        return agentdeptName;
    }

    /**
     * 经办人部门
     */
    public void setAgentdeptName(java.lang.String agentdeptName) {
        this.agentdeptName = agentdeptName;
    }
    /**
     * 单据日期
     */
    public java.util.Date getBillsTime() {
        return billsTime;
    }

    /**
     * 单据日期
     */
    public void setBillsTime(java.util.Date billsTime) {
        this.billsTime = billsTime;
    }
    /**
     * 项目编码
     */
    public java.lang.String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编码
     */
    public void setProjectCode(java.lang.String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 项目id
     */
    @ReferSerialTransfer(referCode="ejc-zjkj-project")
    public java.lang.Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    @ReferDeserialTransfer
    public void setProjectId(java.lang.Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public java.lang.String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(java.lang.String projectName) {
        this.projectName = projectName;
    }
    /**
     * 所属组织id
     */
    public java.lang.Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织id
     */
    public void setOrgId(java.lang.Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 所属组织名称
     */
    public java.lang.String getOrgName() {
        return orgName;
    }

    /**
     * 所属组织名称
     */
    public void setOrgName(java.lang.String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部id
     */
    public java.lang.Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    /**
     * 项目部id
     */
    public void setProjectDepartmentId(java.lang.Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    /**
     * 变更单据id
     */
    public java.lang.Long getChangeId() {
        return changeId;
    }

    /**
     * 变更单据id
     */
    public void setChangeId(java.lang.Long changeId) {
        this.changeId = changeId;
    }
    /**
     * 变更状态，1:未变更;2:变更中;3:已变更
     */
    public java.lang.String getChangeState() {
        return changeState;
    }

    /**
     * 变更状态，1:未变更;2:变更中;3:已变更
     */
    public void setChangeState(java.lang.String changeState) {
        this.changeState = changeState;
    }
    /**
     * 备注
     */
    public java.lang.String getRemarks() {
        return remarks;
    }

    /**
     * 备注
     */
    public void setRemarks(java.lang.String remarks) {
        this.remarks = remarks;
    }
    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode="idm-user")
    public java.lang.Long getAgentId() {
        return agentId;
    }

    /**
     * 经办人
     */
    @ReferDeserialTransfer
    public void setAgentId(java.lang.Long agentId) {
        this.agentId = agentId;
    }
    /**
     * 经办人姓名
     */
    public java.lang.String getAgentName() {
        return agentName;
    }

    /**
     * 经办人姓名
     */
    public void setAgentName(java.lang.String agentName) {
        this.agentName = agentName;
    }
    /**
     * 库管员签字
     */
    public java.lang.String getSignatureKeeper() {
        return signatureKeeper;
    }

    /**
     * 库管员签字
     */
    public void setSignatureKeeper(java.lang.String signatureKeeper) {
        this.signatureKeeper = signatureKeeper;
    }
    /**
     * 项目物资部
     */
    public java.lang.String getProjectDepartment() {
        return projectDepartment;
    }

    /**
     * 项目物资部
     */
    public void setProjectDepartment(java.lang.String projectDepartment) {
        this.projectDepartment = projectDepartment;
    }
    /**
     * 项目工程部
     */
    public java.lang.String getProjectEngineer() {
        return projectEngineer;
    }

    /**
     * 项目工程部
     */
    public void setProjectEngineer(java.lang.String projectEngineer) {
        this.projectEngineer = projectEngineer;
    }
    /**
     * 商务部
     */
    public java.lang.String getCommerce() {
        return commerce;
    }

    /**
     * 商务部
     */
    public void setCommerce(java.lang.String commerce) {
        this.commerce = commerce;
    }
    /**
     * 审批日期
     */
    public java.util.Date getApprovalDate() {
        return approvalDate;
    }

    /**
     * 审批日期
     */
    public void setApprovalDate(java.util.Date approvalDate) {
        this.approvalDate = approvalDate;
    }

    public List<MaterialinventorydetailVO> getMaterialinventorydetailEntities() {
        return materialinventorydetailEntities;
    }

    public void setMaterialinventorydetailEntities(List<MaterialinventorydetailVO> materialinventorydetailEntities) {
        this.materialinventorydetailEntities = materialinventorydetailEntities;
    }

    public java.util.Date getDataDate() {
        return dataDate;
    }

    public void setDataDate(java.util.Date dataDate) {
        this.dataDate = dataDate;
    }

    public String getNum() {
        return num;
    }

    public void setNum(String num) {
        this.num = num;
    }

    public String getCreateTimeShow() {
        return createTimeShow;
    }

    public void setCreateTimeShow(String createTimeShow) {
        this.createTimeShow = createTimeShow;
    }

    public String getBillStateStr() {
        return billStateStr;
    }

    public void setBillStateStr(String billStateStr) {
        this.billStateStr = billStateStr;
    }

    public String getResultDateShow() {
        return resultDateShow;
    }

    public void setResultDateShow(String resultDateShow) {
        this.resultDateShow = resultDateShow;
    }

    @ReferSerialTransfer(referCode="StoreRef")
    public Long getStoreId() {
        return storeId;
    }

    @ReferDeserialTransfer
    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }

    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }
}
