package com.ejianc.business.material.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.material.vo.MonthOrgDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 物资消耗月度分析表-组织
 * 
 * @author generator
 * 
 */
public class MonthOrgVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private String billCode; // 单据编号
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private Long orgId; // 组织id
    private String orgName; // 组织name
    private Long projectDepartmentId; // 项目部id
    private String memo; // 备注
    private Long agentId; // 经办人
    private String agentName; // 经办人姓名
    private Long deptId; // 经办部门id
    private String deptName; // 经办部门名称
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date month; // 月份
    
    private List<MonthOrgDetailVO> monthOrgDetailList = new ArrayList<>(); // 物资消耗月度分析表-组织子表

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    /**
     * 经办人
     */
    @ReferSerialTransfer(referCode="idm-user")
    public java.lang.Long getAgentId() {
        return agentId;
    }

    /**
     * 经办人
     */
    @ReferDeserialTransfer
    public void setAgentId(java.lang.Long agentId) {
        this.agentId = agentId;
    }
    public String getAgentName() {
        return agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }
    public Long getDeptId() {
        return deptId;
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }
    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }
    public Date getMonth() {
        return month;
    }

    public void setMonth(Date month) {
        this.month = month;
    }
    
     public List<MonthOrgDetailVO> getMonthOrgDetailList() {
        return monthOrgDetailList;
     }

     public void setMonthOrgDetailList(List<MonthOrgDetailVO> monthOrgDetailList) {
        this.monthOrgDetailList = monthOrgDetailList;
     }
}
