package com.ejianc.business.outputValue.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.outputValue.bean.*;
import com.ejianc.business.outputValue.service.*;
import com.ejianc.business.outputValue.vo.*;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

/**
 * 公司月度产值录入变更
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("companyMonthChange")
public class CompanyMonthChangeController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ICompanyMonthChangeService changeService;
    @Autowired
    private ICompanyMonthProjectDetailChangeService detailChangeService;
    @Autowired
    private ICompanyMonthService companyMonthService;
    @Autowired
    private ICompanyMonthProjectDetailService detailService;
    @Autowired
    private ICompanyMonthRecordService recordService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CompanyMonthChangeVO> saveOrUpdate(@RequestBody CompanyMonthChangeVO vo) {
        return changeService.saveChange(vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CompanyMonthChangeVO> queryDetail(Long id) {
    	CompanyMonthChangeEntity entity = changeService.selectById(id);
        QueryWrapper<CompanyMonthProjectDetailChangeEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("change_id", id);
        wrapper.orderByAsc("pc_factory");
        wrapper.orderByDesc("create_time");
        List<CompanyMonthProjectDetailChangeEntity> list = detailChangeService.list(wrapper);
        entity.setDetailList(list);
    	CompanyMonthChangeVO vo = BeanMapper.map(entity, CompanyMonthChangeVO.class);

        //当前单据变更过则显示变更记录
        QueryWrapper<CompanyMonthRecordEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.eq("company_month_id", id);
        List<CompanyMonthRecordEntity> records = recordService.list(queryWrapper);
        if(records!=null&&records.size()>0){
            vo.setRecordList(BeanMapper.mapList(records, CompanyBusinessQuotaRecordVO.class));
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CompanyMonthChangeVO> vos) {
        return changeService.delete(vos);
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CompanyMonthChangeVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("orgShortName");
        fuzzyFields.add("year");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(param.getParams().get("companyMonthId")==null){
            throw new BusinessException("缺少公司月度产值录入id");
        }
        IPage<CompanyMonthChangeEntity> page = changeService.queryPage(param,false);
        IPage<CompanyMonthChangeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), CompanyMonthChangeVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 初始化更详情页面
     *
     * @param
     * @return
     */
    @GetMapping(value = "queryDetailByCompanyMonthId")
    public CommonResponse<CompanyMonthChangeVO> queryDetailByCompanyMonthId(@RequestParam(value = "companyMonthId") Long companyMonthId) {
        CompanyMonthEntity entity = companyMonthService.selectById(companyMonthId);
        List<CompanyMonthProjectDetailVO> list = detailService.queryProjectByOrgId(entity.getOrgId(), entity.getYear(), entity.getMonth());

        CompanyMonthChangeVO changeVO = BeanMapper.map(entity, CompanyMonthChangeVO.class);
        changeVO.setCompanyMonthId(companyMonthId);
        changeVO.setBillState(null);
        changeVO.setCreateTime(null);
        changeVO.setCreateUserCode(null);
        changeVO.setTenantId(null);
        changeVO.setUpdateTime(null);
        changeVO.setId(null);
        changeVO.setUpdateUserCode(null);
        if(list != null && list.size()>0){
            List<CompanyMonthProjectDetailChangeVO> vos = new ArrayList<>();
            for(CompanyMonthProjectDetailVO vo : list){
                vo.setCreateTime(null);
                vo.setCreateUserCode(null);
                vo.setTenantId(null);
                vo.setUpdateTime(null);
                vo.setId(IdWorker.getId());
                vo.setUpdateUserCode(null);
                vo.setRowState("add");
                vos.add(BeanMapper.map(vo, CompanyMonthProjectDetailChangeVO.class));
            }
            changeVO.setDetailList(vos);
        }
        return CommonResponse.success("查询详情成功！", changeVO);

    }
}
