package com.ejianc.business.outputValue.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.outputValue.bean.*;
import com.ejianc.business.outputValue.service.*;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.support.idworker.util.IdWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

@Service("companyMonthChange") 
public class CompanyMonthChangeBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	private static final String COMPANYMONTH_SOURCETYPE = "companyMonth";//合同
	private static final String COMPANYMONTH_CHANGE_SOURCETYPE = "companyMonthChange";//变更
	private static final String COMPANYMONTH_RECORD_SOURCETYPE = "companyMonthRecord";//记录

	private static final String COMPANYMONTH_BILLTYPE_CODE = "EJCBT202503000025";
	private static final String COMPANYMONTH_CHANGE_BILLTYPE_CODE = "EJCBT202503000026";
	private static final String COMPANYMONTH_RECORD_BILLTYPE_CODE = "EJCBT202503000027";

	@Autowired
	private IAttachmentApi attachmentApi;
	@Autowired
	private ICompanyMonthService companyMonthService;
	@Autowired
	private ICompanyMonthChangeService changeService;

	@Autowired
	private ICompanyMonthRecordService recordService;
	@Autowired
	private ICompanyMonthProjectDetailChangeService detailChangeService;
	@Autowired
	private IPcMonthActualOutputValueService pcMonthService;
	@Autowired
	private IProjectMonthActualOutputValueService projectMonthService;
	@Autowired
	private ICompanyBusinessQuotaService companyBusinessQuotaService;

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {

		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	public void clearBaseData(BaseEntity entity){
//		entity.setCreateTime(null);
//		entity.setCreateUserCode(null);
		entity.setTenantId(null);
		entity.setUpdateTime(null);
		entity.setUpdateUserCode(null);
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		//1、获取目前合同信息、变更信息
		CompanyMonthChangeEntity changeEntity = changeService.selectById(billId);
		CompanyMonthEntity companyMonthEntity = companyMonthService.selectById(changeEntity.getCompanyMonthId());

		//获取历史版本条数
		QueryWrapper<CompanyMonthRecordEntity> recordWrapper = new QueryWrapper<>();
		recordWrapper.eq("company_month_id", companyMonthEntity.getId());
		recordWrapper.eq("dr", 0);
		Integer count = recordService.count(recordWrapper);
		//2、生成历史版本
		//2.1、
		CompanyMonthRecordEntity recordEntity = BeanMapper.map(companyMonthEntity, CompanyMonthRecordEntity.class);
		Long recordId = IdWorker.getId();
		this.clearBaseData(recordEntity);
		recordEntity.setBillState(null);
		recordEntity.setCompanyMonthId(companyMonthEntity.getId());
		recordEntity.setBillVersion(String.valueOf(count+1));
		recordEntity.setId(recordId);
		recordEntity.setChangeReason(changeEntity.getChangeReason());
		List<CompanyMonthProjectDetailEntity> detailList = companyMonthEntity.getDetailList();
		if(detailList!=null&&detailList.size()>0){
			List<CompanyMonthProjectDetailRecordEntity> recordDetailList = new ArrayList<>();
			for(CompanyMonthProjectDetailEntity entity : detailList){
				CompanyMonthProjectDetailRecordEntity reEntity = BeanMapper.map(entity, CompanyMonthProjectDetailRecordEntity.class);
				this.clearBaseData(reEntity);
				reEntity.setRecordId(recordId);
				recordDetailList.add(reEntity);
				entity.setRowState("del");
			}
			recordEntity.setDetailList(recordDetailList);
		}


		//复制合同附件信息到记录中
		String sourceBillType = COMPANYMONTH_BILLTYPE_CODE;
		String targetBillType = COMPANYMONTH_RECORD_BILLTYPE_CODE;
		attachmentApi.copyFilesFromSourceBillToTargetBill(companyMonthEntity.getId().toString(), sourceBillType, COMPANYMONTH_SOURCETYPE, recordId.toString(), targetBillType, COMPANYMONTH_RECORD_SOURCETYPE);
		recordService.saveOrUpdate(recordEntity, false);
		logger.info("---------生成合同信息完成--------");
		//3、修改当前合同信息
		CompanyMonthEntity newContractEntity = BeanMapper.map(changeEntity, CompanyMonthEntity.class);
		newContractEntity.setChangeState("3");//状态改为已变更
		newContractEntity.setChangeId(null);
		newContractEntity.setBillCode(companyMonthEntity.getBillCode());
		newContractEntity.setBillState(companyMonthEntity.getBillState());
		newContractEntity.setId(companyMonthEntity.getId());
		newContractEntity.setCreateTime(companyMonthEntity.getCreateTime());
		newContractEntity.setCreateUserCode(companyMonthEntity.getCreateUserCode());
		newContractEntity.setTenantId(companyMonthEntity.getTenantId());
		newContractEntity.setVersion(companyMonthEntity.getVersion());
		newContractEntity.setEffectLastDate(new Date());

		List<CompanyMonthProjectDetailChangeEntity> changeDetailList = changeEntity.getDetailList();
		if(changeDetailList!=null&&changeDetailList.size()>0){
			List<CompanyMonthProjectDetailEntity> newDetailList = BeanMapper.mapList(changeDetailList, CompanyMonthProjectDetailEntity.class);
			newDetailList.addAll(detailList);
			newContractEntity.setDetailList(newDetailList);
		}

		companyMonthService.saveOrUpdate(newContractEntity, false);
		//复制合同附件信息到记录中
		sourceBillType = COMPANYMONTH_CHANGE_BILLTYPE_CODE;
		targetBillType = COMPANYMONTH_BILLTYPE_CODE;
		attachmentApi.copyFilesFromSourceBillToTargetBill(changeEntity.getId().toString(), sourceBillType, COMPANYMONTH_CHANGE_SOURCETYPE, companyMonthEntity.getId().toString(), targetBillType, COMPANYMONTH_SOURCETYPE);

		//更新相应的数据到项目/工厂月度产值中
		QueryWrapper<CompanyMonthProjectDetailChangeEntity> wrapper = new QueryWrapper<>();
		wrapper.eq("change_id", billId);
		List<CompanyMonthProjectDetailChangeEntity> list = detailChangeService.list(wrapper);
		if(list!=null && list.size()>0){
			List<Long> projectIds = new ArrayList<>();
			List<Long> pcIds = new ArrayList<>();
			Map<Long, CompanyMonthProjectDetailChangeEntity> projectMap = new HashMap<>();
			Map<Long, CompanyMonthProjectDetailChangeEntity> pcMap = new HashMap<>();
			for(CompanyMonthProjectDetailChangeEntity detailEntity : list){
				if(detailEntity.getPcFactory()!=null && detailEntity.getPcFactory()){
					//工厂
					if(detailEntity.getThisMonthActualOutputValueAdjust()!=null){
						pcIds.add(detailEntity.getProjectActualId());
						pcMap.put(detailEntity.getProjectActualId(), detailEntity);
					}
				}else{
					//项目
					if(detailEntity.getThisMonthActualOutputValueAdjust()!=null || detailEntity.getThisMonthConfirmedOutputValueAdjust()!=null){
						projectIds.add(detailEntity.getProjectActualId());
						projectMap.put(detailEntity.getProjectActualId(), detailEntity);
					}
				}
			}
			if(projectIds!=null && projectIds.size()>0){
				List<ProjectMonthActualOutputValueEntity> projectList = (List<ProjectMonthActualOutputValueEntity>) projectMonthService.listByIds(projectIds);
				for(ProjectMonthActualOutputValueEntity entity : projectList){
					entity.setThisMonthActualOutputValue(projectMap.get(entity.getId()).getThisMonthActualOutputValueAdjust());
					entity.setThisMonthConfirmedOutputValue(projectMap.get(entity.getId()).getThisMonthConfirmedOutputValueAdjust());
				}
				projectMonthService.saveOrUpdateBatch(projectList, projectList.size(), false);
			}
			if(pcIds!=null && pcIds.size()>0){
				List<PcMonthActualOutputValueEntity> pcList = (List<PcMonthActualOutputValueEntity>) pcMonthService.listByIds(pcIds);
				for(PcMonthActualOutputValueEntity entity : pcList){
					entity.setThisMonthCompletedTotalOutputValue(projectMap.get(entity.getId()).getThisMonthActualOutputValueAdjust());
				}
				pcMonthService.saveOrUpdateBatch(pcList, pcList.size(), false);
			}
			//更新公司经营指标---先判断该组织是否存在单据，存在则修改
			companyBusinessQuotaService.updateProjectPcInfo(changeEntity.getOrgId(), changeEntity.getYear());
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		// 参数是单据类型编码字符串 根据需求是否打开下面代码
        /**CommonResponse<String> resp = billTypeApi.checkQuote(billTypeCode, billId);
        if(!resp.isSuccess()){
            return CommonResponse.error("无法撤回！"+resp.getMsg());
        }*/
		return CommonResponse.success();
	}

}
