package com.ejianc.business.outputValue.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.outputValue.bean.CompanyMonthProjectDetailEntity;
import com.ejianc.business.outputValue.bean.PcMonthActualOutputValueEntity;
import com.ejianc.business.outputValue.bean.ProjectMonthActualOutputValueEntity;
import com.ejianc.business.outputValue.mapper.CompanyMonthProjectDetailMapper;
import com.ejianc.business.outputValue.service.ICompanyMonthProjectDetailService;
import com.ejianc.business.outputValue.service.IPcMonthActualOutputValueService;
import com.ejianc.business.outputValue.service.IProjectMonthActualOutputValueService;
import com.ejianc.business.outputValue.vo.CompanyMonthProjectDetailVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * 公司月度产值录入-项目
 * 
 * @author generator
 * 
 */
@Service("companyMonthProjectDetailService")
public class CompanyMonthProjectDetailServiceImpl extends BaseServiceImpl<CompanyMonthProjectDetailMapper, CompanyMonthProjectDetailEntity> implements ICompanyMonthProjectDetailService{

    @Autowired
    private IPcMonthActualOutputValueService pcMonthService;
    @Autowired
    private IProjectMonthActualOutputValueService projectMonthService;

    @Override
    public List<CompanyMonthProjectDetailVO> queryProjectByOrgId(Long orgId, String year, String month) {
        List<CompanyMonthProjectDetailVO> vos = new ArrayList<>();
        QueryWrapper<ProjectMonthActualOutputValueEntity> projectMonthActualWrapper = new QueryWrapper<>();
        projectMonthActualWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
        projectMonthActualWrapper.in("bill_state", 1,3);
        projectMonthActualWrapper.eq("year", year);
        projectMonthActualWrapper.eq("month", month);
        projectMonthActualWrapper.eq("two_org_id", orgId);
        List<ProjectMonthActualOutputValueEntity> projectMonthActualAllList = projectMonthService.list(projectMonthActualWrapper);
        for(ProjectMonthActualOutputValueEntity entity : projectMonthActualAllList){
            CompanyMonthProjectDetailVO vo = new CompanyMonthProjectDetailVO();
            vo.setProjectName(entity.getProjectName());
            vo.setProjectId(entity.getProjectId());
            vo.setProjectActualId(entity.getId());
            vo.setPcFactory(0);
            vo.setThisMonthActualOutputValue(entity.getThisMonthActualOutputValue());
            vo.setThisMonthConfirmedOutputValue(entity.getThisMonthConfirmedOutputValue());
            vos.add(vo);
        }

        QueryWrapper<PcMonthActualOutputValueEntity> pcMonthActualWrapper = new QueryWrapper<>();
        pcMonthActualWrapper.eq("tenant_id", InvocationInfoProxy.getTenantid());
        pcMonthActualWrapper.in("bill_state", 1,3);
        pcMonthActualWrapper.eq("year", year);
        projectMonthActualWrapper.eq("month", month);
        projectMonthActualWrapper.eq("two_org_id", orgId);
        List<PcMonthActualOutputValueEntity> pcMonthActualAllList = pcMonthService.list(pcMonthActualWrapper);
        for(PcMonthActualOutputValueEntity entity : pcMonthActualAllList){
            CompanyMonthProjectDetailVO vo = new CompanyMonthProjectDetailVO();
            vo.setProjectName(entity.getProjectName());
            vo.setProjectId(entity.getProjectId());
            vo.setProjectActualId(entity.getId());
            vo.setPcFactory(1);
            vo.setThisMonthActualOutputValue(entity.getThisMonthCompletedTotalOutputValue());
            vos.add(vo);
        }
        return vos;
    }
}
