package com.ejianc.business.outputValue.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 公司经营指标 （产值）
 *
 * @author generator
 *
 */
public class CompanyBusinessQuotaRecordVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String changeReason; // 变更原因
    private Long dataId; // 项目补充信息id
    private String billVersion; // 单据版本
    private String billCode; // 单据编号
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private String orgShortName; // 区域简称
    private String year; // 年度

    private BigDecimal thisYearRevenueQuota; // 本年下达的营业收入指标(亿元)
    private Long lastYearCompletedProjectNumber; // 上年竣工项目数（个）
    private BigDecimal lastYearCompletedSpace; // 上年竣工面积（万平米）
    private BigDecimal lastYearProjectConfirmedOutputValue; // 上年项目确认产值(亿元)
    private BigDecimal lastYearProjectCompletedOutputValue; // 上年项目完成产值(亿元)
    private Long lastYearStartWorkProjectNumber; // 上年开工项目数（个）
    private BigDecimal lastYearStartWorkSpace; // 上年开工面积（万平米）
    private BigDecimal lastYearPcOutputValue; // 上年PC工厂产值(亿元)
    private BigDecimal lastYearCompleteTotalOutputValue; // 上年完成总产值(亿元)
    private BigDecimal thisYearPlanFirstQuarter; // 本年计划产值-一季度产值计划(亿元)
    private BigDecimal thisYearPlanSecondQuarter; // 本年计划产值-二季度产值计划(亿元)
    private BigDecimal thisYearPlanThirdQuarter; // 本年计划产值-三季度产值计划(亿元)
    private BigDecimal thisYearPlanFurthQuarter; // 本年计划产值-四季度产值计划(亿元)
    private BigDecimal thisYearPlanUndertakeOutputValue; // 本年计划产值-新承接项目计划完成产值(亿元)
    private BigDecimal thisYearPlanBuildingOutputValue; // 本年计划产值-在施项目计划完成产值(亿元)
    private BigDecimal thisYearPlanPcOutputValue; // 本年计划产值-PC工厂计划完成产值(亿元)
    private BigDecimal thisYearPlanTotalOutputValue; // 本年计划产值-总计划完成产值(亿元)
    private String thisYearPlanBusinessIndicatorDescription; // 本年计划产值-经营指标描述
    private String thisYearPlanResponsibilityLetter; // 本年计划产值-责任书
    private BigDecimal thisYearCompleteTotalOutputValue; // 本年完成产值-总完成产值(亿元)
    private BigDecimal thisYearCompleteProjectOutputValue; // 本年完成产值-项目完成产值(亿元)
    private BigDecimal thisYearCompleteProjectConfirmedOutputValue; // 本年完成产值-项目确认产值(亿元)
    private Long thisYearCompleteBuildingProjectNumber; // 本年完成产值-在施项目数（个）
    private BigDecimal thisYearCompletePcOutputValue; // 本年完成产值-PC工厂完成产值(亿元)
    private BigDecimal thisYearCompleteStartWorkSpace; // 本年完成产值-开工面积(万平米)
    private BigDecimal thisYearCompleteCompletedSpace; // 本年完成产值-竣工面积(万平米)
    private BigDecimal thisYearCompleteBuildingSpace; // 本年完成产值-施工面积（万平方米）
    private BigDecimal thisYearCompleteBuildingProjectContractSurplus; // 本年完成产值-在施项目合同余量(亿元)
    private BigDecimal thisYearCompleteBuildingProjectContractAmount; // 本年完成产值-在施项目合同额(亿元)

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date effectLastDate; // 最后生效日期

    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    public Long getDataId() {
        return dataId;
    }

    public void setDataId(Long dataId) {
        this.dataId = dataId;
    }

    public String getBillVersion() {
        return billVersion;
    }

    public void setBillVersion(String billVersion) {
        this.billVersion = billVersion;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public String getOrgShortName() {
        return orgShortName;
    }

    public void setOrgShortName(String orgShortName) {
        this.orgShortName = orgShortName;
    }

    public String getYear() {
        return year;
    }

    public void setYear(String year) {
        this.year = year;
    }

    public BigDecimal getThisYearRevenueQuota() {
        return thisYearRevenueQuota;
    }

    public void setThisYearRevenueQuota(BigDecimal thisYearRevenueQuota) {
        this.thisYearRevenueQuota = thisYearRevenueQuota;
    }

    public Long getLastYearCompletedProjectNumber() {
        return lastYearCompletedProjectNumber;
    }

    public void setLastYearCompletedProjectNumber(Long lastYearCompletedProjectNumber) {
        this.lastYearCompletedProjectNumber = lastYearCompletedProjectNumber;
    }

    public BigDecimal getLastYearCompletedSpace() {
        return lastYearCompletedSpace;
    }

    public void setLastYearCompletedSpace(BigDecimal lastYearCompletedSpace) {
        this.lastYearCompletedSpace = lastYearCompletedSpace;
    }

    public BigDecimal getLastYearProjectConfirmedOutputValue() {
        return lastYearProjectConfirmedOutputValue;
    }

    public void setLastYearProjectConfirmedOutputValue(BigDecimal lastYearProjectConfirmedOutputValue) {
        this.lastYearProjectConfirmedOutputValue = lastYearProjectConfirmedOutputValue;
    }

    public BigDecimal getLastYearProjectCompletedOutputValue() {
        return lastYearProjectCompletedOutputValue;
    }

    public void setLastYearProjectCompletedOutputValue(BigDecimal lastYearProjectCompletedOutputValue) {
        this.lastYearProjectCompletedOutputValue = lastYearProjectCompletedOutputValue;
    }

    public Long getLastYearStartWorkProjectNumber() {
        return lastYearStartWorkProjectNumber;
    }

    public void setLastYearStartWorkProjectNumber(Long lastYearStartWorkProjectNumber) {
        this.lastYearStartWorkProjectNumber = lastYearStartWorkProjectNumber;
    }

    public BigDecimal getLastYearStartWorkSpace() {
        return lastYearStartWorkSpace;
    }

    public void setLastYearStartWorkSpace(BigDecimal lastYearStartWorkSpace) {
        this.lastYearStartWorkSpace = lastYearStartWorkSpace;
    }

    public BigDecimal getLastYearPcOutputValue() {
        return lastYearPcOutputValue;
    }

    public void setLastYearPcOutputValue(BigDecimal lastYearPcOutputValue) {
        this.lastYearPcOutputValue = lastYearPcOutputValue;
    }

    public BigDecimal getLastYearCompleteTotalOutputValue() {
        return lastYearCompleteTotalOutputValue;
    }

    public void setLastYearCompleteTotalOutputValue(BigDecimal lastYearCompleteTotalOutputValue) {
        this.lastYearCompleteTotalOutputValue = lastYearCompleteTotalOutputValue;
    }

    public BigDecimal getThisYearPlanFirstQuarter() {
        return thisYearPlanFirstQuarter;
    }

    public void setThisYearPlanFirstQuarter(BigDecimal thisYearPlanFirstQuarter) {
        this.thisYearPlanFirstQuarter = thisYearPlanFirstQuarter;
    }

    public BigDecimal getThisYearPlanSecondQuarter() {
        return thisYearPlanSecondQuarter;
    }

    public void setThisYearPlanSecondQuarter(BigDecimal thisYearPlanSecondQuarter) {
        this.thisYearPlanSecondQuarter = thisYearPlanSecondQuarter;
    }

    public BigDecimal getThisYearPlanThirdQuarter() {
        return thisYearPlanThirdQuarter;
    }

    public void setThisYearPlanThirdQuarter(BigDecimal thisYearPlanThirdQuarter) {
        this.thisYearPlanThirdQuarter = thisYearPlanThirdQuarter;
    }

    public BigDecimal getThisYearPlanFurthQuarter() {
        return thisYearPlanFurthQuarter;
    }

    public void setThisYearPlanFurthQuarter(BigDecimal thisYearPlanFurthQuarter) {
        this.thisYearPlanFurthQuarter = thisYearPlanFurthQuarter;
    }

    public BigDecimal getThisYearPlanUndertakeOutputValue() {
        return thisYearPlanUndertakeOutputValue;
    }

    public void setThisYearPlanUndertakeOutputValue(BigDecimal thisYearPlanUndertakeOutputValue) {
        this.thisYearPlanUndertakeOutputValue = thisYearPlanUndertakeOutputValue;
    }

    public BigDecimal getThisYearPlanBuildingOutputValue() {
        return thisYearPlanBuildingOutputValue;
    }

    public void setThisYearPlanBuildingOutputValue(BigDecimal thisYearPlanBuildingOutputValue) {
        this.thisYearPlanBuildingOutputValue = thisYearPlanBuildingOutputValue;
    }

    public BigDecimal getThisYearPlanPcOutputValue() {
        return thisYearPlanPcOutputValue;
    }

    public void setThisYearPlanPcOutputValue(BigDecimal thisYearPlanPcOutputValue) {
        this.thisYearPlanPcOutputValue = thisYearPlanPcOutputValue;
    }

    public BigDecimal getThisYearPlanTotalOutputValue() {
        return thisYearPlanTotalOutputValue;
    }

    public void setThisYearPlanTotalOutputValue(BigDecimal thisYearPlanTotalOutputValue) {
        this.thisYearPlanTotalOutputValue = thisYearPlanTotalOutputValue;
    }

    public String getThisYearPlanBusinessIndicatorDescription() {
        return thisYearPlanBusinessIndicatorDescription;
    }

    public void setThisYearPlanBusinessIndicatorDescription(String thisYearPlanBusinessIndicatorDescription) {
        this.thisYearPlanBusinessIndicatorDescription = thisYearPlanBusinessIndicatorDescription;
    }

    public String getThisYearPlanResponsibilityLetter() {
        return thisYearPlanResponsibilityLetter;
    }

    public void setThisYearPlanResponsibilityLetter(String thisYearPlanResponsibilityLetter) {
        this.thisYearPlanResponsibilityLetter = thisYearPlanResponsibilityLetter;
    }

    public BigDecimal getThisYearCompleteTotalOutputValue() {
        return thisYearCompleteTotalOutputValue;
    }

    public void setThisYearCompleteTotalOutputValue(BigDecimal thisYearCompleteTotalOutputValue) {
        this.thisYearCompleteTotalOutputValue = thisYearCompleteTotalOutputValue;
    }

    public BigDecimal getThisYearCompleteProjectOutputValue() {
        return thisYearCompleteProjectOutputValue;
    }

    public void setThisYearCompleteProjectOutputValue(BigDecimal thisYearCompleteProjectOutputValue) {
        this.thisYearCompleteProjectOutputValue = thisYearCompleteProjectOutputValue;
    }

    public BigDecimal getThisYearCompleteProjectConfirmedOutputValue() {
        return thisYearCompleteProjectConfirmedOutputValue;
    }

    public void setThisYearCompleteProjectConfirmedOutputValue(BigDecimal thisYearCompleteProjectConfirmedOutputValue) {
        this.thisYearCompleteProjectConfirmedOutputValue = thisYearCompleteProjectConfirmedOutputValue;
    }

    public Long getThisYearCompleteBuildingProjectNumber() {
        return thisYearCompleteBuildingProjectNumber;
    }

    public void setThisYearCompleteBuildingProjectNumber(Long thisYearCompleteBuildingProjectNumber) {
        this.thisYearCompleteBuildingProjectNumber = thisYearCompleteBuildingProjectNumber;
    }

    public BigDecimal getThisYearCompletePcOutputValue() {
        return thisYearCompletePcOutputValue;
    }

    public void setThisYearCompletePcOutputValue(BigDecimal thisYearCompletePcOutputValue) {
        this.thisYearCompletePcOutputValue = thisYearCompletePcOutputValue;
    }

    public BigDecimal getThisYearCompleteStartWorkSpace() {
        return thisYearCompleteStartWorkSpace;
    }

    public void setThisYearCompleteStartWorkSpace(BigDecimal thisYearCompleteStartWorkSpace) {
        this.thisYearCompleteStartWorkSpace = thisYearCompleteStartWorkSpace;
    }

    public BigDecimal getThisYearCompleteCompletedSpace() {
        return thisYearCompleteCompletedSpace;
    }

    public void setThisYearCompleteCompletedSpace(BigDecimal thisYearCompleteCompletedSpace) {
        this.thisYearCompleteCompletedSpace = thisYearCompleteCompletedSpace;
    }

    public BigDecimal getThisYearCompleteBuildingSpace() {
        return thisYearCompleteBuildingSpace;
    }

    public void setThisYearCompleteBuildingSpace(BigDecimal thisYearCompleteBuildingSpace) {
        this.thisYearCompleteBuildingSpace = thisYearCompleteBuildingSpace;
    }

    public BigDecimal getThisYearCompleteBuildingProjectContractSurplus() {
        return thisYearCompleteBuildingProjectContractSurplus;
    }

    public void setThisYearCompleteBuildingProjectContractSurplus(BigDecimal thisYearCompleteBuildingProjectContractSurplus) {
        this.thisYearCompleteBuildingProjectContractSurplus = thisYearCompleteBuildingProjectContractSurplus;
    }

    public BigDecimal getThisYearCompleteBuildingProjectContractAmount() {
        return thisYearCompleteBuildingProjectContractAmount;
    }

    public void setThisYearCompleteBuildingProjectContractAmount(BigDecimal thisYearCompleteBuildingProjectContractAmount) {
        this.thisYearCompleteBuildingProjectContractAmount = thisYearCompleteBuildingProjectContractAmount;
    }

    public Date getEffectLastDate() {
        return effectLastDate;
    }

    public void setEffectLastDate(Date effectLastDate) {
        this.effectLastDate = effectLastDate;
    }
}
