package com.ejianc.business.outputValue.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 公司月度产值录入
 * 
 * @author generator
 * 
 */
public class CompanyMonthVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态
    private String billCode; // 单据编码
    private Long orgId; // 区域公司
    private String orgName; // 区域公司名称
    private String orgShortName; // 区域简称
    private String year; // 年度
    private String month; // 月份
    private BigDecimal thisYearActualTotalOutputValue; // 本年累计完成产值合计（万元）
    private BigDecimal thisYearConfirmedOutputValue; // 本年累计确认产值合计（万元）
    private Long changeId; // 变更单id
    private String changeState; // 变更状态1未变更、2变更中、3已变更
    private Date effectLastDate; // 生效日期
    
    private List<CompanyMonthProjectDetailVO> detailList = new ArrayList<>(); // 公司月度产值录入-项目
    private List<CompanyBusinessQuotaRecordVO> recordList = new ArrayList<>();

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgShortName() {
        return orgShortName;
    }

    public void setOrgShortName(String orgShortName) {
        this.orgShortName = orgShortName;
    }
    public String getYear() {
        return year;
    }

    public void setYear(String year) {
        this.year = year;
    }
    public String getMonth() {
        return month;
    }

    public void setMonth(String month) {
        this.month = month;
    }
    public BigDecimal getThisYearActualTotalOutputValue() {
        return thisYearActualTotalOutputValue;
    }

    public void setThisYearActualTotalOutputValue(BigDecimal thisYearActualTotalOutputValue) {
        this.thisYearActualTotalOutputValue = thisYearActualTotalOutputValue;
    }
    public BigDecimal getThisYearConfirmedOutputValue() {
        return thisYearConfirmedOutputValue;
    }

    public void setThisYearConfirmedOutputValue(BigDecimal thisYearConfirmedOutputValue) {
        this.thisYearConfirmedOutputValue = thisYearConfirmedOutputValue;
    }
    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    public String getChangeState() {
        return changeState;
    }

    public void setChangeState(String changeState) {
        this.changeState = changeState;
    }
    public Date getEffectLastDate() {
        return effectLastDate;
    }

    public void setEffectLastDate(Date effectLastDate) {
        this.effectLastDate = effectLastDate;
    }

    public List<CompanyMonthProjectDetailVO> getDetailList() {
        return detailList;
    }

    public void setDetailList(List<CompanyMonthProjectDetailVO> detailList) {
        this.detailList = detailList;
    }

    public List<CompanyBusinessQuotaRecordVO> getRecordList() {
        return recordList;
    }

    public void setRecordList(List<CompanyBusinessQuotaRecordVO> recordList) {
        this.recordList = recordList;
    }
}
