package com.ejianc.business.panhuo.shelf.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.material.bean.FlowmeterEntity;
import com.ejianc.business.material.service.IFlowmeterService;
import com.ejianc.business.material.service.IRealtimebalanceService;
import com.ejianc.business.material.service.IStoreService;
import com.ejianc.business.panhuo.shelf.bean.GoodsEntity;
import com.ejianc.business.panhuo.shelf.mapper.GoodsMapper;
import com.ejianc.business.panhuo.shelf.service.IGoodsService;
import com.ejianc.foundation.cons.PlanConstant;
import com.ejianc.foundation.panhuo.shelf.vo.GoodsVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 物资集市
 *
 * @author generator
 */
@Service("goodsService")
public class GoodsServiceImpl extends BaseServiceImpl<GoodsMapper, GoodsEntity> implements IGoodsService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IStoreService storeService;

    @Autowired
    private IFlowmeterService flowmeterService;

    @Autowired
    private IRealtimebalanceService realtimebalanceService;

    @Autowired
    private SessionManager sessionManager;

    @Override
    public Boolean inOutStore(List<GoodsEntity> list) {
        checkNum(list);

        ArrayList<FlowmeterEntity> flowVOS = new ArrayList<>();
        for (GoodsEntity goodsEntity : list) {
            FlowmeterEntity flowmeterEntity = new FlowmeterEntity();
            flowmeterEntity.setMid(goodsEntity.getId());
            flowmeterEntity.setDetailId(goodsEntity.getId());
            flowmeterEntity.setMaterialId(goodsEntity.getMaterialId());
            flowmeterEntity.setBillCode(goodsEntity.getMaterialCode());
            flowmeterEntity.setProjectId(goodsEntity.getProjectId());
            flowmeterEntity.setProjectName(goodsEntity.getProjectName());
            flowmeterEntity.setStoreId(goodsEntity.getStoreId());
            flowmeterEntity.setStoreType(goodsEntity.getStoreType());
            flowmeterEntity.setStoreName(goodsEntity.getStoreName());
            //TODO
            flowmeterEntity.setSupplierId(goodsEntity.getCloudStoreId());
            flowmeterEntity.setSupplierName(goodsEntity.getCloudStoreName());

            flowmeterEntity.setMaterialCode(goodsEntity.getMaterialCode());
            flowmeterEntity.setMaterialName(goodsEntity.getMaterialName());
            flowmeterEntity.setSpecialModel(goodsEntity.getSpec());
            flowmeterEntity.setMaterialCategoryId(goodsEntity.getMaterialTypeId());
            flowmeterEntity.setMaterialCategoryCode(goodsEntity.getMaterialTypeCode());
            flowmeterEntity.setMaterialCategoryName(goodsEntity.getMaterialTypeName());
            flowmeterEntity.setBillStatus(BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
            flowmeterEntity.setBillTime(goodsEntity.getCreateTime());
            //TODO
            flowmeterEntity.setSubUnitId(goodsEntity.getCloudStoreId());
            flowmeterEntity.setSubUnitName(goodsEntity.getCloudStoreName());

            flowmeterEntity.setOperationType("出库");
            flowmeterEntity.setAccessType("盘活上架");
            flowmeterEntity.setTime(goodsEntity.getCreateTime());
            flowmeterEntity.setQuantity(goodsEntity.getNum());
            flowmeterEntity.setAmountIncluetax(goodsEntity.getOriginalTaxMny());
            flowmeterEntity.setAmountExcluetax(goodsEntity.getOriginalMny());
            flowmeterEntity.setUnitPriceIncluetax(goodsEntity.getOriginalTaxPrice());
            flowmeterEntity.setUnitPriceExcluetax(goodsEntity.getOriginalPrice());
            flowmeterEntity.setOrgId(goodsEntity.getParentOrgId());
            flowmeterEntity.setOrgName(goodsEntity.getParentOrgName());
            flowmeterEntity.setMeasurementUnit(goodsEntity.getUnitName());
            flowmeterEntity.setProjectDepartmentId(goodsEntity.getOrgId());

            flowmeterEntity.setOutId(goodsEntity.getId());

            flowmeterEntity.setBillType(1);
            flowVOS.add(flowmeterEntity);
        }

        logger.info("调用库存参数：————" + JSONObject.toJSONString(flowVOS));
        flowmeterService.saveOrUpdateBatch(flowVOS);
        //更新实时物资结存表
        for (GoodsEntity entity : list) {
            realtimebalanceService.updateRealtimeBalance(entity.getStoreId());
        }
        return true;
    }

    private void checkNum(List<GoodsEntity> list) {
        QueryWrapper<FlowmeterEntity> wrapper = new QueryWrapper<>();
        wrapper.and(q -> {
            for (GoodsEntity f : list) {
                q.or(iq -> iq.ne("mid", f.getId()).eq("store_id", f.getStoreId()).eq("material_id", f.getMaterialId()));
            }
            return q;
        });
        List<FlowmeterEntity> flowmeterEntities = flowmeterService.list(wrapper);
        Map<String, BigDecimal> numInMap = new HashMap<>();
        Map<String, BigDecimal> numOutMap = new HashMap<>();
        for (FlowmeterEntity flow : flowmeterEntities) {
            String key = flow.getStoreId() + "@" + flow.getMaterialId();
            if (flow.getOperationType().equals("入库")) {
                BigDecimal inNum = numInMap.containsKey(key) ? numInMap.get(key) : BigDecimal.ZERO;
                inNum = ComputeUtil.safeAdd(inNum, flow.getQuantity());
                numInMap.put(key, inNum);
            } else if (flow.getOperationType().equals("出库")) {
                BigDecimal outNum = numOutMap.containsKey(key) ? numOutMap.get(key) : BigDecimal.ZERO;
                outNum = ComputeUtil.safeAdd(outNum, flow.getQuantity());
                numOutMap.put(key, outNum);
            }
        }
        for (GoodsEntity goodsEntity : list) {
            if (null != goodsEntity.getStoreId()) {
                String key = goodsEntity.getStoreId() + "@" + goodsEntity.getMaterialId();
                BigDecimal inNum = numInMap.containsKey(key) ? numInMap.get(key) : BigDecimal.ZERO;
                BigDecimal outNum = numOutMap.containsKey(key) ? numOutMap.get(key) : BigDecimal.ZERO;
                BigDecimal subtract = ComputeUtil.safeSub(inNum, outNum);
                if (ComputeUtil.isGreaterThan(goodsEntity.getNum(), subtract)) {
                    throw new BusinessException("物资编号:" + goodsEntity.getMaterialCode() + ",物资名称:" + goodsEntity.getMaterialName() + "库存不足，不能上架!");
                }
            }
        }
    }

    @Override
    public Boolean inOutStoreRollback(List<GoodsEntity> list) {
        List<Long> idList = list.stream().map(GoodsEntity::getId).collect(Collectors.toList());
        LambdaQueryWrapper<FlowmeterEntity> queryWrapper = new LambdaQueryWrapper<>();
        queryWrapper.in(FlowmeterEntity::getMid, idList);
        queryWrapper.eq(FlowmeterEntity::getBillState, BillStateEnum.UNCOMMITED_STATE.getBillStateCode());
        flowmeterService.remove(queryWrapper);
        for (GoodsEntity entity : list) {
            realtimebalanceService.updateRealtimeBalance(entity.getStoreId());
        }
        return true;
    }

    @Override
    public List<GoodsVO> updateAllotNum(List<GoodsVO> vos, Boolean flag) {
        List<Long> ids = vos.stream().map(GoodsVO::getId).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ids)) {
            return vos;
        }
        Map<Long, GoodsVO> map = vos.stream().collect(Collectors.toMap(x -> x.getId(), x -> x, (v1, v2) -> v2));
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter(QueryParam.IN, ids));
        List<GoodsEntity> list = super.queryList(param);
        for (GoodsEntity entity : list) {
            BigDecimal num = map.get(entity.getId()).getAllotNum();
            if (flag) {
                entity.setAllotNum(ComputeUtil.safeAdd(entity.getAllotNum(), num));
            } else {
                entity.setAllotNum(ComputeUtil.safeSub(entity.getAllotNum(), num));
            }
            entity.setSurplusNum(ComputeUtil.safeSub(entity.getNum(), entity.getAllotedNum(), entity.getAllotNum()));
            if (ComputeUtil.isLessThan(entity.getSurplusNum(), BigDecimal.ZERO)) {
                throw new BusinessException("剩余可调拨数量不能小于0!");
            }
            // 售罄下架
            if (ComputeUtil.isEmpty(entity.getSurplusNum())) {
                entity.setStatus(PlanConstant.GOODS_STATUS_OUT);
                entity.setLowerType(PlanConstant.OUT_TYPE_SALE);//下架类型0-手动下架，1-售罄下架，2-到期下架
                entity.setLowerId(InvocationInfoProxy.getUserid());
                entity.setLowerName(sessionManager.getUserContext().getUserName());
                entity.setLowerCode(InvocationInfoProxy.getUsercode());
                entity.setLowerTime(DateFormater.getCurrentDate());
                entity.setLowerNum(entity.getSurplusNum());
            }
            // 调拨中数量删除则恢复上架
            if (PlanConstant.GOODS_STATUS_OUT.equals(entity.getStatus()) &&
                    ComputeUtil.isGreaterThan(entity.getSurplusNum(), BigDecimal.ZERO)) {
                entity.setStatus(PlanConstant.GOODS_STATUS_ON);
            }
        }
        super.saveOrUpdateBatch(list);
        return BeanMapper.mapList(list, GoodsVO.class);
    }

    @Override
    public List<GoodsVO> updateAllotedNum(List<GoodsVO> vos, Boolean flag) {
        List<Long> ids = vos.stream().map(GoodsVO::getId).filter(Objects::nonNull).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ids)) {
            return vos;
        }
        Map<Long, GoodsVO> map = vos.stream().collect(Collectors.toMap(x -> x.getId(), x -> x, (v1, v2) -> v2));
        QueryParam param = new QueryParam();
        param.getParams().put("id", new Parameter(QueryParam.IN, ids));
        List<GoodsEntity> list = super.queryList(param);
        for (GoodsEntity entity : list) {
            BigDecimal num = map.get(entity.getId()).getAllotedNum();
            if (flag) {
                entity.setAllotedNum(ComputeUtil.safeAdd(entity.getAllotedNum(), num));
            } else {
                entity.setAllotedNum(ComputeUtil.safeSub(entity.getAllotedNum(), num));
            }
            entity.setSurplusNum(ComputeUtil.safeSub(entity.getNum(), entity.getAllotedNum(), entity.getAllotNum()));
            if (ComputeUtil.isLessThan(entity.getSurplusNum(), BigDecimal.ZERO)) {
                throw new BusinessException("剩余可调拨数量不能小于0!");
            }
            // 售罄下架
            if (ComputeUtil.isEmpty(entity.getSurplusNum())) {
                entity.setStatus(PlanConstant.GOODS_STATUS_OUT);
                entity.setLowerType(PlanConstant.OUT_TYPE_SALE);//下架类型0-手动下架，1-售罄下架，2-到期下架
                entity.setLowerId(InvocationInfoProxy.getUserid());
                entity.setLowerName(sessionManager.getUserContext().getUserName());
                entity.setLowerCode(InvocationInfoProxy.getUsercode());
                entity.setLowerTime(DateFormater.getCurrentDate());
                entity.setLowerNum(entity.getSurplusNum());
            }
            // 已调拨数量删除则恢复上架
            if (PlanConstant.GOODS_STATUS_OUT.equals(entity.getStatus()) &&
                    ComputeUtil.isGreaterThan(entity.getSurplusNum(), BigDecimal.ZERO)) {
                entity.setStatus(PlanConstant.GOODS_STATUS_ON);
            }
        }
        super.saveOrUpdateBatch(list);
        return BeanMapper.mapList(list, GoodsVO.class);
    }

    @Override
    public Map<Long, BigDecimal> getAllotableNum(List<Long> ids) {
        Map<Long, BigDecimal> resp = new HashMap<>();
        QueryWrapper<GoodsEntity> query = new QueryWrapper<>();
        query.select("id", "surplus_num");
        query.in("id", ids);

        List<Map<String, Object>> rs = super.listMaps(query);
        rs.stream().forEach(item -> {
            resp.put(Long.valueOf(item.get("id").toString()), new BigDecimal(item.get("surplus_num").toString()));
        });

        return resp;
    }

    @Override
    public List<GoodsEntity> getAllByIds(List<Long> ids) {
        QueryWrapper<GoodsEntity> query = new QueryWrapper<>();
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.in("id", ids);

        return super.list(query);
    }

    @Override
    public GoodsVO queryGoodsDetail(Long id) {
        GoodsEntity entity = super.selectById(id);
        GoodsVO vo = BeanMapper.map(entity, GoodsVO.class);
        //获取项目其他在售
        LambdaQueryWrapper<GoodsEntity> lambdachange = Wrappers.<GoodsEntity>lambdaQuery();
        lambdachange.eq(GoodsEntity::getProjectId, entity.getProjectId());
        lambdachange.eq(GoodsEntity::getStatus, PlanConstant.GOODS_STATUS_ON);
        lambdachange.gt(GoodsEntity::getSurplusNum, 0);
        int nums = super.count(lambdachange);
        vo.setOtherNums(nums);
        LambdaQueryWrapper<GoodsEntity> lambdachange2 = Wrappers.<GoodsEntity>lambdaQuery();
        lambdachange2.eq(GoodsEntity::getProjectId, entity.getProjectId());
        lambdachange2.eq(GoodsEntity::getStatus, PlanConstant.GOODS_STATUS_ON);
        lambdachange2.ne(GoodsEntity::getId, id);
        lambdachange2.gt(GoodsEntity::getSurplusNum, 0);
        lambdachange2.last("limit 3");
        List<GoodsEntity> list = super.list(lambdachange2);
        if (CollectionUtils.isNotEmpty(list)) {
            vo.setOthersGoods(BeanMapper.mapList(list, GoodsVO.class));
        }
        return vo;
    }
}
