package com.ejianc.business.panhuo.shelf.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.panhuo.shelf.bean.ShelfDetailEntity;
import com.ejianc.business.panhuo.shelf.mapper.ShelfDetailMapper;
import com.ejianc.business.panhuo.shelf.service.IShelfDetailService;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 物资上架申请清单
 *
 * @author generator
 *
 */
@Service("shelfDetailService")
public class ShelfDetailServiceImpl extends BaseServiceImpl<ShelfDetailMapper, ShelfDetailEntity> implements IShelfDetailService {

    @Override
    public List<ShelfDetailEntity> getAllByIds(List<Long> shelfDetailIds) {
        QueryWrapper<ShelfDetailEntity> query = new QueryWrapper<>();
        query.eq("dr", BaseVO.DR_UNDELETE);
        query.in("id", shelfDetailIds);

        return super.list(query);
    }
}
