/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.material.bean.FlowmeterEntity;
import com.ejianc.business.material.bean.SurplusmaterialrecordEntity;
import com.ejianc.business.material.bean.SurplusmaterialrecordtailEntity;
import com.ejianc.business.material.mapper.SurplusmaterialrecordMapper;
import com.ejianc.business.material.service.IFlowmeterService;
import com.ejianc.business.material.service.IRealtimebalanceService;
import com.ejianc.business.material.service.ISurplusmaterialrecordService;
import com.ejianc.business.material.service.ISurplusmaterialrecordtailService;
import com.ejianc.business.material.service.impl.SurplusmaterialrecordBpmServiceImpl;
import com.ejianc.business.material.vo.SurplusmaterialrecordVO;
import com.ejianc.business.material.vo.SurplusmaterialrecordtailVO;
import com.ejianc.foundation.share.api.IZjkjProjectApi;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.wzxt.op.api.IOpApi;
import com.ejianc.wzxt.op.vo.OpDetailVO;
import com.ejianc.wzxt.op.vo.OpVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="surplusmaterialrecordService")
public class SurplusmaterialrecordServiceImpl
extends BaseServiceImpl<SurplusmaterialrecordMapper, SurplusmaterialrecordEntity>
implements ISurplusmaterialrecordService {
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Value(value="${refer.base-host:null}")
    private String BASE_HOST_FRONTEND;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IRealtimebalanceService realtimebalanceService;
    @Autowired
    private IFlowmeterService flowmeterService;
    @Autowired
    private SurplusmaterialrecordBpmServiceImpl surplusmaterialrecordBpmService;
    @Autowired
    private IOpApi opApi;
    @Autowired
    private IZjkjProjectApi zjkjProjectApi;
    @Autowired
    private ISurplusmaterialrecordtailService surplusmaterialrecordtailService;

    @Override
    public SurplusmaterialrecordVO saveOrUpdate(SurplusmaterialrecordVO saveorUpdateVO) {
        saveorUpdateVO.setUseStatus(1);
        for (SurplusmaterialrecordtailVO surplusmaterialapprovetailEntity : saveorUpdateVO.getSurplusmaterialrecordtailEntities()) {
            surplusmaterialapprovetailEntity.setUseDetailStatus(1);
        }
        SurplusmaterialrecordEntity entity = (SurplusmaterialrecordEntity)((Object)BeanMapper.map((Object)((Object)saveorUpdateVO), SurplusmaterialrecordEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        super.saveOrUpdate((Object)entity, false);
        SurplusmaterialrecordVO vo = (SurplusmaterialrecordVO)((Object)BeanMapper.map((Object)((Object)entity), SurplusmaterialrecordVO.class));
        List<SurplusmaterialrecordtailEntity> surplusmaterialrecordtailEntities = entity.getSurplusmaterialrecordtailEntities();
        ArrayList<FlowmeterEntity> flowmeterList = new ArrayList<FlowmeterEntity>();
        LambdaQueryWrapper lambdaFlower = Wrappers.lambdaQuery();
        lambdaFlower.eq(FlowmeterEntity::getMid, (Object)entity.getId());
        this.flowmeterService.remove((Wrapper)lambdaFlower);
        List materialIds = surplusmaterialrecordtailEntities.stream().map(SurplusmaterialrecordtailEntity::getMaterialId).collect(Collectors.toList());
        LambdaQueryWrapper lambdaFlow = Wrappers.lambdaQuery();
        lambdaFlow.eq(FlowmeterEntity::getStoreId, (Object)entity.getStoreId());
        lambdaFlow.in(FlowmeterEntity::getMaterialId, materialIds);
        if (saveorUpdateVO.getId() != null) {
            lambdaFlow.ne(FlowmeterEntity::getMid, (Object)saveorUpdateVO.getId());
        }
        List flowmeterEntityList = this.flowmeterService.list((Wrapper)lambdaFlow);
        Map<Long, BigDecimal> numInMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("\u5165\u5e93")).collect(Collectors.groupingBy(FlowmeterEntity::getMaterialId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
        Map<Long, BigDecimal> numOutMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("\u51fa\u5e93")).collect(Collectors.groupingBy(FlowmeterEntity::getMaterialId, Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
        BigDecimal inNum = BigDecimal.ZERO;
        BigDecimal outNum = BigDecimal.ZERO;
        if (CollectionUtils.isNotEmpty(surplusmaterialrecordtailEntities)) {
            for (SurplusmaterialrecordtailEntity surplusmaterialrecordtailEntity : surplusmaterialrecordtailEntities) {
                FlowmeterEntity flowmeterEntity = this.surplusmaterialrecordBpmService.createrFlowmeter(entity, surplusmaterialrecordtailEntity, 0, null);
                flowmeterList.add(flowmeterEntity);
                inNum = BigDecimal.ZERO;
                outNum = BigDecimal.ZERO;
                if (numInMap.containsKey(surplusmaterialrecordtailEntity.getMaterialId())) {
                    inNum = numInMap.get(surplusmaterialrecordtailEntity.getMaterialId());
                }
                if (numOutMap.containsKey(surplusmaterialrecordtailEntity.getMaterialId())) {
                    outNum = numOutMap.get(surplusmaterialrecordtailEntity.getMaterialId());
                }
                BigDecimal subtract = inNum.subtract(outNum);
                BigDecimal num = BigDecimal.ZERO;
                num = saveorUpdateVO.getIsRebarManagement() == 0 ? surplusmaterialrecordtailEntity.getSuttle() : surplusmaterialrecordtailEntity.getMaterialNumber();
                if (num.compareTo(subtract) != 1) continue;
                throw new BusinessException("\u7269\u8d44\u7f16\u53f7:" + surplusmaterialrecordtailEntity.getMaterialCode() + ",\u7269\u8d44\u540d\u79f0:" + surplusmaterialrecordtailEntity.getMaterialName() + "\u5e93\u5b58\u4e0d\u8db3\uff0c\u4e0d\u80fd\u51fa\u5e93!");
            }
            this.flowmeterService.saveBatch(flowmeterList);
            this.realtimebalanceService.updateRealtimeBalance(entity.getStoreId());
        }
        return vo;
    }

    @Override
    @Transactional
    public void delete(List<SurplusmaterialrecordVO> vos) {
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        LambdaQueryWrapper lambdaRecord = Wrappers.lambdaQuery();
        lambdaRecord.in(BaseEntity::getId, ids);
        List deliveryrecordEntities = super.list((Wrapper)lambdaRecord);
        LambdaQueryWrapper lambdaFlower = Wrappers.lambdaQuery();
        lambdaFlower.in(FlowmeterEntity::getMid, ids);
        this.flowmeterService.remove((Wrapper)lambdaFlower);
        for (SurplusmaterialrecordEntity surplusmaterialrecordEntity : deliveryrecordEntities) {
            this.realtimebalanceService.updateRealtimeBalance(surplusmaterialrecordEntity.getStoreId());
        }
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
    }

    @Override
    public OpVO pushOp(Long id) {
        SurplusmaterialrecordEntity entity = (SurplusmaterialrecordEntity)((Object)this.selectById(id));
        OpVO applyVO = new OpVO();
        applyVO.setProjectId(entity.getProjectId());
        CommonResponse commonResponse = this.zjkjProjectApi.queryDetailById(entity.getProjectId());
        if (commonResponse.isSuccess() && null != commonResponse.getData()) {
            applyVO.setProjectCode(((ProjectVO)commonResponse.getData()).getBillCode());
        }
        applyVO.setProjectName(entity.getProjectName());
        applyVO.setOrgId(entity.getProjectDepartmentId());
        applyVO.setOrgName(entity.getProjectName());
        applyVO.setParentOrgId(entity.getOrgId());
        applyVO.setParentOrgName(entity.getOrgName());
        applyVO.setOutDate(new Date());
        applyVO.setOutType(Integer.valueOf(1));
        applyVO.setSourceBillCode(entity.getBillCode());
        String frontendBaseHost = "";
        frontendBaseHost = StringUtils.isNotBlank((String)this.BASE_HOST_FRONTEND) && !"null".equals(this.BASE_HOST_FRONTEND) ? this.BASE_HOST_FRONTEND : this.baseHost;
        applyVO.setLinkUrlPc(frontendBaseHost + "ejc-zjkjmaterial-frontend/#/surplusmaterialrecord/card?link=true&id=" + entity.getId());
        ArrayList<OpDetailVO> detailList = new ArrayList<OpDetailVO>();
        ArrayList<String> list = new ArrayList<String>();
        for (SurplusmaterialrecordtailEntity detailEntity : entity.getSurplusmaterialrecordtailEntities()) {
            OpDetailVO detailVO = new OpDetailVO();
            detailVO.setCode(detailEntity.getMaterialCode());
            detailVO.setName(detailEntity.getMaterialName());
            detailVO.setSpec(detailEntity.getMaterialSpecifications());
            detailVO.setUnit(detailEntity.getMaterialUnit());
            detailVO.setNum(detailEntity.getSuttle());
            detailVO.setSourceId(detailEntity.getId());
            detailList.add(detailVO);
            list.add(detailEntity.getMaterialName());
        }
        applyVO.setSourceId(String.valueOf(entity.getId()));
        applyVO.setSourceType("HZBT202208000004");
        applyVO.setSourceTypeName("\u5904\u7f6e\u5355");
        applyVO.setDetailList(detailList);
        applyVO.setMaterialName(StringUtils.join(list, (String)","));
        CommonResponse response = this.opApi.push(applyVO);
        return response.isSuccess() ? (OpVO)response.getData() : null;
    }

    @Override
    public List<SurplusmaterialrecordtailVO> getDetailById(List<Long> ids) {
        LambdaQueryWrapper lambdaRecord = Wrappers.lambdaQuery();
        lambdaRecord.eq(BaseEntity::getId, ids);
        List recordList = super.list((Wrapper)lambdaRecord);
        Map recordMap = recordList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.in(SurplusmaterialrecordtailEntity::getMid, ids);
        List detailList = this.surplusmaterialrecordtailService.list((Wrapper)lambda);
        List surplusmaterialrecordtailVOS = BeanMapper.mapList((Iterable)detailList, SurplusmaterialrecordtailVO.class);
        for (SurplusmaterialrecordtailVO surplusmaterialrecordtailVO : surplusmaterialrecordtailVOS) {
            if (!recordMap.containsKey(surplusmaterialrecordtailVO.getMid())) continue;
            SurplusmaterialrecordEntity surplusmaterialrecordEntity = (SurplusmaterialrecordEntity)((Object)recordMap.get(surplusmaterialrecordtailVO.getMid()));
            surplusmaterialrecordtailVO.setRecordBillCode(surplusmaterialrecordEntity.getBillCode());
        }
        return surplusmaterialrecordtailVOS;
    }

    @Override
    public List<SurplusmaterialrecordtailVO> getDetailByApproveId(Long approveId) {
        LambdaQueryWrapper lambdaRecord = Wrappers.lambdaQuery();
        lambdaRecord.eq(SurplusmaterialrecordEntity::getDisposalId, (Object)approveId);
        lambdaRecord.in(SurplusmaterialrecordEntity::getBillState, new Object[]{1, 3});
        lambdaRecord.in(SurplusmaterialrecordEntity::getUseStatus, new Object[]{1});
        List recordList = super.list((Wrapper)lambdaRecord);
        List<SurplusmaterialrecordtailVO> surplusmaterialrecordtailVOS = new ArrayList<SurplusmaterialrecordtailVO>();
        if (CollectionUtils.isNotEmpty((Collection)recordList)) {
            List ids = recordList.stream().map(BaseEntity::getId).collect(Collectors.toList());
            Map recordMap = recordList.stream().collect(Collectors.toMap(BaseEntity::getId, Function.identity()));
            LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
            lambda.in(SurplusmaterialrecordtailEntity::getMid, ids);
            List detailList = this.surplusmaterialrecordtailService.list((Wrapper)lambda);
            surplusmaterialrecordtailVOS = BeanMapper.mapList((Iterable)detailList, SurplusmaterialrecordtailVO.class);
            for (SurplusmaterialrecordtailVO surplusmaterialrecordtailVO : surplusmaterialrecordtailVOS) {
                if (!recordMap.containsKey(surplusmaterialrecordtailVO.getMid())) continue;
                SurplusmaterialrecordEntity surplusmaterialrecordEntity = (SurplusmaterialrecordEntity)((Object)recordMap.get(surplusmaterialrecordtailVO.getMid()));
                surplusmaterialrecordtailVO.setRecordBillCode(surplusmaterialrecordEntity.getBillCode());
            }
            return surplusmaterialrecordtailVOS;
        }
        return surplusmaterialrecordtailVOS;
    }
}

