package com.ejianc.business.material.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.material.bean.*;
import com.ejianc.business.material.service.*;
import com.ejianc.business.material.utils.DateUtils;
import com.ejianc.business.material.vo.WastematerialresultReportVO;
import com.ejianc.business.material.vo.SurplusmaterialapproveVO;
import com.ejianc.business.material.vo.WastematerialresultVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.checkerframework.checker.units.qual.A;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.math.BigDecimal;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.material.vo.WastematerialresultVO;

/**
 * 废旧物资处置结果确认表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("wastematerialresult")
public class WastematerialresultController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IWastematerialresultService service;
    @Autowired
    private IWastematerialresulttailService detailService;
    @Autowired
    private ISurplusmaterialapproveService surplusmaterialapproveService;
    @Autowired
    private ISurplusmaterialapprovetailService surplusmaterialapprovetailService;
    @Autowired
    private ISurplusmaterialrecordService surplusmaterialrecordService;
    @Autowired
    private ISurplusmaterialrecordtailService surplusmaterialrecordtailService;
    @Autowired
    private ITenderService tenderService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<WastematerialresultVO> saveOrUpdate(@RequestBody WastematerialresultVO saveorUpdateVO) {
        WastematerialresultVO vo = service.saveOrUpdate(saveorUpdateVO);


    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<WastematerialresultVO> queryDetail(Long id) {
    	WastematerialresultEntity entity = service.selectById(id);
    	WastematerialresultVO vo = BeanMapper.map(entity, WastematerialresultVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WastematerialresultVO> vos) {
        service.delete(vos);

        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<WastematerialresultVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("informant_name");
        fuzzyFields.add("project_name");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        IPage<WastematerialresultEntity> page = service.queryPage(param,false);
        IPage<WastematerialresultVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), WastematerialresultVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }
    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("informant_name");
        fuzzyFields.add("project_name");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        List<WastematerialresultEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<WastematerialresultVO> WastematerialresultVOList = BeanMapper.mapList(list, WastematerialresultVO.class);
        for (int i = 0; i < WastematerialresultVOList.size(); i++) {
            WastematerialresultVO WastematerialresultVO = WastematerialresultVOList.get(i);
            WastematerialresultVO.setNum(String.valueOf(i + 1));
            if (WastematerialresultVO.getCreateTime() != null) {
                WastematerialresultVO.setCreateTimeShow(DateUtils.dateSimple2(WastematerialresultVO.getCreateTime()));
            }
            if (WastematerialresultVO.getResultDate() != null) {
                WastematerialresultVO.setResultDateShow(DateUtils.dateSimple2(WastematerialresultVO.getResultDate()));
            }
            String billStateStr = WastematerialresultVO.getBillState().toString();
            if (billStateStr != null) {
                if ("0".equals(billStateStr)) {//自由态
                    billStateStr = "自由态";
                } else if ("1".equals(billStateStr)) {//已提交
                    billStateStr = "已提交";
                } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {//审批中
                    billStateStr = "审批中";
                } else if ("3".equals(billStateStr)) {//审批通过
                    billStateStr = "审批通过";
                } else if ("4".equals(billStateStr)) {//驳回
                    billStateStr = "驳回";
                }

                WastematerialresultVO.setBillStateStr(billStateStr);
            }
        }

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", WastematerialresultVOList);
        ExcelExport.getInstance().export("Wastematerialresult-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param
     * @Return void
     */
    @RequestMapping(value = "/refWastematerialresultData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<WastematerialresultVO>> refWastematerialresultData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<WastematerialresultEntity> page = service.queryPage(param,false);
        IPage<WastematerialresultVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), WastematerialresultVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }


    @Autowired
    private ISurplusmaterialapproveService surplusmaterialapproveservice;

    /**
     * @Description queryDetail 查询剩余/废旧物资评估确认及处置记录表详情
     * @param surplusmaterialapproveId
     */
    @RequestMapping(value = "/querySurplusmaterialapprove", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SurplusmaterialapproveVO> querySurplusmaterialapprove(Long id,Long surplusmaterialapproveId) {
        SurplusmaterialapproveEntity entity = surplusmaterialapproveservice.selectById(surplusmaterialapproveId);
        QueryWrapper<SurplusmaterialapprovetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", surplusmaterialapproveId);
        List<SurplusmaterialapprovetailEntity> materialapproachdetailEntityList = surplusmaterialapprovetailService.list(queryWrapper);
        List<SurplusmaterialapprovetailEntity> surplusmaterialapprovetailEntityArrayList = new ArrayList<>();
        //废旧回收 过滤数据
        List<Long> approveDetailIds = new ArrayList<>();
        Map<Long, TenderEntity> tenderDetailMap = new HashMap<>();
        if (entity.getDealType() != null && entity.getDealType().equals(2)){

            LambdaQueryWrapper<TenderEntity> tenderLambda = Wrappers.<TenderEntity>lambdaQuery();
            tenderLambda.eq(TenderEntity::getApproveId, surplusmaterialapproveId);
            tenderLambda.in(TenderEntity::getBillState, 1,3);
            List<TenderEntity> tenderEntityList = tenderService.list(tenderLambda);
            if (CollectionUtils.isNotEmpty(tenderEntityList)){
                approveDetailIds = tenderEntityList.stream().map(TenderEntity::getApproveDetailId).collect(Collectors.toList());
                tenderDetailMap = tenderEntityList.stream().collect(Collectors.toMap(TenderEntity::getApproveDetailId, Function.identity()));
            }

            for (SurplusmaterialapprovetailEntity surplusmaterialapprovetailEntity : materialapproachdetailEntityList){
                if(tenderDetailMap.containsKey(surplusmaterialapprovetailEntity.getId())){
                    TenderEntity tenderEntity = tenderDetailMap.get(surplusmaterialapprovetailEntity.getId());
                    surplusmaterialapprovetailEntity.setMaterialNumber(tenderEntity.getDealNum());
                    surplusmaterialapprovetailEntity.setTemporaryPrice(tenderEntity.getDealPrice());
                    surplusmaterialapprovetailEntity.setTemporaryMoney(tenderEntity.getDealMny());
                }
            }
            
        }

        //处理剩余量
        //查询所有处置数量
        if (CollectionUtils.isNotEmpty(materialapproachdetailEntityList)){
            List<Long> approveIds = materialapproachdetailEntityList.stream().map(SurplusmaterialapprovetailEntity::getId).collect(Collectors.toList());
//            SurplusmaterialrecordVO
            //查询所有下游引用的数据,获取处置数量
            LambdaQueryWrapper<SurplusmaterialrecordtailEntity> houseDetailScheme = Wrappers.<SurplusmaterialrecordtailEntity>lambdaQuery();
            houseDetailScheme.in(SurplusmaterialrecordtailEntity::getDetailApproveId, approveIds);
            if (id != null){
                houseDetailScheme.ne(SurplusmaterialrecordtailEntity::getMid,id);
            }
            List<SurplusmaterialrecordtailEntity> surplusmaterialrecordtailEntityList = surplusmaterialrecordtailService.list(houseDetailScheme);
            if (CollectionUtils.isNotEmpty(surplusmaterialrecordtailEntityList)){
                // 分组后汇总
                Map<Long, BigDecimal> checkMap = surplusmaterialrecordtailEntityList.stream().filter(s->s.getMaterialNumber().compareTo(BigDecimal.ZERO) == 1).collect(Collectors.groupingBy(SurplusmaterialrecordtailEntity::getDetailApproveId,
                        Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getMaterialNumber()).reduce(BigDecimal.ZERO, BigDecimal::add))));
                for (SurplusmaterialapprovetailEntity surplusmaterialapprovetailEntity : materialapproachdetailEntityList){
                    if(checkMap.containsKey(surplusmaterialapprovetailEntity.getId())){
                        BigDecimal checkNum = checkMap.get(surplusmaterialapprovetailEntity.getId());
                        surplusmaterialapprovetailEntity.setMaterialNumber(surplusmaterialapprovetailEntity.getMaterialNumber().subtract(checkNum));
                    }
                }
            }
            surplusmaterialapprovetailEntityArrayList = materialapproachdetailEntityList.stream().filter(it -> it.getMaterialNumber().compareTo(BigDecimal.ZERO) == 1).collect(Collectors.toList());
        }

        if (entity.getDealType() != null && entity.getDealType().equals(2)){
            List<Long> finalApproveDetailIds = approveDetailIds;
            surplusmaterialapprovetailEntityArrayList = materialapproachdetailEntityList.stream().filter(it -> finalApproveDetailIds.contains(it.getId())).collect(Collectors.toList());
        }

        entity.setSurplusmaterialapprovetailEntities(surplusmaterialapprovetailEntityArrayList);
        SurplusmaterialapproveVO vo = BeanMapper.map(entity, SurplusmaterialapproveVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    @Autowired
    private ISurplusmaterialrecordService iSurplusmaterialrecordService;
    @Autowired
    private ISurplusmaterialrecordtailService iSurplusmaterialrecordtailService;

    @RequestMapping(value = "/queryReport", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<WastematerialresultReportVO>> queryReport(Long projectId, String materialCode) {
        List<WastematerialresultReportVO> resList = new ArrayList<>();
        QueryWrapper<SurplusmaterialrecordEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.eq("project_id", projectId);
        queryWrapper.in("bill_state", 1,3);
        List<SurplusmaterialrecordEntity> entityList = iSurplusmaterialrecordService.list(queryWrapper);
        for(SurplusmaterialrecordEntity entity: entityList){
            QueryWrapper<SurplusmaterialrecordtailEntity> detailQueryWrapper = new QueryWrapper<>();
            detailQueryWrapper.eq("dr", 0);
            detailQueryWrapper.eq("mid", entity.getId());
            detailQueryWrapper.eq("material_code", materialCode);
            List<SurplusmaterialrecordtailEntity> detailEntityList = iSurplusmaterialrecordtailService.list(detailQueryWrapper);
            for(SurplusmaterialrecordtailEntity detailEntity: detailEntityList){
                WastematerialresultReportVO reportVO = new WastematerialresultReportVO();
                reportVO.setId(IdWorker.getId());
                reportVO.setOrgName(entity.getOrgName());
                reportVO.setBillCode(entity.getBillCode());
                reportVO.setWastematerialresultId(entity.getId());
                reportVO.setProjectId(entity.getProjectId());
                reportVO.setProjectName(entity.getProjectName());
                reportVO.setDealDate(entity.getDealDate());
                reportVO.setMaterialUnit(detailEntity.getMaterialUnit());
                reportVO.setMaterialNumber(detailEntity.getMaterialNumber());
                reportVO.setMaterialName(detailEntity.getMaterialName());
                reportVO.setMaterialCode(detailEntity.getMaterialCode());
                reportVO.setExMaterialMoney(detailEntity.getExMoney());
                reportVO.setMaterialMoney(detailEntity.getMoney());
                resList.add(reportVO);
            }
        }


//        QueryWrapper<WastematerialresulttailEntity> detailQueryWrapper = new QueryWrapper<>();
//        detailQueryWrapper.eq("dr", 0);
//        detailQueryWrapper.eq("project_id", projectId);
//        detailQueryWrapper.eq("material_code", materialCode);
//        List<WastematerialresulttailEntity> detailEntityList = detailService.list(detailQueryWrapper);
//
//        for (WastematerialresulttailEntity item:
//                detailEntityList) {
//            String projectName = item.getProjectName();//项目名称
//            String materialName = item.getMaterialName();//物资名称
//            BigDecimal materialNumber = item.getMaterialNumber();//处理数量
//            WastematerialresultReportVO reportVO = new WastematerialresultReportVO();
//            reportVO.setId(IdWorker.getId());
//            reportVO.setProjectId(projectId);
//            reportVO.setProjectName(projectName);
//            reportVO.setMaterialName(materialName);
//            reportVO.setMaterialCode(materialCode);
//            reportVO.setMaterialNumber(materialNumber);
//            reportVO.setMaterialUnit(item.getMaterialUnit());
//
//            Long mid = item.getMid();
//            QueryWrapper<WastematerialresultEntity> queryWrapper = new QueryWrapper<>();
//            queryWrapper.eq("dr", 0);
//            queryWrapper.eq("id", mid);
//            List<WastematerialresultEntity> mList = service.list(queryWrapper);
//            if(mList != null && mList.size() > 0){
//                WastematerialresultEntity entity = mList.get(0);
//                String billCode = entity.getBillCode();
//                reportVO.setBillCode(billCode);
//                reportVO.setWastematerialresultId(mid);
//            }
//
//            resList.add(reportVO);
//        }

        return CommonResponse.success("查询成功", resList);
    }
}
