package com.ejianc.business.material.mapper;

import com.ejianc.business.material.vo.BigScreenVO;
import com.ejianc.business.material.vo.MonthOrgDetailVO;
import com.ejianc.business.material.vo.MonthProjectDetailVO;
import com.ejianc.business.material.vo.StoreBalanceDetailVO;
import org.apache.ibatis.annotations.Mapper;

import com.ejianc.framework.skeleton.template.BaseCrudMapper;
import com.ejianc.business.material.bean.MonthProjectEntity;
import org.apache.ibatis.annotations.Param;

import java.math.BigDecimal;
import java.util.List;

/**
 * 物资消耗月度分析表-项目
 * 
 * @author generator
 * 
 */
@Mapper
public interface MonthProjectMapper extends BaseCrudMapper<MonthProjectEntity> {
    List<Long> getListBycategoryId(@Param("categoryId") Long categoryId);

    BigDecimal getPlanNum(@Param("orgIds")List<Long> orgIds,@Param("projectId")Long projectId,@Param("listBycategoryId")List<Long> listBycategoryId,@Param("previousMonth") String previousMonth);

    List<MonthOrgDetailVO> queryDetailByOrgId(@Param("orgIds")List<Long> orgIds, @Param("month")String month);

    BigDecimal getTotalPlanNum(@Param("orgIds")List<Long> orgIds, @Param("categoryIds")List<Long> categoryIds);

    BigDecimal getcheckNum(@Param("orgIds")List<Long> orgIds, @Param("categoryIds")List<Long> categoryIds,@Param("month")String month);

    BigDecimal getOrderNum(@Param("orgIds")List<Long> orgIds, @Param("categoryIds")List<Long> categoryIds,@Param("month")String month);

    List<BigScreenVO> getMonthOrgByMonth(@Param("orgIds")List<Long> orgIds,@Param("month")String month);
}
