package com.ejianc.business.material.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 分公司闲置设备物资情况一览表
 *
 * @author generator
 *
 */
public class EquipmentVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private java.lang.String billCode; // 单据编号
    private java.lang.Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date approveTime; // 审批日期
    private java.lang.Long projectId; // 项目id
    private java.lang.String projectName; // 项目名称
    private java.lang.Long orgId; // 所属组织id
    private java.lang.String orgName; // 所属组织名称
    private java.lang.Long projectDepartmentId; // 项目部id
    private java.lang.Long filialeId; // 分公司id
    private java.lang.String filialeName; // 分公司名称
    private java.math.BigDecimal estimateTotal; // 预估总价
    private java.math.BigDecimal estimateResidual; // 预估残值
    private java.math.BigDecimal idleTotal; // 闲置数量
    private java.lang.String remarks; // 备注
    private java.lang.Long agentId; // 经办人
    private java.lang.String agentName; // 经办人姓名
    private java.lang.String sort; // 类别
    private java.lang.String name; // 物资名称
    private java.lang.String spec; // 物资型号

    private Long storeId; // 仓库id
    private String storeName; // 仓库名称
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date billTime; // 日期

    private List<EquipmentdetailVO> equipmentdetailEntities = new ArrayList<>(); // 分公司闲置设备物资情况一览表子表


    private java.lang.String num; // 序号
    private java.lang.String createTimeShow;
    private java.lang.String billStateStr;

    public String getNum() {
        return num;
    }

    public void setNum(String num) {
        this.num = num;
    }

    public String getCreateTimeShow() {
        return createTimeShow;
    }

    public void setCreateTimeShow(String createTimeShow) {
        this.createTimeShow = createTimeShow;
    }

    public String getBillStateStr() {
        return billStateStr;
    }

    public void setBillStateStr(String billStateStr) {
        this.billStateStr = billStateStr;
    }

    /**
     * 单据编号
     */
    public java.lang.String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(java.lang.String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public java.lang.Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public void setBillState(java.lang.Integer billState) {
        this.billState = billState;
    }
    /**
     * 审批日期
     */
    public java.util.Date getApproveTime() {
        return approveTime;
    }

    /**
     * 审批日期
     */
    public void setApproveTime(java.util.Date approveTime) {
        this.approveTime = approveTime;
    }
    /**
     * 项目id
     */
    @ReferSerialTransfer(referCode = "ejc-zjkj-project")
    public java.lang.Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    @ReferDeserialTransfer
    public void setProjectId(java.lang.Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public java.lang.String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(java.lang.String projectName) {
        this.projectName = projectName;
    }
    /**
     * 所属组织id
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public java.lang.Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织id
     */
    @ReferDeserialTransfer
    public void setOrgId(java.lang.Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 所属组织名称
     */
    public java.lang.String getOrgName() {
        return orgName;
    }

    /**
     * 所属组织名称
     */
    public void setOrgName(java.lang.String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部id
     */
    public java.lang.Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    /**
     * 项目部id
     */
    public void setProjectDepartmentId(java.lang.Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    /**
     * 分公司id
     */
    @ReferSerialTransfer(referCode = "idm-org")
    public java.lang.Long getFilialeId() {
        return filialeId;
    }

    /**
     * 分公司id
     */
    @ReferDeserialTransfer
    public void setFilialeId(java.lang.Long filialeId) {
        this.filialeId = filialeId;
    }
    /**
     * 分公司名称
     */
    public java.lang.String getFilialeName() {
        return filialeName;
    }

    /**
     * 分公司名称
     */
    public void setFilialeName(java.lang.String filialeName) {
        this.filialeName = filialeName;
    }
    /**
     * 预估总价
     */
    public java.math.BigDecimal getEstimateTotal() {
        return estimateTotal;
    }

    /**
     * 预估总价
     */
    public void setEstimateTotal(java.math.BigDecimal estimateTotal) {
        this.estimateTotal = estimateTotal;
    }
    /**
     * 预估残值
     */
    public java.math.BigDecimal getEstimateResidual() {
        return estimateResidual;
    }

    /**
     * 预估残值
     */
    public void setEstimateResidual(java.math.BigDecimal estimateResidual) {
        this.estimateResidual = estimateResidual;
    }
    /**
     * 备注
     */
    public java.lang.String getRemarks() {
        return remarks;
    }

    /**
     * 备注
     */
    public void setRemarks(java.lang.String remarks) {
        this.remarks = remarks;
    }
    /**
     * 经办人
     */
    public java.lang.Long getAgentId() {
        return agentId;
    }

    /**
     * 经办人
     */
    public void setAgentId(java.lang.Long agentId) {
        this.agentId = agentId;
    }
    /**
     * 经办人姓名
     */
    public java.lang.String getAgentName() {
        return agentName;
    }

    /**
     * 经办人姓名
     */
    public void setAgentName(java.lang.String agentName) {
        this.agentName = agentName;
    }

    public List<EquipmentdetailVO> getEquipmentdetailEntities() {
        return equipmentdetailEntities;
    }

    public void setEquipmentdetailEntities(List<EquipmentdetailVO> equipmentdetailEntities) {
        this.equipmentdetailEntities = equipmentdetailEntities;
    }

    @ReferSerialTransfer(referCode="StoreRef")
    public Long getStoreId() {
        return storeId;
    }

    @ReferDeserialTransfer
    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }

    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public Date getBillTime() {
        return billTime;
    }

    public void setBillTime(Date billTime) {
        this.billTime = billTime;
    }

    public BigDecimal getIdleTotal() {
        return idleTotal;
    }

    public void setIdleTotal(BigDecimal idleTotal) {
        this.idleTotal = idleTotal;
    }

    public String getSort() {
        return sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec;
    }
}
