package com.ejianc.business.material.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.material.vo.StoreBalanceDetailVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 物资结存
 *
 * @author generator
 *
 */
public class StoreBalanceVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String billCode; // 单据编号
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private Long projectDepartmentId; // 项目部id
    private String remarks; // 备注
    private Long agentId; // 经办人
    private String agentName; // 经办人姓名
    private Long storeId; // 仓库id
    private String storeName; // 仓库名称
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM",
            timezone = "GMT+8"
    )
    private Date month;//结存月份
    private BigDecimal instoreQuantityTotal; // 本月入库数量
    private BigDecimal instoreAmountTaxTotal; // 本月入库金额（含税）
    private BigDecimal instoreAmountUntaxTotal; // 本月入库金额（无税）
    private BigDecimal outstoreQuantityTotal; // 本月消耗数量
    private BigDecimal outstoreAmountTaxTotal; // 本月消耗金额（含税）
    private BigDecimal outstoreAmountUntaxTotal; // 本月消耗金额（无税）
    private BigDecimal lastQuantityTotal; // 上月结存数量
    private BigDecimal lastAmountTaxTotal; // 上月结存金额（含税）
    private BigDecimal lastAmountUntaxTotal; // 上月结存金额（无税）
    private BigDecimal currentQuantityTotal; // 本月结存数量
    private BigDecimal currentAmountTaxTotal; // 本月结存金额（含税）
    private BigDecimal currentAmountUntaxTotal; // 本月结存金额（无税）
    private Integer isSettlement; // 是否归集状态 0 未归集 1 归集

    private List<StoreBalanceDetailVO> storeBalanceDetailEntities = new ArrayList<>(); // 物资结存明细

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    @ReferSerialTransfer(referCode="ejc-zjkj-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
    @ReferSerialTransfer(referCode="idm-user")
    public Long getAgentId() {
        return agentId;
    }

    @ReferDeserialTransfer
    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }
    public String getAgentName() {
        return agentName;
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }
    @ReferSerialTransfer(referCode="StoreRef")
    public Long getStoreId() {
        return storeId;
    }

    @ReferDeserialTransfer
    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }
    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }
    public BigDecimal getInstoreQuantityTotal() {
        return instoreQuantityTotal;
    }

    public void setInstoreQuantityTotal(BigDecimal instoreQuantityTotal) {
        this.instoreQuantityTotal = instoreQuantityTotal;
    }
    public BigDecimal getInstoreAmountTaxTotal() {
        return instoreAmountTaxTotal;
    }

    public void setInstoreAmountTaxTotal(BigDecimal instoreAmountTaxTotal) {
        this.instoreAmountTaxTotal = instoreAmountTaxTotal;
    }
    public BigDecimal getInstoreAmountUntaxTotal() {
        return instoreAmountUntaxTotal;
    }

    public void setInstoreAmountUntaxTotal(BigDecimal instoreAmountUntaxTotal) {
        this.instoreAmountUntaxTotal = instoreAmountUntaxTotal;
    }
    public BigDecimal getOutstoreQuantityTotal() {
        return outstoreQuantityTotal;
    }

    public void setOutstoreQuantityTotal(BigDecimal outstoreQuantityTotal) {
        this.outstoreQuantityTotal = outstoreQuantityTotal;
    }
    public BigDecimal getOutstoreAmountTaxTotal() {
        return outstoreAmountTaxTotal;
    }

    public void setOutstoreAmountTaxTotal(BigDecimal outstoreAmountTaxTotal) {
        this.outstoreAmountTaxTotal = outstoreAmountTaxTotal;
    }
    public BigDecimal getOutstoreAmountUntaxTotal() {
        return outstoreAmountUntaxTotal;
    }

    public void setOutstoreAmountUntaxTotal(BigDecimal outstoreAmountUntaxTotal) {
        this.outstoreAmountUntaxTotal = outstoreAmountUntaxTotal;
    }
    public BigDecimal getLastQuantityTotal() {
        return lastQuantityTotal;
    }

    public void setLastQuantityTotal(BigDecimal lastQuantityTotal) {
        this.lastQuantityTotal = lastQuantityTotal;
    }
    public BigDecimal getLastAmountTaxTotal() {
        return lastAmountTaxTotal;
    }

    public void setLastAmountTaxTotal(BigDecimal lastAmountTaxTotal) {
        this.lastAmountTaxTotal = lastAmountTaxTotal;
    }
    public BigDecimal getLastAmountUntaxTotal() {
        return lastAmountUntaxTotal;
    }

    public void setLastAmountUntaxTotal(BigDecimal lastAmountUntaxTotal) {
        this.lastAmountUntaxTotal = lastAmountUntaxTotal;
    }
    public BigDecimal getCurrentQuantityTotal() {
        return currentQuantityTotal;
    }

    public void setCurrentQuantityTotal(BigDecimal currentQuantityTotal) {
        this.currentQuantityTotal = currentQuantityTotal;
    }
    public BigDecimal getCurrentAmountTaxTotal() {
        return currentAmountTaxTotal;
    }

    public void setCurrentAmountTaxTotal(BigDecimal currentAmountTaxTotal) {
        this.currentAmountTaxTotal = currentAmountTaxTotal;
    }
    public BigDecimal getCurrentAmountUntaxTotal() {
        return currentAmountUntaxTotal;
    }

    public void setCurrentAmountUntaxTotal(BigDecimal currentAmountUntaxTotal) {
        this.currentAmountUntaxTotal = currentAmountUntaxTotal;
    }

    public List<StoreBalanceDetailVO> getStoreBalanceDetailEntities() {
        return storeBalanceDetailEntities;
    }

    public void setStoreBalanceDetailEntities(List<StoreBalanceDetailVO> storeBalanceDetailEntities) {
        this.storeBalanceDetailEntities = storeBalanceDetailEntities;
    }

    public Date getMonth() {
        return month;
    }

    public void setMonth(Date month) {
        this.month = month;
    }

    public Integer getIsSettlement() {
        return isSettlement;
    }

    public void setIsSettlement(Integer isSettlement) {
        this.isSettlement = isSettlement;
    }
}
