package com.ejianc.business.outputValue.controller;

import com.ejianc.business.outputValue.bean.ProjectMonthActualOutputValueRecordEntity;
import com.ejianc.business.outputValue.service.IProjectMonthActualOutputValueRecordService;
import com.ejianc.business.outputValue.vo.ProjectMonthActualOutputValueRecordVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

/**
 * 项目月度计划产值
 *
 */
@RestController
@RequestMapping("/projectMonthActualOutputValueRecord/")
public class ProjectMonthActualOutputValueRecordController {

	@Autowired
	private IProjectMonthActualOutputValueRecordService recordService;
    
    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<ProjectMonthActualOutputValueRecordVO> queryDetail(Long id) {
        ProjectMonthActualOutputValueRecordEntity entity = recordService.selectById(id);
        ProjectMonthActualOutputValueRecordVO vo = BeanMapper.map(entity, ProjectMonthActualOutputValueRecordVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

}
