package com.ejianc.business.outputValue.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.outputValue.bean.CompanyBusinessQuotaChangeEntity;
import com.ejianc.business.outputValue.bean.CompanyBusinessQuotaEntity;
import com.ejianc.business.outputValue.bean.CompanyBusinessQuotaRecordEntity;
import com.ejianc.business.outputValue.mapper.CompanyBusinessQuotaChangeMapper;
import com.ejianc.business.outputValue.service.ICompanyBusinessQuotaChangeService;
import com.ejianc.business.outputValue.service.ICompanyBusinessQuotaRecordService;
import com.ejianc.business.outputValue.service.ICompanyBusinessQuotaService;
import com.ejianc.business.outputValue.vo.CompanyBusinessQuotaChangeVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 公司经营指标 （产值）
 * 
 * @author generator
 * 
 */
@Service("companyBusinessQuotaChangeService")
public class CompanyBusinessQuotaChangeServiceImpl extends BaseServiceImpl<CompanyBusinessQuotaChangeMapper, CompanyBusinessQuotaChangeEntity> implements ICompanyBusinessQuotaChangeService {

    @Autowired
    private ICompanyBusinessQuotaService companyBusinessQuotaService;
    @Autowired
    private ICompanyBusinessQuotaRecordService recordService;
    @Override
    public CommonResponse<CompanyBusinessQuotaChangeVO> saveChange(CompanyBusinessQuotaChangeVO saveorUpdateVO) {
        CompanyBusinessQuotaChangeEntity entity = BeanMapper.map(saveorUpdateVO, CompanyBusinessQuotaChangeEntity.class);
        //检验是否存在未生效的变更单据，若存在，则不能变更
        QueryWrapper<CompanyBusinessQuotaChangeEntity> queryWrapper = new QueryWrapper<CompanyBusinessQuotaChangeEntity>();
        queryWrapper.eq("data_id", saveorUpdateVO.getDataId());
        queryWrapper.eq("dr", 0);
        queryWrapper.in("bill_state", 0,4);
        if(saveorUpdateVO.getId()!=null){
            queryWrapper.ne("id", saveorUpdateVO.getId());
        }
        List<CompanyBusinessQuotaChangeEntity> exit = this.list(queryWrapper);
        if(exit!=null&&exit.size()>0){
            throw new BusinessException("已存在未完成的变更单据，不能新增新的变更单据");
        }

        //检验该单据是否是当前公司最新的单据，若是则允许变更，否则不允许；
        QueryWrapper<CompanyBusinessQuotaEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("org_id", saveorUpdateVO.getOrgId());
        wrapper.eq("dr", 0);
        wrapper.orderByDesc("year");
        List<CompanyBusinessQuotaEntity> companyBusinessQuotaList = companyBusinessQuotaService.list(wrapper);
        if(companyBusinessQuotaList!=null && companyBusinessQuotaList.size()>0){
            if(!saveorUpdateVO.getYear().equals(companyBusinessQuotaList.get(0).getYear())){
                throw new BusinessException("只能变更该公司最新的数据");
            }
        }

        this.saveOrUpdate(entity, false);
        CompanyBusinessQuotaChangeVO vo = BeanMapper.map(entity, CompanyBusinessQuotaChangeVO.class);
        vo.setRecordList(saveorUpdateVO.getRecordList());
        //查询当前合同信息，将状态改为变更中
        CompanyBusinessQuotaEntity companyBusinessQuotaEntity = companyBusinessQuotaService.selectById(vo.getDataId());
        companyBusinessQuotaEntity.setChangeState("2");//状态改为变更中
        companyBusinessQuotaEntity.setChangeId(vo.getId());
        companyBusinessQuotaService.saveOrUpdate(companyBusinessQuotaEntity, false);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    @Override
    public CommonResponse<String> delete(List<CompanyBusinessQuotaChangeVO> vos) {
        for(CompanyBusinessQuotaChangeVO vo : vos){
            CompanyBusinessQuotaChangeEntity entity = this.getById(vo.getId());
            CompanyBusinessQuotaEntity companyBusinessQuotaEntity = companyBusinessQuotaService.selectById(entity.getDataId());
            QueryWrapper<CompanyBusinessQuotaRecordEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("data_id", companyBusinessQuotaEntity.getId());
            List<CompanyBusinessQuotaRecordEntity> records = recordService.list(queryWrapper);
            if(records!=null&&records.size()>0){
                companyBusinessQuotaEntity.setChangeState("3");//状态改为已变更
            }else{
                companyBusinessQuotaEntity.setChangeState("1");//状态改为未变更
            }
            companyBusinessQuotaEntity.setChangeId(null);
            companyBusinessQuotaService.saveOrUpdate(companyBusinessQuotaEntity, false);
        }
        this.removeByIds(vos.stream().map(CompanyBusinessQuotaChangeVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }
}
