/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.bean.FlowmeterEntity;
import com.ejianc.business.material.service.IFlowmeterService;
import com.ejianc.business.material.service.IGatherSendService;
import com.ejianc.foundation.material.vo.GatherSendVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"gathersend"})
public class GatherSendController
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Autowired
    private IGatherSendService service;
    @Autowired
    private IFlowmeterService flowmeterService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IOrgApi iOrgApi;

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<GatherSendVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectId");
        fuzzyFields.add("materialCode");
        fuzzyFields.add("specialModel");
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialCategoryCode");
        fuzzyFields.add("materialCategoryName");
        fuzzyFields.add("operationType");
        fuzzyFields.add("accessType");
        fuzzyFields.add("time");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("billStatus", new Parameter("eq", (Object)1));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        List flowmeterEntityList = this.flowmeterService.queryList(param, false);
        Parameter approveTime = (Parameter)param.getParams().get("approveTime");
        String stateDateSub = null;
        if (approveTime != null) {
            Date dateSub = null;
            String[] date = approveTime.getValue().toString().split(",");
            try {
                dateSub = DateUtils.parseDate((String)date[0], (String[])new String[]{"yyyy-MM-dd"});
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            stateDateSub = DateFormatUtils.format((Date)DateUtils.addDays(dateSub, (int)-1), (String)"yyyy-MM-dd");
        }
        List<FlowmeterEntity> flowmeterEntityListTop = new ArrayList<FlowmeterEntity>();
        if (stateDateSub != null) {
            param.getParams().remove("approveTime");
            param.getParams().put("approveTime", new Parameter("le", (Object)stateDateSub));
            flowmeterEntityListTop = this.flowmeterService.queryList(param, false);
        }
        List<GatherSendVO> gatherSendVOList = this.service.queryFlow(flowmeterEntityList, flowmeterEntityListTop);
        Page pageData = new Page((long)param.getPageIndex(), (long)param.getPageSize(), (long)gatherSendVOList.size());
        pageData.setRecords(gatherSendVOList);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("projectId");
        fuzzyFields.add("materialCode");
        fuzzyFields.add("specialModel");
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialCategoryCode");
        fuzzyFields.add("materialCategoryName");
        fuzzyFields.add("operationType");
        fuzzyFields.add("accessType");
        fuzzyFields.add("time");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("billStatus", new Parameter("eq", (Object)1));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("projectDepartmentId", new Parameter("in", departmentIds));
        }
        List flowmeterEntityList = this.flowmeterService.queryList(param, false);
        Parameter approveTime = (Parameter)param.getParams().get("approveTime");
        String stateDateSub = null;
        if (approveTime != null) {
            Date dateSub = null;
            String[] date = approveTime.getValue().toString().split(",");
            try {
                dateSub = DateUtils.parseDate((String)date[0], (String[])new String[]{"yyyy-MM-dd"});
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            stateDateSub = DateFormatUtils.format((Date)DateUtils.addDays(dateSub, (int)-1), (String)"yyyy-MM-dd");
        }
        List<FlowmeterEntity> flowmeterEntityListTop = new ArrayList<FlowmeterEntity>();
        if (stateDateSub != null) {
            param.getParams().remove("approveTime");
            param.getParams().put("approveTime", new Parameter("le", (Object)stateDateSub));
            flowmeterEntityListTop = this.flowmeterService.queryList(param, false);
        }
        List<GatherSendVO> gatherSendVOList = this.service.queryFlow(flowmeterEntityList, flowmeterEntityListTop);
        HashMap<String, List<GatherSendVO>> beans = new HashMap<String, List<GatherSendVO>>();
        beans.put("records", gatherSendVOList);
        ExcelExport.getInstance().export("GatherSend-export.xlsx", beans, response);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }
}

