/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.material.bean.MonthOrgDetailEntity;
import com.ejianc.business.material.bean.MonthOrgEntity;
import com.ejianc.business.material.bean.MonthProjectEntity;
import com.ejianc.business.material.mapper.MonthOrgMapper;
import com.ejianc.business.material.service.IMonthOrgDetailService;
import com.ejianc.business.material.service.IMonthOrgService;
import com.ejianc.business.material.service.IMonthProjectService;
import com.ejianc.business.material.vo.MonthOrgVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="monthOrgService")
public class MonthOrgServiceImpl
extends BaseServiceImpl<MonthOrgMapper, MonthOrgEntity>
implements IMonthOrgService {
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IMonthProjectService monthProjectService;
    @Autowired
    private IMonthOrgDetailService monthOrgDetailService;
    private static final String BILL_CODE = "MONTH-ORG";

    @Override
    public MonthOrgVO saveOrUpdate(MonthOrgVO saveOrUpdateVO) {
        List<MonthOrgDetailEntity> methodReviewDetailList;
        MonthOrgEntity methodReviewEntity;
        List<MonthOrgDetailEntity> methodReviewDetailList2;
        int curCount;
        QueryWrapper curQuery = new QueryWrapper();
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM");
        String month = sdf1.format(saveOrUpdateVO.getMonth());
        curQuery.eq((Object)"DATE_FORMAT(month, '%Y-%m' )", (Object)month);
        curQuery.eq((Object)"org_id", (Object)saveOrUpdateVO.getProjectId());
        if (saveOrUpdateVO.getId() != null) {
            curQuery.ne((Object)"id", (Object)saveOrUpdateVO.getId());
        }
        if ((curCount = super.count((Wrapper)curQuery)) > 0) {
            throw new BusinessException("\u4e00\u4e2a\u7ec4\u7ec7\u6bcf\u4e2a\u6708\u53ea\u80fd\u505a\u4e00\u4e2a\u5355\u636e\u3002");
        }
        LambdaQueryWrapper lambda = Wrappers.lambdaQuery();
        lambda.eq(MonthOrgEntity::getProjectId, (Object)saveOrUpdateVO.getProjectId());
        lambda.notIn(MonthOrgEntity::getBillState, new Object[]{1, 3});
        lambda.ne(saveOrUpdateVO.getId() != null, BaseEntity::getId, (Object)saveOrUpdateVO.getId());
        int curCount2 = super.count((Wrapper)lambda);
        if (curCount2 > 0) {
            throw new BusinessException(" \u4e00\u4e2a\u7ec4\u7ec7\u5f53\u524d\u6700\u591a\u53ea\u80fd\u6709\u4e00\u4e2a\u975e\u751f\u6548\u6001\u5355\u636e\u3002");
        }
        MonthOrgEntity entity = (MonthOrgEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), MonthOrgEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (saveOrUpdateVO.getId() != null && CollectionUtils.isNotEmpty(methodReviewDetailList2 = (methodReviewEntity = (MonthOrgEntity)((Object)super.selectById((Serializable)saveOrUpdateVO.getId()))).getMonthOrgDetailList())) {
            List monthProjectIds = methodReviewDetailList2.stream().map(MonthOrgDetailEntity::getMonthProjectId).collect(Collectors.toList());
            LambdaQueryWrapper lambdaPro = new LambdaQueryWrapper();
            lambdaPro.in(BaseEntity::getId, monthProjectIds);
            List methodApplyEntities = this.monthProjectService.list((Wrapper)lambdaPro);
            if (CollectionUtils.isNotEmpty((Collection)methodApplyEntities)) {
                for (MonthProjectEntity monthProjectEntity : methodApplyEntities) {
                    monthProjectEntity.setUseStatus(0);
                }
                this.monthProjectService.updateBatchById(methodApplyEntities);
            }
        }
        super.saveOrUpdate((Object)entity, false);
        if (saveOrUpdateVO.getId() != null && CollectionUtils.isNotEmpty(methodReviewDetailList = entity.getMonthOrgDetailList())) {
            List monthProjectIds = methodReviewDetailList.stream().map(MonthOrgDetailEntity::getMonthProjectId).collect(Collectors.toList());
            LambdaQueryWrapper lambdaPro = new LambdaQueryWrapper();
            lambdaPro.in(BaseEntity::getId, monthProjectIds);
            List methodApplyEntities = this.monthProjectService.list((Wrapper)lambdaPro);
            if (CollectionUtils.isNotEmpty((Collection)methodApplyEntities)) {
                for (MonthProjectEntity monthProjectEntity : methodApplyEntities) {
                    monthProjectEntity.setUseStatus(1);
                }
                this.monthProjectService.updateBatchById(methodApplyEntities);
            }
        }
        MonthOrgVO vo = (MonthOrgVO)((Object)BeanMapper.map((Object)((Object)entity), MonthOrgVO.class));
        return vo;
    }

    @Override
    @Transactional
    public void delete(List<MonthOrgVO> vos) {
        List ids = vos.stream().map(BaseVO::getId).collect(Collectors.toList());
        LambdaQueryWrapper methodReviewDetailLambdaWrapper = new LambdaQueryWrapper();
        methodReviewDetailLambdaWrapper.in(MonthOrgDetailEntity::getMid, ids);
        List methodReviewDetailEntities = this.monthOrgDetailService.list((Wrapper)methodReviewDetailLambdaWrapper);
        List methodIds = methodReviewDetailEntities.stream().map(MonthOrgDetailEntity::getMonthProjectId).collect(Collectors.toList());
        LambdaQueryWrapper lambda = new LambdaQueryWrapper();
        lambda.in(BaseEntity::getId, methodIds);
        List methodApplyEntities = this.monthProjectService.list((Wrapper)lambda);
        for (MonthProjectEntity methodApplyEntity : methodApplyEntities) {
            methodApplyEntity.setUseStatus(0);
        }
        this.monthProjectService.updateBatchById(methodApplyEntities);
        super.removeByIds((Collection)vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
    }
}

