/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.bean.FlowmeterEntity;
import com.ejianc.business.material.bean.StoreBalanceEntity;
import com.ejianc.business.material.mapper.StoreBalanceMapper;
import com.ejianc.business.material.service.IStoreBalanceService;
import com.ejianc.business.material.utils.DateUtils;
import com.ejianc.business.material.vo.StoreBalanceDetailVO;
import com.ejianc.business.material.vo.StoreBalanceVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="storeBalanceService")
public class StoreBalanceServiceImpl
extends BaseServiceImpl<StoreBalanceMapper, StoreBalanceEntity>
implements IStoreBalanceService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private StoreBalanceMapper storeBalanceMapper;
    @Autowired
    private IStoreBalanceService storeBalanceService;

    /*
     * WARNING - void declaration
     */
    @Override
    public StoreBalanceVO queryStoreBalanceByProjectId(Long projectId, String month, String storeId) {
        void var14_25;
        StoreBalanceDetailVO cvo;
        Long k;
        StoreBalanceVO storeBalanceVO = new StoreBalanceVO();
        String resMonth = DateUtils.dateSimple4(month);
        List<FlowmeterEntity> flowmeterEntityList = this.storeBalanceMapper.queryFlowmeetrAll(projectId, resMonth, Long.parseLong(storeId));
        List<FlowmeterEntity> flowmeterEntities = this.packageFlowmeter(flowmeterEntityList);
        ArrayList<StoreBalanceDetailVO> storeBalanceDetailVOS = new ArrayList<StoreBalanceDetailVO>();
        for (FlowmeterEntity flowmeterEntity : flowmeterEntities) {
            StoreBalanceDetailVO storeBalanceDetailVO = new StoreBalanceDetailVO();
            storeBalanceDetailVO.setId(IdWorker.getId());
            storeBalanceDetailVO.setMaterialCategoryId(flowmeterEntity.getMaterialCategoryId());
            storeBalanceDetailVO.setMaterialCategoryCode(flowmeterEntity.getMaterialCategoryCode());
            storeBalanceDetailVO.setMaterialCategoryName(flowmeterEntity.getMaterialCategoryName());
            storeBalanceDetailVO.setMaterialId(flowmeterEntity.getMaterialId());
            storeBalanceDetailVO.setMaterialCode(flowmeterEntity.getMaterialCode());
            storeBalanceDetailVO.setMaterialName(flowmeterEntity.getMaterialName());
            storeBalanceDetailVO.setMaterialSpec(flowmeterEntity.getSpecialModel());
            storeBalanceDetailVO.setMaterialUnit(flowmeterEntity.getMeasurementUnit());
            storeBalanceDetailVO.setStoreId(flowmeterEntity.getStoreId());
            storeBalanceDetailVO.setProjectId(flowmeterEntity.getProjectId());
            storeBalanceDetailVO.setInstoreQuantity(flowmeterEntity.getEnterQuantity());
            storeBalanceDetailVO.setInstoreUnitPriceTax(flowmeterEntity.getEnterUnitPriceIncluetax());
            storeBalanceDetailVO.setInstoreUnitPriceUntax(flowmeterEntity.getEnterUnitPriceExcluetax());
            storeBalanceDetailVO.setInstoreAmountTax(flowmeterEntity.getEnterAmountIncluetax());
            storeBalanceDetailVO.setInstoreAmountUntax(flowmeterEntity.getEnterAmountExcluetax());
            storeBalanceDetailVO.setDeliveryQuantity(flowmeterEntity.getDeliveryQuantity());
            storeBalanceDetailVO.setDeliveryAmountIncluetax(flowmeterEntity.getDeliveryAmountIncluetax());
            storeBalanceDetailVO.setDeliveryAmountExcluetax(flowmeterEntity.getDeliveryAmountExcluetax());
            storeBalanceDetailVO.setDeliveryUnitPriceIncluetax(flowmeterEntity.getDeliveryUnitPriceIncluetax());
            storeBalanceDetailVO.setDeliveryUnitPriceExcluetax(flowmeterEntity.getDeliveryUnitPriceExcluetax());
            storeBalanceDetailVOS.add(storeBalanceDetailVO);
        }
        StoreBalanceDetailVO storeBalanceDetailVO2 = this.storeBalanceMapper.queryId(projectId, Long.parseLong(storeId));
        Long id = null;
        if (storeBalanceDetailVO2 != null) {
            id = storeBalanceDetailVO2.getId();
        }
        List<Object> storeBalanceDetailVOList = new ArrayList();
        if (id != null) {
            storeBalanceDetailVOList = this.queryLastMonthList(id);
        }
        ArrayList<Object> voList = new ArrayList<Object>();
        if (CollectionUtils.isNotEmpty(storeBalanceDetailVOS)) {
            voList.addAll(storeBalanceDetailVOS);
        }
        if (CollectionUtils.isNotEmpty(storeBalanceDetailVOList)) {
            for (StoreBalanceDetailVO storeBalanceDetailVO : storeBalanceDetailVOList) {
                storeBalanceDetailVO.setStoreId(Long.parseLong(storeId));
                storeBalanceDetailVO.setProjectId(projectId);
            }
            voList.addAll(storeBalanceDetailVOList);
        }
        ArrayList<StoreBalanceDetailVO> detailVOS = new ArrayList<StoreBalanceDetailVO>();
        if (CollectionUtils.isNotEmpty(voList)) {
            List list = voList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<StoreBalanceDetailVO>(Comparator.comparing(f -> f.getMaterialId() + "_" + f.getProjectId() + "_" + f.getStoreId()))), ArrayList::new));
            for (StoreBalanceDetailVO storeBalanceDetailVO : list) {
                StoreBalanceDetailVO storeBalanceDetailVO1 = new StoreBalanceDetailVO();
                storeBalanceDetailVO1.setId(IdWorker.getId());
                storeBalanceDetailVO1.setProjectId(storeBalanceDetailVO.getProjectId());
                storeBalanceDetailVO1.setProjectName(storeBalanceDetailVO.getProjectName());
                storeBalanceDetailVO1.setStoreId(storeBalanceDetailVO.getStoreId());
                storeBalanceDetailVO1.setStoreName(storeBalanceDetailVO.getStoreName());
                storeBalanceDetailVO1.setMaterialCategoryCode(storeBalanceDetailVO.getMaterialCategoryCode());
                storeBalanceDetailVO1.setMaterialCategoryName(storeBalanceDetailVO.getMaterialCategoryName());
                storeBalanceDetailVO1.setMaterialId(storeBalanceDetailVO.getMaterialId());
                storeBalanceDetailVO1.setMaterialCode(storeBalanceDetailVO.getMaterialCode());
                storeBalanceDetailVO1.setMaterialName(storeBalanceDetailVO.getMaterialName());
                storeBalanceDetailVO1.setMaterialSpec(storeBalanceDetailVO.getMaterialSpec());
                storeBalanceDetailVO1.setMaterialUnit(storeBalanceDetailVO.getMaterialUnit());
                detailVOS.add(storeBalanceDetailVO1);
            }
        }
        if (CollectionUtils.isNotEmpty(storeBalanceDetailVOList)) {
            Map map = storeBalanceDetailVOList.stream().collect(Collectors.toMap(x -> x.getProjectId() + x.getMaterialId() + x.getStoreId(), Function.identity(), (k1, k2) -> k2));
            for (StoreBalanceDetailVO vo : detailVOS) {
                k = vo.getProjectId() + vo.getMaterialId() + vo.getStoreId();
                if (!map.containsKey(k)) continue;
                cvo = (StoreBalanceDetailVO)((Object)map.get(k));
                vo.setLastQuantity(cvo.getActualCheckQuantity());
                vo.setLastUnitPriceTax(cvo.getActualUnitPriceTax());
                vo.setLastUnitPriceUntax(cvo.getActualUnitPriceUntax());
                vo.setLastAmountTax(cvo.getActualAmountTax());
                vo.setLastAmountUntax(cvo.getActualAmountUntax());
            }
        }
        if (CollectionUtils.isNotEmpty(storeBalanceDetailVOS)) {
            Map map = storeBalanceDetailVOS.stream().collect(Collectors.toMap(x -> x.getProjectId() + x.getMaterialId() + x.getStoreId(), Function.identity(), (k1, k2) -> k2));
            for (StoreBalanceDetailVO vo : detailVOS) {
                k = vo.getProjectId() + vo.getMaterialId() + vo.getStoreId();
                if (!map.containsKey(k)) continue;
                cvo = (StoreBalanceDetailVO)((Object)map.get(k));
                vo.setInstoreQuantity(cvo.getInstoreQuantity());
                vo.setInstoreUnitPriceTax(cvo.getInstoreUnitPriceTax());
                vo.setInstoreUnitPriceUntax(cvo.getInstoreUnitPriceUntax());
                vo.setInstoreAmountTax(cvo.getInstoreAmountTax());
                vo.setInstoreAmountUntax(cvo.getInstoreAmountUntax());
                vo.setDeliveryUnitPriceIncluetax(ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeAdd((BigDecimal)vo.getLastAmountTax(), (BigDecimal)vo.getInstoreAmountTax()), (BigDecimal)ComputeUtil.safeAdd((BigDecimal)vo.getLastQuantity(), (BigDecimal)vo.getInstoreQuantity())));
                vo.setDeliveryUnitPriceExcluetax(ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeAdd((BigDecimal)vo.getLastAmountUntax(), (BigDecimal)vo.getInstoreAmountUntax()), (BigDecimal)ComputeUtil.safeAdd((BigDecimal)vo.getLastQuantity(), (BigDecimal)vo.getInstoreQuantity())));
                vo.setDeliveryQuantity(cvo.getDeliveryQuantity());
                vo.setDeliveryAmountIncluetax(ComputeUtil.safeMultiply((BigDecimal)cvo.getDeliveryQuantity(), (BigDecimal)vo.getDeliveryUnitPriceIncluetax()));
                vo.setDeliveryAmountExcluetax(ComputeUtil.safeMultiply((BigDecimal)cvo.getDeliveryQuantity(), (BigDecimal)vo.getDeliveryUnitPriceExcluetax()));
            }
        }
        if (CollectionUtils.isNotEmpty(detailVOS)) {
            for (StoreBalanceDetailVO vo : detailVOS) {
                vo.setCurrentUnitPriceTax(ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeAdd((BigDecimal)vo.getLastAmountTax(), (BigDecimal)vo.getInstoreAmountTax()), (BigDecimal)ComputeUtil.safeAdd((BigDecimal)vo.getLastQuantity(), (BigDecimal)vo.getInstoreQuantity())));
                vo.setCurrentUnitPriceUntax(ComputeUtil.safeDiv((BigDecimal)ComputeUtil.safeAdd((BigDecimal)vo.getLastAmountUntax(), (BigDecimal)vo.getInstoreAmountUntax()), (BigDecimal)ComputeUtil.safeAdd((BigDecimal)vo.getLastQuantity(), (BigDecimal)vo.getInstoreQuantity())));
                vo.setCurrentQuantity(ComputeUtil.safeSub((BigDecimal)ComputeUtil.safeAdd((BigDecimal)vo.getLastQuantity(), (BigDecimal)vo.getInstoreQuantity()), (BigDecimal)vo.getDeliveryQuantity()));
                vo.setCurrentAmountTax(ComputeUtil.safeMultiply((BigDecimal)vo.getCurrentUnitPriceTax(), (BigDecimal)vo.getCurrentQuantity()));
                vo.setCurrentAmountUntax(ComputeUtil.safeMultiply((BigDecimal)vo.getCurrentUnitPriceUntax(), (BigDecimal)vo.getCurrentQuantity()));
            }
        }
        for (StoreBalanceDetailVO storeBalanceDetailVO : detailVOS) {
            storeBalanceDetailVO.setActualUnitPriceTax(storeBalanceDetailVO.getCurrentUnitPriceTax());
            storeBalanceDetailVO.setActualUnitPriceUntax(storeBalanceDetailVO.getCurrentUnitPriceUntax());
            storeBalanceDetailVO.setActualCheckQuantity(storeBalanceDetailVO.getCurrentQuantity());
            storeBalanceDetailVO.setActualAmountTax(ComputeUtil.safeMultiply((BigDecimal)storeBalanceDetailVO.getCurrentQuantity(), (BigDecimal)storeBalanceDetailVO.getCurrentUnitPriceTax()));
            storeBalanceDetailVO.setActualAmountUntax(ComputeUtil.safeMultiply((BigDecimal)storeBalanceDetailVO.getCurrentQuantity(), (BigDecimal)storeBalanceDetailVO.getCurrentUnitPriceUntax()));
            storeBalanceDetailVO.setOutstoreQuantity(ComputeUtil.safeSub((BigDecimal)ComputeUtil.safeAdd((BigDecimal)storeBalanceDetailVO.getLastQuantity(), (BigDecimal)storeBalanceDetailVO.getInstoreQuantity()), (BigDecimal)storeBalanceDetailVO.getActualCheckQuantity()));
            storeBalanceDetailVO.setOutstoreAmountTax(ComputeUtil.safeSub((BigDecimal)ComputeUtil.safeAdd((BigDecimal)storeBalanceDetailVO.getLastAmountTax(), (BigDecimal)storeBalanceDetailVO.getInstoreAmountTax()), (BigDecimal)storeBalanceDetailVO.getActualAmountTax()));
            storeBalanceDetailVO.setOutstoreAmountUntax(ComputeUtil.safeSub((BigDecimal)ComputeUtil.safeAdd((BigDecimal)storeBalanceDetailVO.getLastAmountUntax(), (BigDecimal)storeBalanceDetailVO.getInstoreAmountUntax()), (BigDecimal)storeBalanceDetailVO.getActualAmountUntax()));
            storeBalanceDetailVO.setOutstoreUnitPriceTax(ComputeUtil.safeDiv((BigDecimal)storeBalanceDetailVO.getOutstoreAmountTax(), (BigDecimal)storeBalanceDetailVO.getOutstoreQuantity()));
            storeBalanceDetailVO.setOutstoreUnitPriceUntax(ComputeUtil.safeDiv((BigDecimal)storeBalanceDetailVO.getOutstoreAmountUntax(), (BigDecimal)storeBalanceDetailVO.getOutstoreQuantity()));
        }
        BigDecimal bigDecimal = new BigDecimal(0);
        BigDecimal lastAmountUntaxTotal = new BigDecimal(0);
        BigDecimal lastAmountTaxTotal = new BigDecimal(0);
        BigDecimal instoreQuantityTotal = new BigDecimal(0);
        BigDecimal instoreAmountUntaxTotal = new BigDecimal(0);
        BigDecimal instoreAmountTaxTotal = new BigDecimal(0);
        BigDecimal currentQuantityTotal = new BigDecimal(0);
        BigDecimal currentAmountTaxTotal = new BigDecimal(0);
        BigDecimal currentAmountUntaxTotal = new BigDecimal(0);
        BigDecimal outstoreQuantityTotal = new BigDecimal(0);
        BigDecimal outstoreAmountUntaxTotal = new BigDecimal(0);
        BigDecimal outstoreAmountTaxTotal = new BigDecimal(0);
        for (StoreBalanceDetailVO storeBalanceDetailVO : detailVOS) {
            BigDecimal bigDecimal2 = ComputeUtil.safeAdd((BigDecimal)var14_25, (BigDecimal)storeBalanceDetailVO.getLastQuantity());
            lastAmountUntaxTotal = ComputeUtil.safeAdd((BigDecimal)lastAmountUntaxTotal, (BigDecimal)storeBalanceDetailVO.getLastAmountUntax());
            lastAmountTaxTotal = ComputeUtil.safeAdd((BigDecimal)lastAmountTaxTotal, (BigDecimal)storeBalanceDetailVO.getLastAmountTax());
            instoreQuantityTotal = ComputeUtil.safeAdd((BigDecimal)instoreQuantityTotal, (BigDecimal)storeBalanceDetailVO.getInstoreQuantity());
            instoreAmountUntaxTotal = ComputeUtil.safeAdd((BigDecimal)instoreAmountUntaxTotal, (BigDecimal)storeBalanceDetailVO.getInstoreAmountUntax());
            instoreAmountTaxTotal = ComputeUtil.safeAdd((BigDecimal)instoreAmountTaxTotal, (BigDecimal)storeBalanceDetailVO.getInstoreAmountTax());
            currentQuantityTotal = ComputeUtil.safeAdd((BigDecimal)currentQuantityTotal, (BigDecimal)storeBalanceDetailVO.getCurrentQuantity());
            currentAmountTaxTotal = ComputeUtil.safeAdd((BigDecimal)currentAmountTaxTotal, (BigDecimal)storeBalanceDetailVO.getCurrentAmountTax());
            currentAmountUntaxTotal = ComputeUtil.safeAdd((BigDecimal)currentAmountUntaxTotal, (BigDecimal)storeBalanceDetailVO.getCurrentAmountUntax());
            outstoreQuantityTotal = ComputeUtil.safeAdd((BigDecimal)outstoreQuantityTotal, (BigDecimal)storeBalanceDetailVO.getOutstoreQuantity());
            outstoreAmountUntaxTotal = ComputeUtil.safeAdd((BigDecimal)outstoreAmountUntaxTotal, (BigDecimal)storeBalanceDetailVO.getOutstoreAmountUntax());
            outstoreAmountTaxTotal = ComputeUtil.safeAdd((BigDecimal)outstoreAmountTaxTotal, (BigDecimal)storeBalanceDetailVO.getOutstoreAmountTax());
        }
        storeBalanceVO.setLastQuantityTotal((BigDecimal)var14_25);
        storeBalanceVO.setLastAmountUntaxTotal(lastAmountUntaxTotal);
        storeBalanceVO.setLastAmountTaxTotal(lastAmountTaxTotal);
        storeBalanceVO.setInstoreQuantityTotal(instoreQuantityTotal);
        storeBalanceVO.setInstoreAmountUntaxTotal(instoreAmountUntaxTotal);
        storeBalanceVO.setInstoreAmountTaxTotal(instoreAmountTaxTotal);
        storeBalanceVO.setCurrentQuantityTotal(currentQuantityTotal);
        storeBalanceVO.setCurrentAmountTaxTotal(currentAmountTaxTotal);
        storeBalanceVO.setCurrentAmountUntaxTotal(currentAmountUntaxTotal);
        storeBalanceVO.setOutstoreQuantityTotal(outstoreQuantityTotal);
        storeBalanceVO.setOutstoreAmountUntaxTotal(outstoreAmountUntaxTotal);
        storeBalanceVO.setOutstoreAmountTaxTotal(outstoreAmountTaxTotal);
        storeBalanceVO.setStoreBalanceDetailEntities(detailVOS);
        return storeBalanceVO;
    }

    @Override
    public com.ejianc.foundation.material.vo.StoreBalanceDetailVO queryStoreBalanceMonth(Long projectId, String month, String materialCategoryCode) {
        List<com.ejianc.foundation.material.vo.StoreBalanceDetailVO> storeBalanceDetailList = this.storeBalanceMapper.queryStoreBalanceDetailMonth(projectId, month, materialCategoryCode);
        this.logger.info("---------\u6839\u636e\u9879\u76ee\u3001\u6708\u4efd\u3001\u7269\u8d44\u5206\u7c7b\u67e5\u8be2\u7269\u8d44\u7ed3\u5b58\u8868\u5165\u53c2--------");
        this.logger.info("projectId\uff1a" + projectId);
        this.logger.info("month\uff1a" + month);
        this.logger.info("materialCategoryCode\uff1a" + materialCategoryCode);
        this.logger.info("---------storeBalanceDetailList--------" + JSON.toJSONString(storeBalanceDetailList));
        if (storeBalanceDetailList != null && storeBalanceDetailList.size() > 0) {
            return storeBalanceDetailList.get(0);
        }
        return null;
    }

    @Override
    public List<com.ejianc.foundation.material.vo.StoreBalanceDetailVO> queryMaterialConsumeMonth(Long projectId, String month) {
        return this.storeBalanceMapper.queryMaterialConsumeMonth(projectId, month);
    }

    @Override
    public boolean updateSettlementState(Long projectId, Integer state, String monthStr) {
        boolean flag = true;
        QueryWrapper query = new QueryWrapper();
        query.eq((Object)"project_id", (Object)projectId);
        query.eq((Object)"DATE_FORMAT( month, '%Y-%m' )", (Object)monthStr);
        List list = this.storeBalanceService.list((Wrapper)query);
        if (!list.isEmpty()) {
            for (StoreBalanceEntity entity : list) {
                entity.setIsSettlement(state);
            }
            flag = this.storeBalanceService.updateBatchById(list);
        }
        return flag;
    }

    @Override
    public boolean queryIsSettlement(Long projectId, String monthStr) {
        LambdaQueryWrapper query = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(StoreBalanceEntity::getProjectId, (Object)projectId)).apply("DATE_FORMAT(month, '%Y-%m') < '" + monthStr + "'", new Object[0])).and(qw -> (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)qw.isNull(StoreBalanceEntity::getIsSettlement)).or()).eq(StoreBalanceEntity::getIsSettlement, (Object)0));
        int count = this.storeBalanceService.count((Wrapper)query);
        if (count > 0) {
            throw new BusinessException("\u7269\u8d44\u7ed3\u5b58\u6709\u5f80\u671f\u672a\u5f52\u96c6\u7684\u6570\u636e,\u65e0\u6cd5\u5f52\u96c6\u672c\u6708\u6210\u672c\uff01");
        }
        LambdaQueryWrapper query1 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(StoreBalanceEntity::getProjectId, (Object)projectId)).ne(StoreBalanceEntity::getBillState, (Object)1)).ne(StoreBalanceEntity::getBillState, (Object)3)).apply("DATE_FORMAT(month, '%Y-%m') = '" + monthStr + "'", new Object[0]);
        int count1 = this.storeBalanceService.count((Wrapper)query1);
        if (count1 > 0) {
            throw new BusinessException("\u7269\u8d44\u7ed3\u5b58\u6709\u672c\u671f\u5ba1\u6279\u672a\u901a\u8fc7\u7684\u6570\u636e,\u65e0\u6cd5\u5f52\u96c6\u672c\u6708\u6210\u672c\uff01");
        }
        LambdaQueryWrapper query2 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(StoreBalanceEntity::getProjectId, (Object)projectId)).in(StoreBalanceEntity::getBillState, new Object[]{1, 3})).apply("DATE_FORMAT(month, '%Y-%m') = '" + monthStr + "'", new Object[0]);
        int count2 = this.storeBalanceService.count((Wrapper)query2);
        if (count2 > 0) {
            throw new BusinessException("\u7269\u8d44\u7ed3\u5b58\u6ca1\u6709\u672c\u671f\u5df2\u751f\u6548\u7684\u6570\u636e,\u65e0\u6cd5\u5f52\u96c6\u672c\u6708\u6210\u672c\uff01");
        }
        return true;
    }

    @Override
    public List<StoreBalanceDetailVO> queryLastMonthList(Long id) {
        return this.storeBalanceMapper.queryLastMonthList(id);
    }

    private List<FlowmeterEntity> packageFlowmeter(List<FlowmeterEntity> flowmeterEntityList) {
        ArrayList<FlowmeterEntity> flowmeterEntityArrayList = new ArrayList<FlowmeterEntity>();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(flowmeterEntityList)) {
            List flowmeterEntityListNew = flowmeterEntityList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<FlowmeterEntity>(Comparator.comparing(f -> f.getMaterialId() + "_" + f.getProjectId()))), ArrayList::new));
            Map<String, BigDecimal> enterQuantityMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("\u5165\u5e93")).collect(Collectors.groupingBy(score -> score.getMaterialId() + "_" + score.getProjectId(), Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            Map<String, BigDecimal> enterAmountIncluetaxMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("\u5165\u5e93")).collect(Collectors.groupingBy(score -> score.getMaterialId() + "_" + score.getProjectId(), Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getAmountIncluetax()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            Map<String, BigDecimal> enterAmountExcluetaxMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("\u5165\u5e93")).collect(Collectors.groupingBy(score -> score.getMaterialId() + "_" + score.getProjectId(), Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getAmountExcluetax()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            Map<String, BigDecimal> deliveryQuantityMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("\u51fa\u5e93")).collect(Collectors.groupingBy(score -> score.getMaterialId() + "_" + score.getProjectId(), Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            Map<String, BigDecimal> deliveryAmountIncluetaxMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("\u51fa\u5e93")).collect(Collectors.groupingBy(score -> score.getMaterialId() + "_" + score.getProjectId(), Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getAmountIncluetax()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            Map<String, BigDecimal> deliveryAmountExcluetaxMap = flowmeterEntityList.stream().filter(s -> s.getOperationType().equals("\u51fa\u5e93")).collect(Collectors.groupingBy(score -> score.getMaterialId() + "_" + score.getProjectId(), Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getAmountExcluetax()).reduce(BigDecimal.ZERO, BigDecimal::add))));
            BigDecimal enterQuantity = BigDecimal.ZERO;
            BigDecimal enterAmountIncluetax = BigDecimal.ZERO;
            BigDecimal enterAmountExcluetax = BigDecimal.ZERO;
            BigDecimal enterUnitPriceIncluetax = BigDecimal.ZERO;
            BigDecimal enterUnitPriceExcluetax = BigDecimal.ZERO;
            BigDecimal deliveryQuantity = BigDecimal.ZERO;
            BigDecimal deliveryAmountIncluetax = BigDecimal.ZERO;
            BigDecimal deliveryAmountExcluetax = BigDecimal.ZERO;
            BigDecimal deliveryUnitPriceIncluetax = BigDecimal.ZERO;
            BigDecimal deliveryUnitPriceExcluetax = BigDecimal.ZERO;
            for (FlowmeterEntity flowmeterEntity : flowmeterEntityListNew) {
                enterQuantity = BigDecimal.ZERO;
                enterAmountIncluetax = BigDecimal.ZERO;
                enterAmountExcluetax = BigDecimal.ZERO;
                enterUnitPriceIncluetax = BigDecimal.ZERO;
                enterUnitPriceExcluetax = BigDecimal.ZERO;
                deliveryQuantity = BigDecimal.ZERO;
                deliveryAmountIncluetax = BigDecimal.ZERO;
                deliveryAmountExcluetax = BigDecimal.ZERO;
                deliveryUnitPriceIncluetax = BigDecimal.ZERO;
                deliveryUnitPriceExcluetax = BigDecimal.ZERO;
                FlowmeterEntity flowmeterEntity1 = new FlowmeterEntity();
                flowmeterEntity1.setProjectId(flowmeterEntity.getProjectId());
                flowmeterEntity1.setProjectName(flowmeterEntity.getProjectName());
                flowmeterEntity1.setStoreId(flowmeterEntity.getStoreId());
                flowmeterEntity1.setStoreName(flowmeterEntity.getStoreName());
                flowmeterEntity1.setMaterialCategoryId(flowmeterEntity.getMaterialCategoryId());
                flowmeterEntity1.setMaterialCategoryCode(flowmeterEntity.getMaterialCategoryCode());
                flowmeterEntity1.setMaterialCategoryName(flowmeterEntity.getMaterialCategoryName());
                flowmeterEntity1.setMaterialId(flowmeterEntity.getMaterialId());
                flowmeterEntity1.setMaterialCode(flowmeterEntity.getMaterialCode());
                flowmeterEntity1.setMaterialName(flowmeterEntity.getMaterialName());
                flowmeterEntity1.setSpecialModel(flowmeterEntity.getSpecialModel());
                flowmeterEntity1.setMeasurementUnit(flowmeterEntity.getMeasurementUnit());
                if (enterQuantityMap.containsKey(flowmeterEntity.getMaterialId() + "_" + flowmeterEntity.getProjectId())) {
                    enterQuantity = enterQuantityMap.get(flowmeterEntity.getMaterialId() + "_" + flowmeterEntity.getProjectId());
                    flowmeterEntity1.setEnterQuantity(enterQuantity);
                }
                if (enterAmountIncluetaxMap.containsKey(flowmeterEntity.getMaterialId() + "_" + flowmeterEntity.getProjectId())) {
                    enterAmountIncluetax = enterAmountIncluetaxMap.get(flowmeterEntity.getMaterialId() + "_" + flowmeterEntity.getProjectId());
                    flowmeterEntity1.setEnterAmountIncluetax(enterAmountIncluetax);
                }
                if (enterAmountExcluetaxMap.containsKey(flowmeterEntity.getMaterialId() + "_" + flowmeterEntity.getProjectId())) {
                    enterAmountExcluetax = enterAmountExcluetaxMap.get(flowmeterEntity.getMaterialId() + "_" + flowmeterEntity.getProjectId());
                    flowmeterEntity1.setEnterAmountExcluetax(enterAmountExcluetax);
                }
                flowmeterEntity1.setEnterUnitPriceIncluetax(ComputeUtil.safeDiv((BigDecimal)enterAmountIncluetax, (BigDecimal)enterQuantity));
                flowmeterEntity1.setEnterUnitPriceExcluetax(ComputeUtil.safeDiv((BigDecimal)enterAmountExcluetax, (BigDecimal)enterQuantity));
                if (deliveryQuantityMap.containsKey(flowmeterEntity.getMaterialId() + "_" + flowmeterEntity.getProjectId())) {
                    deliveryQuantity = deliveryQuantityMap.get(flowmeterEntity.getMaterialId() + "_" + flowmeterEntity.getProjectId());
                    flowmeterEntity1.setDeliveryQuantity(deliveryQuantity);
                }
                if (deliveryAmountIncluetaxMap.containsKey(flowmeterEntity.getMaterialId() + "_" + flowmeterEntity.getProjectId())) {
                    deliveryAmountIncluetax = deliveryAmountIncluetaxMap.get(flowmeterEntity.getMaterialId() + "_" + flowmeterEntity.getProjectId());
                    flowmeterEntity1.setDeliveryAmountIncluetax(deliveryAmountIncluetax);
                }
                if (deliveryAmountExcluetaxMap.containsKey(flowmeterEntity.getMaterialId() + "_" + flowmeterEntity.getProjectId())) {
                    deliveryAmountExcluetax = deliveryAmountExcluetaxMap.get(flowmeterEntity.getMaterialId() + "_" + flowmeterEntity.getProjectId());
                    flowmeterEntity1.setDeliveryAmountExcluetax(deliveryAmountExcluetax);
                }
                flowmeterEntity1.setDeliveryUnitPriceIncluetax(ComputeUtil.safeDiv((BigDecimal)deliveryAmountIncluetax, (BigDecimal)deliveryQuantity));
                flowmeterEntity1.setDeliveryUnitPriceExcluetax(ComputeUtil.safeDiv((BigDecimal)deliveryAmountExcluetax, (BigDecimal)deliveryQuantity));
                flowmeterEntity1.setQuantity(ComputeUtil.safeSub((BigDecimal)enterQuantity, (BigDecimal)deliveryQuantity));
                flowmeterEntity1.setAmountIncluetax(ComputeUtil.safeSub((BigDecimal)enterAmountIncluetax, (BigDecimal)deliveryAmountIncluetax));
                flowmeterEntity1.setAmountExcluetax(ComputeUtil.safeSub((BigDecimal)enterAmountExcluetax, (BigDecimal)deliveryAmountExcluetax));
                flowmeterEntity1.setUnitPriceIncluetax(ComputeUtil.safeDiv((BigDecimal)flowmeterEntity1.getAmountIncluetax(), (BigDecimal)flowmeterEntity1.getQuantity()));
                flowmeterEntity1.setUnitPriceExcluetax(ComputeUtil.safeDiv((BigDecimal)flowmeterEntity1.getAmountExcluetax(), (BigDecimal)flowmeterEntity1.getQuantity()));
                flowmeterEntityArrayList.add(flowmeterEntity1);
            }
        }
        return flowmeterEntityArrayList;
    }
}

