/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.utils;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.FileUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.NumberToTextConverter;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.web.multipart.MultipartFile;

public class DetailIndexExcelReader2 {
    public static List<List<List<String>>> readExcel(MultipartFile file) {
        String originalFileName = file.getOriginalFilename();
        String extName = null;
        originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
        originalFileName.replaceAll("00.", "");
        extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
        if ("xls".equals(extName)) {
            return DetailIndexExcelReader2.read2003Excel(file);
        }
        if ("xlsx".equals(extName)) {
            return DetailIndexExcelReader2.read2007Excel(file);
        }
        throw new BusinessException("\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b");
    }

    /*
     * WARNING - void declaration
     */
    private static List<List<List<String>>> read2003Excel(MultipartFile file) {
        HSSFWorkbook hwb;
        LinkedList<List<List<String>>> resList = new LinkedList<List<List<String>>>();
        try {
            hwb = new HSSFWorkbook((InputStream)new BufferedInputStream(file.getInputStream()));
        }
        catch (IOException var17) {
            throw new BusinessException(var17.getMessage());
        }
        int size = hwb.getNumberOfSheets();
        for (int index = 0; index < size; ++index) {
            LinkedList list = new LinkedList();
            HSSFSheet sheet = hwb.getSheetAt(index);
            String value = null;
            HSSFRow row = null;
            HSSFCell cell = null;
            boolean isEmpty = true;
            int rowFirstCellNum = 0;
            int num = 1;
            if (index == 5) {
                num = 4;
            }
            if (index == 6) {
                num = 4;
            }
            if (index == 8) {
                num = 4;
            }
            if (index == 10) {
                num = 4;
            }
            if (index == 11) {
                num = 4;
            }
            if (index == 12) {
                num = 4;
            }
            if (index == 13) {
                num = 4;
            }
            if (index == 14) {
                num = 4;
            }
            if (index == 15) {
                num = 4;
            }
            if (index == 16) {
                num = 4;
            }
            if (index == 17) {
                num = 4;
            }
            if (index == 18) {
                num = 4;
            }
            if (index == 19) {
                num = 4;
            }
            if (index == 20) {
                num = 4;
            }
            if (index == 21) {
                num = 4;
            }
            for (int i = num; i < sheet.getPhysicalNumberOfRows(); ++i) {
                int headLength;
                isEmpty = true;
                row = sheet.getRow(i);
                if (row == null) continue;
                int rowLastCellNum = sheet.getRow(num).getLastCellNum();
                LinkedList<String> linked = new LinkedList<String>();
                for (headLength = rowFirstCellNum; headLength < rowLastCellNum; ++headLength) {
                    cell = row.getCell(headLength);
                    if (cell == null) {
                        linked.add("");
                        continue;
                    }
                    if (headLength == 0) {
                        linked.add(DetailIndexExcelReader2.get2003DetailIndex(cell));
                        continue;
                    }
                    if (null != cell) {
                        value = DetailIndexExcelReader2.formatCell((Cell)cell);
                    }
                    linked.add(value);
                }
                if (list.size() > 0) {
                    headLength = ((List)list.get(0)).size();
                    int nowLinkLength = linked.size();
                    if (nowLinkLength < headLength) {
                        void var18_21;
                        int n = nowLinkLength;
                        while (var18_21 < headLength) {
                            linked.add(null);
                            ++var18_21;
                        }
                    }
                }
                if (isEmpty) {
                    for (Object e : linked) {
                        if (e == null || !StringUtils.isNotBlank((CharSequence)String.valueOf(e))) continue;
                        isEmpty = false;
                        break;
                    }
                }
                if (isEmpty) break;
                list.add(linked);
            }
            resList.add(list);
        }
        return resList;
    }

    public static String formatCell(Cell cell) {
        String ret = null;
        switch (cell.getCellType()) {
            case STRING: {
                ret = cell.getStringCellValue();
                break;
            }
            case FORMULA: {
                Workbook wb = cell.getSheet().getWorkbook();
                wb.setForceFormulaRecalculation(true);
                CreationHelper crateHelper = wb.getCreationHelper();
                FormulaEvaluator evaluator = crateHelper.createFormulaEvaluator();
                evaluator.setIgnoreMissingWorkbooks(true);
                if (null == cell) break;
                Cell cell1 = evaluator.evaluateInCell(cell);
                ret = DetailIndexExcelReader2.formatCell(cell1);
                break;
            }
            case NUMERIC: {
                if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
                    SimpleDateFormat sdf = null;
                    sdf = cell.getCellStyle().getDataFormat() == HSSFDataFormat.getBuiltinFormat((String)"h:mm") ? new SimpleDateFormat("HH:mm") : new SimpleDateFormat("yyyy-MM-dd");
                    Date date = cell.getDateCellValue();
                    ret = sdf.format(date);
                    break;
                }
                if (cell.getCellStyle().getDataFormat() == 58) {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                    double value = cell.getNumericCellValue();
                    Date date = DateUtil.getJavaDate((double)value);
                    ret = sdf.format(date);
                    break;
                }
                ret = NumberToTextConverter.toText((double)cell.getNumericCellValue());
                break;
            }
            case BLANK: {
                ret = "";
                break;
            }
            case BOOLEAN: {
                ret = String.valueOf(cell.getBooleanCellValue());
                break;
            }
            case ERROR: {
                ret = null;
                break;
            }
            default: {
                ret = null;
            }
        }
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    private static List<List<List<String>>> read2007Excel(MultipartFile file) {
        XSSFWorkbook xwb;
        LinkedList<List<List<String>>> resList = new LinkedList<List<List<String>>>();
        try {
            xwb = new XSSFWorkbook((InputStream)new BufferedInputStream(file.getInputStream()));
        }
        catch (IOException var17) {
            throw new BusinessException(var17.getMessage());
        }
        int size = xwb.getNumberOfSheets();
        for (int index = 0; index < size; ++index) {
            LinkedList list = new LinkedList();
            XSSFSheet sheet = xwb.getSheetAt(index);
            String value = null;
            XSSFRow row = null;
            XSSFCell cell = null;
            boolean isEmpty = true;
            int rowFirstCellNum = 0;
            int num = 1;
            if (index == 5) {
                num = 1;
            }
            if (index == 6) {
                num = 3;
            }
            if (index == 8) {
                num = 3;
            }
            if (index == 10) {
                num = 3;
            }
            if (index == 11) {
                num = 3;
            }
            if (index == 12) {
                num = 3;
            }
            if (index == 13) {
                num = 3;
            }
            if (index == 14) {
                num = 3;
            }
            if (index == 15) {
                num = 3;
            }
            if (index == 16) {
                num = 3;
            }
            if (index == 17) {
                num = 3;
            }
            if (index == 18) {
                num = 3;
            }
            if (index == 19) {
                num = 3;
            }
            if (index == 20) {
                num = 3;
            }
            if (index == 21) {
                num = 3;
            }
            System.out.println("index--index\uff1a" + JSONObject.toJSONString((Object)index));
            for (int i = num; i < sheet.getPhysicalNumberOfRows(); ++i) {
                int headLength;
                isEmpty = true;
                row = sheet.getRow(i);
                int rowLastCellNum = sheet.getRow(num).getLastCellNum();
                if (row == null) continue;
                LinkedList<String> linked = new LinkedList<String>();
                for (headLength = rowFirstCellNum; headLength < rowLastCellNum; ++headLength) {
                    cell = row.getCell(headLength);
                    if (cell == null) {
                        linked.add("");
                        continue;
                    }
                    if (headLength == 0) {
                        linked.add(DetailIndexExcelReader2.get2007DetailIndex(cell));
                        continue;
                    }
                    if (null != cell) {
                        value = DetailIndexExcelReader2.formatCell((Cell)cell);
                    }
                    linked.add(value);
                }
                if (list.size() > 0) {
                    headLength = ((List)list.get(0)).size();
                    int nowLinkLength = linked.size();
                    if (nowLinkLength < headLength) {
                        void var18_21;
                        int n = nowLinkLength;
                        while (var18_21 < headLength) {
                            linked.add(null);
                            ++var18_21;
                        }
                    }
                }
                if (isEmpty) {
                    for (Object e : linked) {
                        if (e == null || !StringUtils.isNotBlank((CharSequence)String.valueOf(e))) continue;
                        isEmpty = false;
                        break;
                    }
                }
                if (isEmpty) break;
                list.add(linked);
            }
            resList.add(list);
        }
        return resList;
    }

    private static String get2003DetailIndex(HSSFCell cell) {
        String val = "";
        try {
            val = cell.getStringCellValue();
        }
        catch (Exception e) {
            try {
                val = String.valueOf(new BigDecimal(String.valueOf(cell.getNumericCellValue())).stripTrailingZeros());
            }
            catch (Exception e1) {
                val = " " + cell.getBooleanCellValue();
            }
        }
        return val;
    }

    private static String get2007DetailIndex(XSSFCell cell) {
        String val = "";
        try {
            val = cell.getStringCellValue();
        }
        catch (Exception e) {
            try {
                val = String.valueOf(new BigDecimal(String.valueOf(cell.getNumericCellValue())).stripTrailingZeros());
            }
            catch (Exception e1) {
                val = " " + cell.getBooleanCellValue();
            }
        }
        return val;
    }

    public static Integer getNumberOfSheets(MultipartFile file) {
        String originalFileName = new String(file.getOriginalFilename());
        String extName = null;
        originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
        originalFileName.replaceAll("00.", "");
        extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
        if ("xls".equals(extName)) {
            HSSFWorkbook hwb;
            try {
                hwb = new HSSFWorkbook((InputStream)new BufferedInputStream(file.getInputStream()));
            }
            catch (IOException var17) {
                throw new BusinessException(var17.getMessage());
            }
            return hwb.getNumberOfSheets();
        }
        if ("xlsx".equals(extName)) {
            XSSFWorkbook xwb;
            try {
                xwb = new XSSFWorkbook((InputStream)new BufferedInputStream(file.getInputStream()));
            }
            catch (IOException var17) {
                throw new BusinessException(var17.getMessage());
            }
            return xwb.getNumberOfSheets();
        }
        throw new BusinessException("\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b");
    }
}

