/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.outputValue.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.outputValue.bean.CompanyMonthChangeEntity;
import com.ejianc.business.outputValue.bean.CompanyMonthEntity;
import com.ejianc.business.outputValue.bean.CompanyMonthProjectDetailChangeEntity;
import com.ejianc.business.outputValue.bean.CompanyMonthProjectDetailEntity;
import com.ejianc.business.outputValue.bean.CompanyMonthProjectDetailRecordEntity;
import com.ejianc.business.outputValue.bean.CompanyMonthRecordEntity;
import com.ejianc.business.outputValue.service.ICompanyBusinessQuotaService;
import com.ejianc.business.outputValue.service.ICompanyMonthChangeService;
import com.ejianc.business.outputValue.service.ICompanyMonthProjectDetailChangeService;
import com.ejianc.business.outputValue.service.ICompanyMonthRecordService;
import com.ejianc.business.outputValue.service.ICompanyMonthService;
import com.ejianc.business.outputValue.service.IPcMonthActualOutputValueService;
import com.ejianc.business.outputValue.service.IProjectMonthActualOutputValueService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="companyMonthChange")
public class CompanyMonthChangeBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String COMPANYMONTH_SOURCETYPE = "companyMonth";
    private static final String COMPANYMONTH_CHANGE_SOURCETYPE = "companyMonthChange";
    private static final String COMPANYMONTH_RECORD_SOURCETYPE = "companyMonthRecord";
    private static final String COMPANYMONTH_BILLTYPE_CODE = "EJCBT202503000025";
    private static final String COMPANYMONTH_CHANGE_BILLTYPE_CODE = "EJCBT202503000026";
    private static final String COMPANYMONTH_RECORD_BILLTYPE_CODE = "EJCBT202503000027";
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private ICompanyMonthService companyMonthService;
    @Autowired
    private ICompanyMonthChangeService changeService;
    @Autowired
    private ICompanyMonthRecordService recordService;
    @Autowired
    private ICompanyMonthProjectDetailChangeService detailChangeService;
    @Autowired
    private IPcMonthActualOutputValueService pcMonthService;
    @Autowired
    private IProjectMonthActualOutputValueService projectMonthService;
    @Autowired
    private ICompanyBusinessQuotaService companyBusinessQuotaService;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public void clearBaseData(BaseEntity entity) {
        entity.setTenantId(null);
        entity.setUpdateTime(null);
        entity.setUpdateUserCode(null);
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        CompanyMonthChangeEntity changeEntity = (CompanyMonthChangeEntity)((Object)this.changeService.selectById(billId));
        CompanyMonthEntity companyMonthEntity = (CompanyMonthEntity)((Object)this.companyMonthService.selectById(changeEntity.getCompanyMonthId()));
        QueryWrapper recordWrapper = new QueryWrapper();
        recordWrapper.eq((Object)"company_month_id", (Object)companyMonthEntity.getId());
        recordWrapper.eq((Object)"dr", (Object)0);
        Integer count = this.recordService.count((Wrapper)recordWrapper);
        CompanyMonthRecordEntity recordEntity = (CompanyMonthRecordEntity)((Object)BeanMapper.map((Object)((Object)companyMonthEntity), CompanyMonthRecordEntity.class));
        Long recordId = IdWorker.getId();
        this.clearBaseData(recordEntity);
        recordEntity.setBillState(null);
        recordEntity.setCompanyMonthId(companyMonthEntity.getId());
        recordEntity.setBillVersion(String.valueOf(count + 1));
        recordEntity.setId(recordId);
        recordEntity.setChangeReason(changeEntity.getChangeReason());
        List<CompanyMonthProjectDetailEntity> detailList = companyMonthEntity.getDetailList();
        if (detailList != null && detailList.size() > 0) {
            ArrayList<CompanyMonthProjectDetailRecordEntity> recordDetailList = new ArrayList<CompanyMonthProjectDetailRecordEntity>();
            for (CompanyMonthProjectDetailEntity entity : detailList) {
                CompanyMonthProjectDetailRecordEntity reEntity = (CompanyMonthProjectDetailRecordEntity)((Object)BeanMapper.map((Object)((Object)entity), CompanyMonthProjectDetailRecordEntity.class));
                this.clearBaseData(reEntity);
                reEntity.setRecordId(recordId);
                recordDetailList.add(reEntity);
                entity.setRowState("del");
            }
            recordEntity.setDetailList(recordDetailList);
        }
        String sourceBillType = COMPANYMONTH_BILLTYPE_CODE;
        String targetBillType = COMPANYMONTH_RECORD_BILLTYPE_CODE;
        this.attachmentApi.copyFilesFromSourceBillToTargetBill(companyMonthEntity.getId().toString(), sourceBillType, COMPANYMONTH_SOURCETYPE, recordId.toString(), targetBillType, COMPANYMONTH_RECORD_SOURCETYPE);
        this.recordService.saveOrUpdate((Object)recordEntity, false);
        this.logger.info("---------\u751f\u6210\u5408\u540c\u4fe1\u606f\u5b8c\u6210--------");
        CompanyMonthEntity newContractEntity = (CompanyMonthEntity)((Object)BeanMapper.map((Object)((Object)changeEntity), CompanyMonthEntity.class));
        newContractEntity.setChangeState("3");
        newContractEntity.setChangeId(null);
        newContractEntity.setBillCode(companyMonthEntity.getBillCode());
        newContractEntity.setBillState(companyMonthEntity.getBillState());
        newContractEntity.setId(companyMonthEntity.getId());
        newContractEntity.setCreateTime(companyMonthEntity.getCreateTime());
        newContractEntity.setCreateUserCode(companyMonthEntity.getCreateUserCode());
        newContractEntity.setTenantId(companyMonthEntity.getTenantId());
        newContractEntity.setVersion(companyMonthEntity.getVersion());
        newContractEntity.setEffectLastDate(new Date());
        List<CompanyMonthProjectDetailChangeEntity> changeDetailList = changeEntity.getDetailList();
        if (changeDetailList != null && changeDetailList.size() > 0) {
            List newDetailList = BeanMapper.mapList(changeDetailList, CompanyMonthProjectDetailEntity.class);
            newDetailList.addAll(detailList);
            newContractEntity.setDetailList(newDetailList);
        }
        this.companyMonthService.saveOrUpdate((Object)newContractEntity, false);
        sourceBillType = COMPANYMONTH_CHANGE_BILLTYPE_CODE;
        targetBillType = COMPANYMONTH_BILLTYPE_CODE;
        this.attachmentApi.copyFilesFromSourceBillToTargetBill(changeEntity.getId().toString(), sourceBillType, COMPANYMONTH_CHANGE_SOURCETYPE, companyMonthEntity.getId().toString(), targetBillType, COMPANYMONTH_SOURCETYPE);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"change_id", (Object)billId);
        List list = this.detailChangeService.list((Wrapper)wrapper);
        if (list != null && list.size() > 0) {
            ArrayList<Long> projectIds = new ArrayList<Long>();
            ArrayList<Long> pcIds = new ArrayList<Long>();
            HashMap<Long, CompanyMonthProjectDetailChangeEntity> projectMap = new HashMap<Long, CompanyMonthProjectDetailChangeEntity>();
            HashMap<Long, CompanyMonthProjectDetailChangeEntity> pcMap = new HashMap<Long, CompanyMonthProjectDetailChangeEntity>();
            for (CompanyMonthProjectDetailChangeEntity detailEntity : list) {
                if (detailEntity.getPcFactory() != null && detailEntity.getPcFactory().booleanValue()) {
                    if (detailEntity.getThisMonthActualOutputValueAdjust() == null) continue;
                    pcIds.add(detailEntity.getProjectActualId());
                    pcMap.put(detailEntity.getProjectActualId(), detailEntity);
                    continue;
                }
                if (detailEntity.getThisMonthActualOutputValueAdjust() == null && detailEntity.getThisMonthConfirmedOutputValueAdjust() == null) continue;
                projectIds.add(detailEntity.getProjectActualId());
                projectMap.put(detailEntity.getProjectActualId(), detailEntity);
            }
            if (projectIds != null && projectIds.size() > 0) {
                List projectList = (List)this.projectMonthService.listByIds(projectIds);
                for (BaseEntity entity : projectList) {
                    entity.setThisMonthActualOutputValue(((CompanyMonthProjectDetailChangeEntity)((Object)projectMap.get(entity.getId()))).getThisMonthActualOutputValueAdjust());
                    entity.setThisMonthConfirmedOutputValue(((CompanyMonthProjectDetailChangeEntity)((Object)projectMap.get(entity.getId()))).getThisMonthConfirmedOutputValueAdjust());
                }
                this.projectMonthService.saveOrUpdateBatch(projectList, projectList.size(), false);
            }
            if (pcIds != null && pcIds.size() > 0) {
                List pcList = (List)this.pcMonthService.listByIds(pcIds);
                for (BaseEntity entity : pcList) {
                    entity.setThisMonthCompletedTotalOutputValue(((CompanyMonthProjectDetailChangeEntity)((Object)projectMap.get(entity.getId()))).getThisMonthActualOutputValueAdjust());
                }
                this.pcMonthService.saveOrUpdateBatch(pcList, pcList.size(), false);
            }
            this.companyBusinessQuotaService.updateProjectPcInfo(changeEntity.getOrgId(), changeEntity.getYear());
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

