/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.outputValue.utils;

import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.write.handler.CellWriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteTableHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

public class ExcelFillCellMerge
implements CellWriteHandler {
    private static final String KEY = "%s-%s";
    Map<String, Integer> mergeRowInfo = new HashMap<String, Integer>();
    Map<String, Integer> mergeColInfo = new HashMap<String, Integer>();
    Map<String, List<Integer>> mergeAllInfo = new HashMap<String, List<Integer>>();

    public Map<String, Integer> getMergeRowInfo() {
        return this.mergeRowInfo;
    }

    public void setMergeRowInfo(Map<String, Integer> mergeRowInfo) {
        this.mergeRowInfo = mergeRowInfo;
    }

    public Map<String, Integer> getMergeColInfo() {
        return this.mergeColInfo;
    }

    public void setMergeColInfo(Map<String, Integer> mergeColInfo) {
        this.mergeColInfo = mergeColInfo;
    }

    public Map<String, List<Integer>> getMergeAllInfo() {
        return this.mergeAllInfo;
    }

    public void setMergeAllInfo(Map<String, List<Integer>> mergeAllInfo) {
        this.mergeAllInfo = mergeAllInfo;
    }

    public void beforeCellCreate(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Row row, Head head, Integer integer, Integer integer1, Boolean aBoolean) {
    }

    public void afterCellCreate(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Cell cell, Head head, Integer integer, Boolean aBoolean) {
    }

    public void afterCellDataConverted(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, WriteCellData<?> cellData, Cell cell, Head head, Integer integer, Boolean aBoolean) {
    }

    public void afterCellDispose(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, List<WriteCellData<?>> list, Cell cell, Head head, Integer integer, Boolean aBoolean) {
        int curRowIndex = cell.getRowIndex();
        int curColIndex = cell.getColumnIndex();
        String key = String.format(KEY, curRowIndex, curColIndex);
        if (this.mergeAllInfo.get(key) != null) {
            List<Integer> info = this.mergeAllInfo.get(key);
            this.mergeWithPrevCol(writeSheetHolder, cell, curRowIndex, curColIndex, info.get(0), info.get(1));
        } else if (this.mergeRowInfo.get(key) != null) {
            this.mergeWithPrevCol(writeSheetHolder, cell, curRowIndex, curColIndex, 0, this.mergeRowInfo.get(key));
        } else if (this.mergeColInfo.get(key) != null) {
            this.mergeWithPrevCol(writeSheetHolder, cell, curRowIndex, curColIndex, this.mergeColInfo.get(key), 0);
        }
    }

    public void mergeWithPrevCol(WriteSheetHolder writeSheetHolder, Cell cell, int curRowIndex, int curColIndex, int rowNum, int colNum) {
        Sheet sheet = writeSheetHolder.getSheet();
        CellRangeAddress cellRangeAddress = new CellRangeAddress(curRowIndex, curRowIndex + rowNum, curColIndex, curColIndex + colNum);
        sheet.addMergedRegion(cellRangeAddress);
    }

    public void addRow(int curRowIndex, int curColIndex, int num) {
        this.mergeRowInfo.put(String.format(KEY, curRowIndex, curColIndex), num);
    }

    public void addCol(int curRowIndex, int curColIndex, int num) {
        this.mergeColInfo.put(String.format(KEY, curRowIndex, curColIndex), num);
    }

    public void addAll(int curRowIndex, int curColIndex, int rowNum, int colNum) {
        ArrayList<Integer> info = new ArrayList<Integer>();
        info.add(colNum);
        info.add(rowNum);
        this.mergeAllInfo.put(String.format(KEY, curRowIndex, curColIndex), info);
    }
}

