/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.panhuo.cart.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.panhuo.apply.service.IAllotApplyService;
import com.ejianc.business.panhuo.cart.bean.ShopCartEntity;
import com.ejianc.business.panhuo.cart.mapper.ShopCartMapper;
import com.ejianc.business.panhuo.cart.service.IShopCartService;
import com.ejianc.business.panhuo.shelf.bean.GoodsEntity;
import com.ejianc.business.panhuo.shelf.service.IGoodsService;
import com.ejianc.foundation.panhuo.apply.vo.AllotApplyVO;
import com.ejianc.foundation.panhuo.cart.vo.ShopCartVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="shopCartService")
public class ShopCartServiceImpl
extends BaseServiceImpl<ShopCartMapper, ShopCartEntity>
implements IShopCartService {
    @Autowired
    private IGoodsService goodsService;
    @Autowired
    private IAllotApplyService allotApplyService;

    @Override
    public CommonResponse<List<GoodsEntity>> queryGoodsByPurUserId(Long purUserId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"pur_user_id", (Object)purUserId);
        List list = super.list((Wrapper)queryWrapper);
        List marketIds = list.stream().map(ShopCartEntity::getMarketId).collect(Collectors.toList());
        QueryWrapper queryGoods = new QueryWrapper();
        queryGoods.in((Object)"id", marketIds);
        List goods = this.goodsService.list((Wrapper)queryGoods);
        return CommonResponse.success((Object)goods);
    }

    @Override
    public CommonResponse<Integer> queryCountByPurUserId(Long purUserId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"pur_user_id", (Object)purUserId);
        return CommonResponse.success((Object)super.count((Wrapper)queryWrapper));
    }

    @Override
    public AllotApplyVO addAllotApply(List<ShopCartVO> vos) {
        ArrayList<ShopCartEntity> shopCartEntities = new ArrayList<ShopCartEntity>();
        for (ShopCartVO vo : vos) {
            ShopCartEntity shopCartEntity = (ShopCartEntity)((Object)super.selectById((Serializable)vo.getId()));
            shopCartEntity.setAllotNum(vo.getAllotNum());
            shopCartEntities.add(shopCartEntity);
        }
        AllotApplyVO allotApplyVO = this.allotApplyService.addAllotApplyByCart(shopCartEntities);
        super.saveOrUpdateBatch(shopCartEntities);
        return allotApplyVO;
    }

    @Override
    public void upShopCart(List<Long> ids) {
        super.removeByIds(ids);
    }
}

