/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.service.IMaterialsreturndetailService;
import com.ejianc.business.material.vo.MaterialsreturndetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"materialsreturndetailExport"})
public class ExcelMaterialsreturndetailController {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMaterialsreturndetailService service;

    @RequestMapping(value={"/downloadMaterialsreturndetail"})
    @ResponseBody
    public void downloadMaterialsreturndetail(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"Materialsreturndetail-import.xlsx", (String)"\u7269\u8d44\u9000\u573a\u9a8c\u8bc1\u8bb0\u5f55\u660e\u7ec6");
    }

    @RequestMapping(value={"/excelImportMaterialsreturndetail"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportMaterialsreturndetail(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<MaterialsreturndetailVO> successList = new ArrayList<MaterialsreturndetailVO>();
        ArrayList<MaterialsreturndetailVO> errorList = new ArrayList<MaterialsreturndetailVO>();
        HashMap map = new HashMap();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List<List<String>> result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                List<String> datas = result.get(i);
                StringBuilder errorsMsgBuilder = new StringBuilder();
                String materialClassCode = datas.get(0);
                String materialClassName = datas.get(1);
                String materialCode = datas.get(2);
                String name = datas.get(3);
                String spec = datas.get(4);
                String unit = datas.get(5);
                String returnCount = datas.get(6);
                String lostCount = datas.get(7);
                String maintainCount = datas.get(8);
                String remarks = datas.get(9);
                MaterialsreturndetailVO MaterialsreturndetailVO2 = new MaterialsreturndetailVO();
                MaterialsreturndetailVO2.setId(IdWorker.getId());
                MaterialsreturndetailVO2.setMaterialClassCode(StringUtils.isNotBlank((CharSequence)materialClassCode) ? materialClassCode : null);
                MaterialsreturndetailVO2.setMaterialClassName(StringUtils.isNotBlank((CharSequence)materialClassName) ? materialClassName : null);
                MaterialsreturndetailVO2.setMaterialCode(StringUtils.isNotBlank((CharSequence)materialCode) ? name : null);
                MaterialsreturndetailVO2.setName(StringUtils.isNotBlank((CharSequence)name) ? name : null);
                MaterialsreturndetailVO2.setSpec(StringUtils.isNotBlank((CharSequence)spec) ? spec : null);
                MaterialsreturndetailVO2.setUnit(StringUtils.isNotBlank((CharSequence)unit) ? unit : null);
                MaterialsreturndetailVO2.setRemarks(StringUtils.isNotBlank((CharSequence)remarks) ? remarks : null);
                if (name == null || TextUtils.isEmpty((CharSequence)name)) {
                    MaterialsreturndetailVO2.setErrorMsg("\u7269\u8d44\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    errorsMsgBuilder.append("\u7269\u8d44\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (!TextUtils.isEmpty((CharSequence)returnCount) && !NumberUtil.isNumber((String)returnCount)) {
                    MaterialsreturndetailVO2.setErrorMsg("\u9000\u573a\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u9000\u573a\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    MaterialsreturndetailVO2.setReturnCount(StringUtils.isNotBlank((CharSequence)returnCount) ? new BigDecimal(returnCount) : null);
                }
                if (!TextUtils.isEmpty((CharSequence)lostCount) && !NumberUtil.isNumber((String)lostCount)) {
                    MaterialsreturndetailVO2.setErrorMsg("\u4e22\u5931\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u4e22\u5931\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    MaterialsreturndetailVO2.setLostCount(StringUtils.isNotBlank((CharSequence)lostCount) ? new BigDecimal(lostCount) : null);
                }
                if (!TextUtils.isEmpty((CharSequence)maintainCount) && !NumberUtil.isNumber((String)maintainCount)) {
                    MaterialsreturndetailVO2.setErrorMsg("\u7ef4\u4fee\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u7ef4\u4fee\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    MaterialsreturndetailVO2.setLostCount(StringUtils.isNotBlank((CharSequence)maintainCount) ? new BigDecimal(maintainCount) : null);
                }
                if (errorsMsgBuilder.length() > 0) {
                    errorList.add(MaterialsreturndetailVO2);
                    continue;
                }
                successList.add(MaterialsreturndetailVO2);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        MaterialsreturndetailVO resVo = new MaterialsreturndetailVO();
        json.put("total", (Object)resVo);
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/excelExportMaterialsreturndetailFromDatabase"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportMaterialsreturndetailFromDatabase(@RequestBody MaterialsreturndetailVO MaterialsreturndetailVO2, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mid", (Object)MaterialsreturndetailVO2.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.service.list((Wrapper)queryWrapper);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Materialsreturndetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportMaterialsreturndetailFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportMaterialsreturndetailFromPage(@RequestBody List<MaterialsreturndetailVO> list, HttpServletResponse response) {
        HashMap<String, List<MaterialsreturndetailVO>> beans = new HashMap<String, List<MaterialsreturndetailVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("Materialsreturndetail-export.xlsx", beans, response);
    }
}

