/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.excel;

import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.service.IMaterialWarehousingdetailService;
import com.ejianc.business.material.vo.MaterialWarehousingdetailVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.support.idworker.util.IdWorker;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.util.TextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Controller
@RequestMapping(value={"materialWarehousingdetailExport"})
public class ExeclMaterialWarehousingController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IMaterialWarehousingdetailService iMaterialWarehousingdetailService;

    @RequestMapping(value={"/downloadMaterialWarehousingdetail"})
    @ResponseBody
    public void downloadMaterialWarehousingdetail(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"materialWarehousingdetail-import.xlsx", (String)"\u7269\u8d44\u9a8c\u6536\u5165\u5e93\u5355\u6a21\u677f");
    }

    @RequestMapping(value={"/excelImportMaterialWarehousingdetail"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Object> excelImportMaterialWarehousingdetail(HttpServletRequest request, HttpServletResponse response) throws ParseException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList<MaterialWarehousingdetailVO> successList = new ArrayList<MaterialWarehousingdetailVO>();
        ArrayList<MaterialWarehousingdetailVO> errorList = new ArrayList<MaterialWarehousingdetailVO>();
        HashMap map = new HashMap();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd");
        boolean isFailed = false;
        MultipartFile mf = null;
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List<List<String>> result = ExcelReader.readExcel(mf);
        if (result != null && result.size() > 0) {
            for (int i = 1; i < result.size(); ++i) {
                List<String> datas = result.get(i);
                StringBuilder errorsMsgBuilder = new StringBuilder();
                String materialCategoryCode = datas.get(0);
                String materialCategoryName = datas.get(1);
                String materialCode = datas.get(2);
                String materialName = datas.get(3);
                String specialModel = datas.get(4);
                String unit = datas.get(5);
                String quantity = datas.get(6);
                String unitPriceIncluetax = datas.get(7);
                String taxRate = datas.get(8);
                String unitPriceExcluetax = datas.get(9);
                String amountIncluetax = datas.get(10);
                String amountExcluetax = datas.get(11);
                String quantityNum = datas.get(12);
                MaterialWarehousingdetailVO materialWarehousingdetailVO = new MaterialWarehousingdetailVO();
                materialWarehousingdetailVO.setId(IdWorker.getId());
                materialWarehousingdetailVO.setMaterialCategoryCode(StringUtils.isNotBlank((CharSequence)materialCategoryCode) ? materialCategoryCode : null);
                materialWarehousingdetailVO.setMaterialCategoryName(StringUtils.isNotBlank((CharSequence)materialCategoryName) ? materialCategoryName : null);
                materialWarehousingdetailVO.setMaterialCode(StringUtils.isNotBlank((CharSequence)materialCode) ? materialCode : null);
                materialWarehousingdetailVO.setMaterialName(StringUtils.isNotBlank((CharSequence)materialName) ? materialName : null);
                materialWarehousingdetailVO.setSpecialModel(StringUtils.isNotBlank((CharSequence)specialModel) ? specialModel : null);
                materialWarehousingdetailVO.setUnit(StringUtils.isNotBlank((CharSequence)unit) ? unit : null);
                if (!TextUtils.isEmpty((CharSequence)quantity) && !NumberUtil.isNumber((String)quantity)) {
                    materialWarehousingdetailVO.setErrorMsg("\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u6570\u91cf\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    materialWarehousingdetailVO.setQuantity(StringUtils.isNotBlank((CharSequence)quantity) ? new BigDecimal(quantity) : null);
                }
                if (!TextUtils.isEmpty((CharSequence)unitPriceIncluetax) && !NumberUtil.isNumber((String)unitPriceIncluetax)) {
                    materialWarehousingdetailVO.setErrorMsg("\u5355\u4ef7\uff08\u542b\u7a0e\uff09\uff08\u5143\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u5355\u4ef7\uff08\u542b\u7a0e\uff09\uff08\u5143\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    materialWarehousingdetailVO.setUnitPriceIncluetax(StringUtils.isNotBlank((CharSequence)unitPriceIncluetax) ? new BigDecimal(unitPriceIncluetax) : null);
                }
                if (!TextUtils.isEmpty((CharSequence)taxRate) && !NumberUtil.isNumber((String)taxRate)) {
                    materialWarehousingdetailVO.setErrorMsg("\u7a0e\u7387\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u7a0e\u7387\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    materialWarehousingdetailVO.setTaxRate(StringUtils.isNotBlank((CharSequence)taxRate) ? new BigDecimal(taxRate) : null);
                }
                BigDecimal taxRateCul = materialWarehousingdetailVO.getTaxRate() == null ? new BigDecimal(0) : materialWarehousingdetailVO.getTaxRate().subtract(new BigDecimal(100));
                BigDecimal unitPriceIncluetaxCul = materialWarehousingdetailVO.getUnitPriceIncluetax() == null ? new BigDecimal(0) : materialWarehousingdetailVO.getUnitPriceIncluetax();
                BigDecimal unitPriceExcluetaxCul = unitPriceIncluetaxCul.multiply(new BigDecimal(1).add(taxRateCul));
                materialWarehousingdetailVO.setUnitPriceExcluetax(unitPriceExcluetaxCul);
                if (!TextUtils.isEmpty((CharSequence)amountIncluetax) && !NumberUtil.isNumber((String)amountIncluetax)) {
                    materialWarehousingdetailVO.setErrorMsg("\u91d1\u989d\uff08\u542b\u7a0e\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u91d1\u989d\uff08\u542b\u7a0e\uff09\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    materialWarehousingdetailVO.setAmountIncluetax(StringUtils.isNotBlank((CharSequence)amountIncluetax) ? new BigDecimal(amountIncluetax) : null);
                }
                BigDecimal quantityCul = materialWarehousingdetailVO.getQuantity() == null ? new BigDecimal(0) : materialWarehousingdetailVO.getQuantity();
                materialWarehousingdetailVO.setAmountExcluetax(unitPriceExcluetaxCul.multiply(quantityCul));
                if (!TextUtils.isEmpty((CharSequence)quantityNum) && !NumberUtil.isNumber((String)quantityNum)) {
                    materialWarehousingdetailVO.setErrorMsg("\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                    errorsMsgBuilder.append("\u8d28\u91cf\u8bc1\u660e\u53f7\u683c\u5f0f\u4e0d\u6b63\u786e\uff01");
                } else {
                    materialWarehousingdetailVO.setQuantityNum(StringUtils.isNotBlank((CharSequence)quantityNum) ? new String(quantityNum) : null);
                }
                if (errorsMsgBuilder.length() > 0) {
                    errorList.add(materialWarehousingdetailVO);
                    continue;
                }
                successList.add(materialWarehousingdetailVO);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successNum", (Object)successList.size());
        json.put("successList", successList);
        json.put("errorList", errorList);
        json.put("errorNum", (Object)errorList.size());
        MaterialWarehousingdetailVO resVo = new MaterialWarehousingdetailVO();
        json.put("total", successList);
        json.put("total", (Object)resVo);
        return CommonResponse.success((Object)json);
    }

    @RequestMapping(value={"/excelExportMaterialWarehousingdetailFromDatabase"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportMaterialWarehousingFromDatabase(@RequestBody MaterialWarehousingdetailVO materialWarehousingdetailVO, HttpServletResponse response) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"mid", (Object)materialWarehousingdetailVO.getId());
        queryWrapper.eq((Object)"dr", (Object)0);
        List list = this.iMaterialWarehousingdetailService.list((Wrapper)queryWrapper);
        HashMap<String, List> beans = new HashMap<String, List>();
        beans.put("records", list);
        ExcelExport.getInstance().export("materialWarehousingdetail-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/excelExportMaterialWarehousingdetailFromPage"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExportMaterialWarehousingFromPage(@RequestBody List<MaterialWarehousingdetailVO> list, HttpServletResponse response) {
        HashMap<String, List<MaterialWarehousingdetailVO>> beans = new HashMap<String, List<MaterialWarehousingdetailVO>>();
        beans.put("records", list);
        ExcelExport.getInstance().export("materialWarehousingdetail-export.xlsx", beans, response);
    }
}

