/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.outputValue.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.utils.CommonUtils;
import com.ejianc.business.outputValue.bean.ProjectMonthActualOutputValueEntity;
import com.ejianc.business.outputValue.bean.ProjectPcYearBusinessQuotaEntity;
import com.ejianc.business.outputValue.mapper.ProjectMonthActualOutputValueMapper;
import com.ejianc.business.outputValue.service.IProjectMonthActualOutputValueService;
import com.ejianc.business.outputValue.service.IProjectPcYearBusinessQuotaService;
import com.ejianc.business.outputValue.utils.OutputValueUtils;
import com.ejianc.business.outputValue.vo.ProjectMonthActualOutputValueVO;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="projectMonthActualOutputValueService")
public class ProjectMonthActualOutputValueServiceImpl
extends BaseServiceImpl<ProjectMonthActualOutputValueMapper, ProjectMonthActualOutputValueEntity>
implements IProjectMonthActualOutputValueService {
    @Autowired
    private ProjectMonthActualOutputValueMapper projectMonthActualOutputValueMapper;
    @Autowired
    private IProjectPcYearBusinessQuotaService projectPcYearBusinessQuotaService;

    @Override
    public ProjectMonthActualOutputValueVO queryOtherInfoByProjectId(Long projectId, String year, String month, Long id) {
        ProjectMonthActualOutputValueVO projectData;
        ProjectMonthActualOutputValueVO vo = new ProjectMonthActualOutputValueVO();
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("projectId", projectId);
        param.put("year", year);
        param.put("months", OutputValueUtils.getMonths(month));
        if (id != null) {
            param.put("neId", id);
        }
        if ((projectData = this.projectMonthActualOutputValueMapper.selectSumData(param)) != null) {
            vo.setLastAllMonthActualOutputValue(projectData.getThisMonthActualOutputValue());
            vo.setLastAllMonthConfirmedOutputValue(projectData.getThisMonthConfirmedOutputValue());
        } else {
            vo.setLastAllMonthActualOutputValue(new BigDecimal(0));
            vo.setLastAllMonthConfirmedOutputValue(new BigDecimal(0));
        }
        String reportingMonth = OutputValueUtils.getReportingMonth(year, month);
        BigDecimal thisMonthCommerceActualCompletedOutputValue = this.projectMonthActualOutputValueMapper.getAnalysisBusinessData(projectId, reportingMonth);
        if (thisMonthCommerceActualCompletedOutputValue != null) {
            vo.setThisMonthCommerceActualCompletedOutputValue(CommonUtils.parseDivide4(thisMonthCommerceActualCompletedOutputValue, 4));
        } else {
            vo.setThisMonthCommerceActualCompletedOutputValue(new BigDecimal(0));
        }
        QueryWrapper projectPcWarpper = new QueryWrapper();
        projectPcWarpper.eq((Object)"project_id", (Object)projectId);
        projectPcWarpper.eq((Object)"year", (Object)year);
        ProjectPcYearBusinessQuotaEntity projectPcYearBusinessQuotaEntity = (ProjectPcYearBusinessQuotaEntity)((Object)this.projectPcYearBusinessQuotaService.getOne((Wrapper)projectPcWarpper));
        if (projectPcYearBusinessQuotaEntity != null) {
            vo.setYearTargetOutputValue(projectPcYearBusinessQuotaEntity.getYearPlanOutputValue());
            BigDecimal yearTargetOutputValueMargin = OutputValueUtils.getMarginValue(projectPcYearBusinessQuotaEntity, month);
            if (yearTargetOutputValueMargin != null) {
                vo.setYearTargetOutputValueMargin(yearTargetOutputValueMargin);
            } else {
                vo.setYearTargetOutputValueMargin(new BigDecimal(0));
            }
        } else {
            vo.setYearTargetOutputValue(new BigDecimal(0));
            vo.setYearTargetOutputValueMargin(new BigDecimal(0));
        }
        return vo;
    }
}

