/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jxls.parser;

import java.util.ArrayList;
import java.util.List;
import net.sf.jxls.formula.Formula;
import net.sf.jxls.parser.Property;
import net.sf.jxls.tag.Tag;
import net.sf.jxls.transformer.Row;
import net.sf.jxls.transformer.RowCollection;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;

public class Cell {
    private Row row;
    private Property collectionProperty;
    private org.apache.poi.ss.usermodel.Cell hssfCell;
    private Formula formula;
    private String label;
    private int dependentRowNumber;
    private String collectionName;
    private String hssfCellValue;
    private boolean empty;
    private String stringCellValue;
    private String metaInfo;
    private CellRangeAddress mergedRegion;
    private List expressions = new ArrayList();
    private Tag tag;
    private RowCollection rowCollection;

    public Cell(org.apache.poi.ss.usermodel.Cell hssfCell, Row row) {
        this.setPoiCell(hssfCell);
        this.setRow(row);
    }

    public Tag getTag() {
        return this.tag;
    }

    public void setTag(Tag tag) {
        this.tag = tag;
    }

    public List getExpressions() {
        return this.expressions;
    }

    public void setExpressions(List expressions) {
        this.expressions = expressions;
    }

    public CellRangeAddress getMergedRegion() {
        return this.mergedRegion;
    }

    public int getDependentRowNumber() {
        return this.dependentRowNumber;
    }

    public RowCollection getRowCollection() {
        return this.rowCollection;
    }

    public void setRowCollection(RowCollection rowCollection) {
        this.rowCollection = rowCollection;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public Formula getFormula() {
        return this.formula;
    }

    public void setFormula(Formula formula) {
        this.formula = formula;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public Property getCollectionProperty() {
        return this.collectionProperty;
    }

    public void setCollectionProperty(Property collectionProperty) {
        this.collectionProperty = collectionProperty;
    }

    public org.apache.poi.ss.usermodel.Cell getPoiCell() {
        return this.hssfCell;
    }

    public void setPoiCell(org.apache.poi.ss.usermodel.Cell hssfCell) {
        this.hssfCell = hssfCell;
        this.figureEmpty();
    }

    public void replaceCellWithNewShiftedBy(int shift) {
        org.apache.poi.ss.usermodel.Cell newCell;
        this.hssfCell = newCell = this.row.getPoiRow().getCell(this.hssfCell.getColumnIndex() + shift);
        this.figureEmpty();
    }

    public String toCellName() {
        CellReference cellRef = new CellReference(this.getRow().getPoiRow().getRowNum(), this.getPoiCell().getColumnIndex(), false, false);
        return cellRef.formatAsString();
    }

    public Row getRow() {
        return this.row;
    }

    public void setRow(Row row) {
        this.row = row;
    }

    public boolean isFormula() {
        return this.getFormula() != null;
    }

    public String getPoiCellValue() {
        return this.hssfCellValue;
    }

    public String getStringCellValue() {
        return this.stringCellValue;
    }

    public String getMetaInfo() {
        return this.metaInfo;
    }

    private void figureEmpty() {
        this.empty = this.getPoiCellValue() == null || this.getPoiCellValue().length() == 0 || this.getPoiCell().getCellType() == CellType.BLANK;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public boolean isNull() {
        return this.getPoiCell() == null;
    }

    public String toString() {
        return this.getPoiCellValue();
    }

    public void setDependentRowNumber(int dependentRowNumber) {
        this.dependentRowNumber = dependentRowNumber;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public void setPoiCellValue(String hssfCellValue) {
        this.hssfCellValue = hssfCellValue;
        this.figureEmpty();
    }

    public void setStringCellValue(String stringCellValue) {
        this.stringCellValue = stringCellValue;
    }

    public void setMetaInfo(String metaInfo) {
        this.metaInfo = metaInfo;
    }

    public void setMergedRegion(CellRangeAddress mergedRegion) {
        this.mergedRegion = mergedRegion;
    }
}

