package com.ejianc.business.material.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.material.bean.*;
import com.ejianc.business.material.service.*;
import com.ejianc.business.material.utils.DateUtils;
import com.ejianc.business.material.vo.*;
import com.ejianc.foundation.material.vo.MaterialapproachdetailVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.outcontract.vo.OutcontractMaterialVO;
import com.ejianc.foundation.outcontract.vo.OutcontractVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import com.ejianc.wzxt.plan.api.IPlanApi;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 物资验收入库单
 *
 * @author generator
 */
@Controller
@RequestMapping("materialWarehousing")
public class MaterialWarehousingController implements Serializable {
    private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;
    @Qualifier("com.ejianc.foundation.outcontract.api.IOutcontractApi")
    @Autowired
    private com.ejianc.foundation.outcontract.api.IOutcontractApi outcontractApi ;

    @Autowired
    private IDeliveryrecorddetailService deliveryrecorddetailService;


    @Autowired
    private IDeliveryrecordService deliveryrecordService;


    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private IMaterialWarehousingdetailService detailService;

    private static final String BILL_CODE = "WZ_YS";//此处需要根据实际修改

    @Autowired
    private IMaterialWarehousingService service;

    @Autowired
    private IMaterialapproachdetailService materialapproachdetailService;

    @Autowired
    private IFlowmeterService flowmeterService;

    @Autowired
    private IRealtimebalanceService realtimebalanceService;
    @Autowired
    private IMaterialapproachService materialapproachService;

    @Autowired
    private IPlanApi planApi;

    


    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MaterialWarehousingVO> saveOrUpdate(@RequestBody MaterialWarehousingVO saveorUpdateVO) {
        return CommonResponse.success("保存或修改单据成功！", service.saveOrUpdate(saveorUpdateVO));
    }

    /**
     * @param id
     * @Description queryDetail 查询详情
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MaterialWarehousingVO> queryDetail(Long id) {
        MaterialWarehousingEntity entity = service.selectById(id);
        MaterialWarehousingVO vo = BeanMapper.map(entity, MaterialWarehousingVO.class);
        return CommonResponse.success("查询详情数据成功！", vo);
    }
    /**
     * @param id
     * @Description queryDetail 更新实时物资结存接口
     */
    @RequestMapping(value = "/updateRealtimeBalance", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MaterialWarehousingVO> updateRealtimeBalance(Long storeId) {
        realtimebalanceService.updateRealtimeBalance(storeId);
        return CommonResponse.success("更新实时物资结存成功！");
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MaterialWarehousingVO> vos) {
//        for (int i = 0; i < vos.size(); i++) {
//            MaterialWarehousingVO vo = vos.get(i);
//            Long id = vo.getId();
//            //物资入库单
//            MaterialWarehousingEntity materialWarehousingEntity = service.selectById(id);
//            if(materialWarehousingEntity.getWarehousingType() == 0){
//                //物资（周转）进场验证记录id
//                Long materialapproachId = materialWarehousingEntity.getMaterialapproachId();
//                MaterialapproachEntity materialapproachEntity = materialapproachService.selectById(materialapproachId);
//                BigDecimal notStorageNumTotal = materialapproachEntity.getNotStorageNum();
//                //物资入库单子表
//                List<MaterialWarehousingdetailEntity> materialWarehousingdetailEntities = materialWarehousingEntity.getMaterialWarehousingdetailEntities();
//                if (materialWarehousingdetailEntities != null && materialWarehousingdetailEntities.size() > 0) {
//                    MaterialWarehousingdetailEntity materialWarehousingdetailEntity = materialWarehousingdetailEntities.get(0);
//                    //获取物资编码
//                    String materialCode = materialWarehousingdetailEntity.getMaterialCode();
//                    //入库数量
//                    BigDecimal quantity = materialWarehousingdetailEntity.getQuantity();
//                    QueryWrapper<MaterialapproachdetailEntity> queryWrapper = new QueryWrapper();
//                    queryWrapper.eq("mid", materialapproachId);
//                    queryWrapper.eq("material_code", materialCode);
//                    queryWrapper.eq("dr", 0);
//                    List<MaterialapproachdetailEntity> materialapproachdetailList = materialapproachdetailService.list(queryWrapper);
//                    if (materialapproachdetailList != null && materialapproachdetailList.size() > 0) {
//                        //进场单子表
//                        MaterialapproachdetailEntity materialapproachdetailEntity = materialapproachdetailList.get(0);
//                        BigDecimal notStorageNum = materialapproachdetailEntity.getNotStorageNum();//进场单-未入库数量
//                        if (quantity != null && notStorageNum != null) {
//                            notStorageNum = notStorageNum.add(quantity);
//                            materialapproachdetailEntity.setNotStorageNum(notStorageNum);
//                            notStorageNumTotal = notStorageNumTotal.add(quantity);
//                            materialapproachEntity.setNotStorageNum(notStorageNumTotal);
//                            materialapproachdetailService.saveOrUpdate(materialapproachdetailEntity);//更新进场单子表-未入库数量
//                        }
//                    }
//                }
//                materialapproachService.saveOrUpdate(materialapproachEntity); // 更新进场验收单主表-未入库数量
//            }
//        }

        //删除流水
        //先删后增
        List<Long> ids = vos.stream().map(MaterialWarehousingVO::getId).collect(Collectors.toList());
        LambdaQueryWrapper<MaterialWarehousingEntity> lambdaDelivery = Wrappers.<MaterialWarehousingEntity>lambdaQuery();
        lambdaDelivery.in(MaterialWarehousingEntity::getId,ids);
        List<MaterialWarehousingEntity> deliveryrecordEntities = service.list(lambdaDelivery);

        LambdaQueryWrapper<FlowmeterEntity> lambdaFlower = Wrappers.<FlowmeterEntity>lambdaQuery();
        lambdaFlower.in(FlowmeterEntity::getMid,ids);
        flowmeterService.remove(lambdaFlower);
        //刷新实时库存
        for (MaterialWarehousingEntity materialWarehousingEntity : deliveryrecordEntities){
                realtimebalanceService.updateRealtimeBalance(materialWarehousingEntity.getStoreId());
        }

//        if(entity.getWarehousingType() == 0){
//            MaterialapproachEntity materialapproachEntity = materialapproachService.selectById(entity.getMaterialapproachId());
//            materialapproachEntity.setUseFlag(0);
//            materialapproachService.updateById(materialapproachEntity);
//        }

        List<Long> wareIds = vos.stream().map(MaterialWarehousingVO::getId).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(wareIds)){
            LambdaQueryWrapper<MaterialWarehousingEntity> lambda = Wrappers.<MaterialWarehousingEntity>lambdaQuery();
            lambda.in(MaterialWarehousingEntity::getId, wareIds);
            List<MaterialWarehousingEntity> materialWarehousingEntities = service.list(lambda);
            List<Long> materialapproachIds = materialWarehousingEntities.stream().filter(s->s.getWarehousingType() == 0).map(MaterialWarehousingEntity::getMaterialapproachId).distinct().collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(materialapproachIds)){
                LambdaQueryWrapper<MaterialWarehousingEntity> lambdaware = Wrappers.<MaterialWarehousingEntity>lambdaQuery();
                lambdaware.notIn(MaterialWarehousingEntity::getId, wareIds);
                lambdaware.in(MaterialWarehousingEntity::getMaterialapproachId, materialapproachIds);
                List<MaterialWarehousingEntity> materialWarehousingList = service.list(lambdaware);
                if (CollectionUtils.isNotEmpty(materialWarehousingList)){
                    List<Long> materialapproachAllIds = materialWarehousingList.stream().filter(s->s.getWarehousingType() == 0).map(MaterialWarehousingEntity::getMaterialapproachId).distinct().collect(Collectors.toList());
                    List<Long> updateIds = materialapproachIds.stream().filter(s -> !materialapproachAllIds.contains(s)).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(updateIds)){
                        LambdaQueryWrapper<MaterialapproachEntity> lambdaappach = Wrappers.<MaterialapproachEntity>lambdaQuery();
                        lambdaappach.in(MaterialapproachEntity::getId, updateIds);
                        List<MaterialapproachEntity> list = materialapproachService.list(lambdaappach);
                        list.stream().forEach(s -> {
                            s.setUseFlag(0);
                        });
                        if(CollectionUtils.isNotEmpty(list)){
                            materialapproachService.updateBatchById(list);
                        }
                    }

                }else {
                    LambdaQueryWrapper<MaterialapproachEntity> lambdaappach = Wrappers.<MaterialapproachEntity>lambdaQuery();
                    lambdaappach.in(MaterialapproachEntity::getId, materialapproachIds);
                    List<MaterialapproachEntity> list = materialapproachService.list(lambdaappach);
                    list.stream().forEach(s -> {
                        s.setUseFlag(0);
                    });
                    if(CollectionUtils.isNotEmpty(list)){
                        materialapproachService.updateBatchById(list);
                    }
                }

            }
        }


        service.removeByIds(vos.stream().map(MaterialWarehousingVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @param param
     * @Description queryList 查询列表
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MaterialWarehousingVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("subContract");
        fuzzyFields.add("acceptanceType");
        fuzzyFields.add("supplierName");

        UserContext userContextCache = sessionManager.getUserContext();


        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });

        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        IPage<MaterialWarehousingEntity> page = service.queryPage(param, false);
        IPage<MaterialWarehousingVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialWarehousingVO.class));

        return CommonResponse.success("查询列表数据成功！", pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @param param
     * @Description 导出
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);

        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        List<MaterialWarehousingEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<MaterialWarehousingVO> warehousingVOS = BeanMapper.mapList(list, MaterialWarehousingVO.class);
        for (int i = 0; i < warehousingVOS.size(); i++) {
            MaterialWarehousingVO materialWarehousingVO = warehousingVOS.get(i);
            materialWarehousingVO.setNum(String.valueOf(i + 1));
            if (materialWarehousingVO.getCreateTime() != null) {
                materialWarehousingVO.setCreateTimeShow(DateUtils.dateSimple2(materialWarehousingVO.getCreateTime()));
            }
//            if (procurementplanVO.getDealDate() != null) {
//                procurementplanVO.setResultDateShow(DateUtils.dateSimple2(SurplusmaterialrecordVO.getDealDate()));
//            }
            String billStateStr = materialWarehousingVO.getBillState().toString();
            if (billStateStr != null) {
                if ("0".equals(billStateStr)) {//自由态
                    billStateStr = "自由态";
                } else if ("1".equals(billStateStr)) {//已提交
                    billStateStr = "已提交";
                } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {//审批中
                    billStateStr = "审批中";
                } else if ("3".equals(billStateStr)) {//审批通过
                    billStateStr = "审批通过";
                } else if ("4".equals(billStateStr)) {//驳回
                    billStateStr = "驳回";
                }

                materialWarehousingVO.setBillStateStr(billStateStr);
            }
            if(materialWarehousingVO.getWarehousingType() == 0){
                materialWarehousingVO.setWarehousingTypeName("入库");
            }
            if(materialWarehousingVO.getWarehousingType() == 1){
                materialWarehousingVO.setWarehousingTypeName("退供应商");
            }
        }
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", warehousingVOS);
        ExcelExport.getInstance().export("MaterialWarehousing-export.xlsx", beans, response);
    }

    /**
     * @param
     * @Description 参照
     * @Return void
     */
    @RequestMapping(value = "/refMaterialWarehousingData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MaterialWarehousingVO>> refMaterialWarehousingData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                                   String condition,
                                                                                   String searchObject,
                                                                                   String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty(condition)) {
            /** 处理condition */
            List<Integer> billState = new ArrayList<>();
            billState.add(1);
            billState.add(3);
            List<String> acceptanceType = new ArrayList<>();
            acceptanceType.add("直入直出");
            acceptanceType.add("验收入库");

            JSONObject _con = JSONObject.parseObject(condition);
            if(_con.get("status") != null && _con.get("status").equals("0")){//直入直出
                param.getParams().put("acceptanceType", new Parameter(QueryParam.EQ, "直入直出"));
                param.getParams().put("notReturnedQuantity", new Parameter(QueryParam.GT, BigDecimal.ZERO));
                param.getParams().put("billState", new Parameter(QueryParam.IN, billState));
            }
            if(_con.get("status") != null && _con.get("status").equals("1")){//入库
                param.getParams().put("warehousingType", new Parameter(QueryParam.EQ, 0));
                param.getParams().put("acceptanceType", new Parameter(QueryParam.IN, acceptanceType));
                param.getParams().put("notReturnedQuantity", new Parameter(QueryParam.GT, BigDecimal.ZERO));
                param.getParams().put("billState", new Parameter(QueryParam.IN, billState));
            }
            if(_con.get("useStatus") != null && _con.get("useStatus").equals("0")){//入库
                param.getParams().put("useStatus", new Parameter(QueryParam.EQ, 0));
            }
            if(_con.get("contractId") != null ) {//入库
                param.getParams().put("contractId", new Parameter(QueryParam.EQ,_con.get("contractId")));
            }
            if(_con.get("projectId") != null){
                param.getParams().put("projectId", new Parameter(QueryParam.EQ,_con.get("projectId")));
            }
            if(_con.get("orgId") != null){
                UserContext userContextCache =sessionManager.getUserContext();
                //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
                String authOrgIds = userContextCache.getAuthOrgIds();
                List<OrgVO> orgVOList = null;
                if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
                    orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
                }else {//pc端查询
                    orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(Long.parseLong( _con.get("orgId").toString())), true, "查询失败，获取当前本下组织信息失败。");
                }
                //普通组织 id
                List<Long> commonOrgIds = new ArrayList<>();
                //项目部 id
                List<Long> departmentIds = new ArrayList<>();
                orgVOList.stream().forEach(org -> {
                    if(5 == org.getOrgType()) {
                        //项目部
                        departmentIds.add(org.getId());
                    } else {
                        //普通组织
                        commonOrgIds.add(org.getId());
                    }
                });
                if(CollectionUtils.isNotEmpty(commonOrgIds)) {
                    /** 要求主表有orgId字段，保存单据所属组织 */
                    param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
                } else if(CollectionUtils.isNotEmpty(departmentIds)) {
                    /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
                    param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
                }
            }
        }
        IPage<MaterialWarehousingEntity> page = service.queryPage(param, false);
        IPage<MaterialWarehousingVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MaterialWarehousingVO.class));

        return CommonResponse.success("查询参照数据成功！", pageData);
    }

/*    @RequestMapping(value = "/queryProject", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> queryProject(Long id, Long projectId) {
        QueryWrapper<MaterialWarehousingEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.eq("project_id", projectId);
        if (id != null && id != 0) {
            queryWrapper.ne("id", id);
        }
        List<MaterialWarehousingEntity> entityList = service.list(queryWrapper);
        if (entityList != null && entityList.size() > 0) {
            return CommonResponse.error("该项目下已经存在，不允许新增");

        }
        return CommonResponse.success("查询成功", "0");
    }*/

    @RequestMapping(value = "/queryContract", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<String> queryContract(Long id, Long contractId) {
        QueryWrapper<MaterialWarehousingEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.eq("contract_id", contractId);
        if (id != null && id != 0) {
            queryWrapper.ne("id", id);
        }
        List<MaterialWarehousingEntity> entityList = service.list(queryWrapper);
        if (entityList != null && entityList.size() > 0) {
            return CommonResponse.error("该项目下已经存在合同，不允许新增");


        }
        return CommonResponse.success("查询成功", "0");
    }
    @RequestMapping(value = "getMaterialPLanById", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<DeliveryrecorddetailVO>> getMaterialPLanById(@RequestParam(value = "projectId") Long projectId,@RequestParam(value = "subContractId") Long subContractId) {

        //赋值计划数量
        Map<Long, BigDecimal> pLanByProjectIdMap = new HashMap<>();
        Map<Long, BigDecimal> numMap = new HashMap<>();
        List<DeliveryrecorddetailVO> list = new ArrayList<>();
            //获取计划量
            CommonResponse<Map<Long, BigDecimal>> materialPLanByProjectId = planApi.getMaterialPLanByProjectId(projectId, subContractId);
            if (!materialPLanByProjectId.isSuccess()){
                throw new BusinessException("获取计划信息失败");
            }
            pLanByProjectIdMap = materialPLanByProjectId.getData();

            //获取项目下供应商下出库数量
            LambdaQueryWrapper<DeliveryrecordEntity> lambdaQueryWrapper = Wrappers.<DeliveryrecordEntity>lambdaQuery();
            lambdaQueryWrapper.eq(DeliveryrecordEntity::getProjectId, projectId);
            lambdaQueryWrapper.eq(DeliveryrecordEntity::getPickingunitId, subContractId);
            lambdaQueryWrapper.eq(DeliveryrecordEntity::getSelfState,"否");
            lambdaQueryWrapper.in(DeliveryrecordEntity::getBillState, 1,3);
            List<DeliveryrecordEntity> deliveryrecordEntities = deliveryrecordService.list(lambdaQueryWrapper);

            if (CollectionUtils.isNotEmpty(deliveryrecordEntities)) {
                List<Long> ids = deliveryrecordEntities.stream().map(DeliveryrecordEntity::getId).collect(Collectors.toList());
                LambdaQueryWrapper<DeliveryrecorddetailEntity> lambdaQuery = Wrappers.<DeliveryrecorddetailEntity>lambdaQuery();
                lambdaQuery.in(DeliveryrecorddetailEntity::getMid, ids);
                List<DeliveryrecorddetailEntity> deliveryrecorddetailEntities = deliveryrecorddetailService.list(lambdaQuery);
                if(CollectionUtils.isNotEmpty(deliveryrecorddetailEntities)){
                    numMap = deliveryrecorddetailEntities.stream().collect(Collectors.groupingBy(DeliveryrecorddetailEntity::getMaterialId,
                            Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getDeliveryQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
                }
            }

        if (!pLanByProjectIdMap.isEmpty()){
            Map<Long, BigDecimal> finalNumMap = numMap;
            pLanByProjectIdMap.forEach((key, value) -> {
                DeliveryrecorddetailVO deliveryrecorddetailVO = new DeliveryrecorddetailVO();
                deliveryrecorddetailVO.setMaterialId(key);
                deliveryrecorddetailVO.setPlanNum(value);
                if (finalNumMap.containsKey(key)){
                    BigDecimal outNum = finalNumMap.get(key);
                    deliveryrecorddetailVO.setPlanSurplusNum(ComputeUtil.safeSub(deliveryrecorddetailVO.getPlanNum(),outNum));
                }else {
                    deliveryrecorddetailVO.setPlanSurplusNum(deliveryrecorddetailVO.getPlanNum());
                }
                list.add(deliveryrecorddetailVO);
            });
        }

        return CommonResponse.success("查询成功！",list);
    }


    /**
     * @param materialapproachId
     * @Description queryDetail 查询物资（周转）进场验证记录
     */
    @RequestMapping(value = "/queryMaterialapproach", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<MaterialapproachdetailVO>> queryMaterialapproach(Long id, Long materialapproachId, Long contractId) {
        logger.info("111111111materialapproachEntity.getProjectId()");
        MaterialapproachEntity materialapproachEntity = materialapproachService.selectById(materialapproachId);

        QueryWrapper<MaterialapproachdetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid", materialapproachId);
//        queryWrapper.gt("not_storage_num", new BigDecimal(0.00));
        List<MaterialapproachdetailEntity> materialapproachdetailEntityList = materialapproachdetailService.list(queryWrapper);
        List<MaterialapproachdetailEntity> materialapproachdetailEntities = new ArrayList<>();
        //查询所有验收数量
        if (CollectionUtils.isNotEmpty(materialapproachdetailEntityList)){
            List<Long> approachIds = materialapproachdetailEntityList.stream().map(MaterialapproachdetailEntity::getId).collect(Collectors.toList());

            //查询所有下游引用的数据,获取进场验收数量
            LambdaQueryWrapper<MaterialWarehousingdetailEntity> houseDetailScheme = Wrappers.<MaterialWarehousingdetailEntity>lambdaQuery();
            houseDetailScheme.in(MaterialWarehousingdetailEntity::getApproachDetailId, approachIds);
            if (id != null){
                houseDetailScheme.ne(MaterialWarehousingdetailEntity::getMid,id);
            }
            List<MaterialWarehousingdetailEntity> materialWarehousingdetailEntities = detailService.list(houseDetailScheme);
            if (CollectionUtils.isNotEmpty(materialWarehousingdetailEntities)){
                // 分组后汇总
                Map<Long, BigDecimal> checkMap = materialWarehousingdetailEntities.stream().filter(s->s.getQuantity().compareTo(BigDecimal.ZERO) == 1).collect(Collectors.groupingBy(MaterialWarehousingdetailEntity::getApproachDetailId,
                        Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
                for (MaterialapproachdetailEntity materialapproachdetailEntity : materialapproachdetailEntityList){
                    if(checkMap.containsKey(materialapproachdetailEntity.getId())){
                        BigDecimal checkNum = checkMap.get(materialapproachdetailEntity.getId());
                        materialapproachdetailEntity.setNotStorageNum(materialapproachdetailEntity.getVerificationCount().subtract(checkNum));
                    }else{
                        materialapproachdetailEntity.setNotStorageNum(materialapproachdetailEntity.getVerificationCount());
                    }
                }
            }
            materialapproachdetailEntities = materialapproachdetailEntityList.stream().filter(it -> it.getNotStorageNum().compareTo(BigDecimal.ZERO) == 1).collect(Collectors.toList());
        }


        List<MaterialapproachdetailVO> vo = BeanMapper.mapList(materialapproachdetailEntities, MaterialapproachdetailVO.class);

        //赋值计划数量
        Map<Long, BigDecimal> pLanByProjectIdMap = new HashMap<>();
        Map<Long, BigDecimal> numMap = new HashMap<>();
        if (materialapproachEntity.getSubcontractorId() != null) {
            //获取计划量
            logger.info("materialapproachEntity.getProjectId():"+materialapproachEntity.getProjectId()+"----"+ materialapproachEntity.getSubcontractorId());
            CommonResponse<Map<Long, BigDecimal>> materialPLanByProjectId = planApi.getMaterialPLanByProjectId(materialapproachEntity.getProjectId(), materialapproachEntity.getSubcontractorId());
            if (!materialPLanByProjectId.isSuccess()){
                throw new BusinessException("获取计划信息失败");
            }
            logger.info("pLanByProjectIdMap"+JSONObject.toJSONString(materialPLanByProjectId));
            pLanByProjectIdMap = materialPLanByProjectId.getData();
            logger.info("pLanByProjectIdMap"+JSONObject.toJSONString(pLanByProjectIdMap));

            //获取项目下供应商下出库数量
            LambdaQueryWrapper<DeliveryrecordEntity> lambdaQueryWrapper = Wrappers.<DeliveryrecordEntity>lambdaQuery();
            lambdaQueryWrapper.eq(DeliveryrecordEntity::getProjectId, materialapproachEntity.getProjectId());
            lambdaQueryWrapper.eq(DeliveryrecordEntity::getPickingunitId, materialapproachEntity.getSubcontractorId());
            lambdaQueryWrapper.eq(DeliveryrecordEntity::getSelfState,"否");
            lambdaQueryWrapper.in(DeliveryrecordEntity::getBillState, 1,3);
            List<DeliveryrecordEntity> deliveryrecordEntities = deliveryrecordService.list(lambdaQueryWrapper);

            if (CollectionUtils.isNotEmpty(deliveryrecordEntities)) {
                List<Long> ids = deliveryrecordEntities.stream().map(DeliveryrecordEntity::getId).collect(Collectors.toList());
                LambdaQueryWrapper<DeliveryrecorddetailEntity> lambdaQuery = Wrappers.<DeliveryrecorddetailEntity>lambdaQuery();
                lambdaQuery.in(DeliveryrecorddetailEntity::getMid, ids);
                List<DeliveryrecorddetailEntity> deliveryrecorddetailEntities = deliveryrecorddetailService.list(lambdaQuery);
                if(CollectionUtils.isNotEmpty(deliveryrecorddetailEntities)){
                    numMap = deliveryrecorddetailEntities.stream().collect(Collectors.groupingBy(DeliveryrecorddetailEntity::getMaterialId,
                            Collectors.collectingAndThen(Collectors.toList(), m -> m.stream().map(a -> a.getDeliveryQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add))));
                }
            }
        }
        //
        if (CollectionUtils.isNotEmpty(vo)){
            //设置计划数量
            for (MaterialapproachdetailVO materialapproachdetailVO : vo){
                materialapproachdetailVO.setPlanNum(BigDecimal.ZERO);
                materialapproachdetailVO.setPlanSurplusNum(BigDecimal.ZERO);
                if (pLanByProjectIdMap.containsKey(materialapproachdetailVO.getMaterialId())){
                    logger.info("1111111111");
                    BigDecimal planNum = pLanByProjectIdMap.get(materialapproachdetailVO.getMaterialId());
                    materialapproachdetailVO.setPlanNum(planNum);
                    if (numMap.containsKey(materialapproachdetailVO.getMaterialId())){
                        BigDecimal outNum = numMap.get(materialapproachdetailVO.getMaterialId());
                        materialapproachdetailVO.setPlanSurplusNum(ComputeUtil.safeSub(materialapproachdetailVO.getPlanNum(),outNum));
                    }else {
                        materialapproachdetailVO.setPlanSurplusNum(materialapproachdetailVO.getPlanNum());
                    }
                }
            }
        }

        if(contractId != null){
            CommonResponse<OutcontractVO> outcontractVOCommonResponse = outcontractApi.queryDetail(contractId);
            logger.info("接口返回数据=" + outcontractVOCommonResponse.getMsg() + "状态="+ outcontractVOCommonResponse.getCode());
            if(outcontractVOCommonResponse.getCode() == 0 && outcontractVOCommonResponse.getData().getOutcontractMaterialList().size() > 0){
                for(MaterialapproachdetailVO entity : vo){
                    for(OutcontractMaterialVO list : outcontractVOCommonResponse.getData().getOutcontractMaterialList()){
                        if(entity.getName().equals(list.getMaterialName()) && entity.getMaterialCode().equals(list.getMaterialCode()) && entity.getMaterialClassCode().equals(list.getMaterialCategoryCode())){
                            entity.setUnitPriceIncluetax(list.getTaxUnitPrice());//含税单价
                            entity.setTaxRate(list.getTaxRate()); //税率
                            if(entity.getUnitPriceIncluetax() != null){
                                entity.setAmountIncluetax(entity.getNotStorageNum().multiply(entity.getUnitPriceIncluetax()));//含税金额
                            }
                            if(entity.getUnitPriceIncluetax() != null && entity.getTaxRate() != null){
                                entity.setUnitPriceEncluetax(entity.getUnitPriceIncluetax().multiply(entity.getTaxRate().divide(new BigDecimal(100),8,BigDecimal.ROUND_HALF_UP)));//不含说单价
                                entity.setAmountEncluetax(entity.getNotStorageNum().multiply(entity.getUnitPriceEncluetax()));//不含税金额
                            }
//                        MaterialapproachdetailVO materialapproachdetailVO =  BeanMapper.map(entity,MaterialapproachdetailVO.class);
//                        materialapproachdetailVO.setUnitPriceIncluetax(list.getTaxUnitPrice());
//                        if(materialapproachdetailVO.getUnitPriceIncluetax() != null){
//                            materialapproachdetailVO.setAmountIncluetax(entity.getNotStorageNum().multiply(materialapproachdetailVO.getUnitPriceIncluetax()));
//                        }
//                        vo.remove(entity);
//                        vo.add(materialapproachdetailVO);
                            continue;
                        }
                    }
                }
            }
        }

        return CommonResponse.success("查询详情数据成功！", vo);
    }

    @RequestMapping(value = "/queryReport", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<MaterialWarehousingReportVO>> queryReport(String supplierName, Long projectId, String materialCode) {
        List<MaterialWarehousingReportVO> resList = new ArrayList<>();
        QueryWrapper<MaterialWarehousingdetailEntity> detailQueryWrapper = new QueryWrapper<>();
        detailQueryWrapper.eq("dr", 0);
        if(supplierName != null){
            detailQueryWrapper.eq("supplier_name", supplierName);
        }
        detailQueryWrapper.eq("project_id", projectId);
        detailQueryWrapper.eq("material_code", materialCode);
        List<MaterialWarehousingdetailEntity> detailEntityList = detailService.list(detailQueryWrapper);

        for (MaterialWarehousingdetailEntity item :
                detailEntityList) {
            String supName = item.getSupplierName(); // 供应商名称
            String projectName = item.getProjectName();//项目名称
            String name = item.getMaterialName();//料具名称
            BigDecimal enterCount = item.getQuantity();//累计数量
            BigDecimal money = item.getAmountIncluetax(); //累计金额
            MaterialWarehousingReportVO reportVO = new MaterialWarehousingReportVO();
            reportVO.setId(IdWorker.getId());
            reportVO.setProjectId(projectId);
            reportVO.setProjectName(projectName);
            reportVO.setMaterialName(name);
            reportVO.setMaterialCode(materialCode);
            reportVO.setSupplierName(supName);
            reportVO.setSpecialModel(item.getSpecialModel());
            reportVO.setAmountIncluetax(money);
            reportVO.setQuantity(enterCount);

            Long mid = item.getMid();
            QueryWrapper<MaterialWarehousingEntity> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("dr", 0);
            queryWrapper.eq("id", mid);
            List<MaterialWarehousingEntity> mList = service.list(queryWrapper);
            Integer billState = 0;
            if (mList != null && mList.size() > 0) {
                MaterialWarehousingEntity entity = mList.get(0);
                String billCode = entity.getBillCode();
                reportVO.setBillCode(billCode);
                reportVO.setMaterialwarehousingId(mid);
                billState = entity.getBillState();
            }
            if(billState == 1 || billState ==3){
                resList.add(reportVO);
            }
        }

        return CommonResponse.success("查询成功", resList);
    }

    /**
     * @return 查询组织，报表根据组织过滤数据使用
     */
    @RequestMapping(value = "/queryOrg", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse queryOutStore() {
        UserContext userContextCache = sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if (StringUtils.isNotBlank(authOrgIds)) {//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        } else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        QueryParam param = new QueryParam();
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        return CommonResponse.success("查询成功", param);
    }

    /**
     * 根据入库单id查询入库单子表信息
     * @param warehousId 入库单id
     * @return
     */
    @RequestMapping(value = "/queryWarehousDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<MaterialWarehousingdetailVO>> queryWarehousDetail(Long warehousId) {
        QueryWrapper<MaterialWarehousingdetailEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("mid",warehousId);
        queryWrapper.gt("not_returned_quantity",BigDecimal.ZERO);
        List<MaterialWarehousingdetailEntity> list = detailService.list(queryWrapper);
        for(MaterialWarehousingdetailEntity entity : list){
            entity.setWarehouseingDetailId(entity.getId());
            entity.setId(IdWorker.getId());
            entity.setQuantity(entity.getQuantity().multiply(new BigDecimal(-1.00)));
            entity.setAmountIncluetax(entity.getAmountIncluetax().multiply(new BigDecimal(-1.00)));
            entity.setAmountExcluetax(entity.getAmountExcluetax().multiply(new BigDecimal(-1.00)));
        }
        List<MaterialWarehousingdetailVO> list1 = BeanMapper.mapList(list, MaterialWarehousingdetailVO.class);
        return  CommonResponse.success("查询成功",list1);
    }
}
