package com.ejianc.business.material.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.material.vo.*;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.wzxt.plan.vo.MonthPlanBooleanVO;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.SimpleDateFormat;
import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.material.bean.MonthProjectEntity;
import com.ejianc.business.material.service.IMonthProjectService;

/**
 * 物资消耗月度分析表-项目
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("monthProject")
public class MonthProjectController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "MONTH-PROJECT";//此处需要根据实际修改

    @Autowired
    private IMonthProjectService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<MonthProjectVO> saveOrUpdate(@RequestBody MonthProjectVO saveOrUpdateVO) {

        //一个月只能做一条数据
        QueryWrapper curQuery = new QueryWrapper();
        SimpleDateFormat sdf1 = new SimpleDateFormat("yyyy-MM");
        String month = sdf1.format(saveOrUpdateVO.getMonth());
        curQuery.eq("DATE_FORMAT(month, '%Y-%m' )",month);
        curQuery.eq("project_id",saveOrUpdateVO.getProjectId());
        if(saveOrUpdateVO.getId() != null){
            curQuery.ne("id",saveOrUpdateVO.getId());
        }
        int curCount = service.count(curQuery);
        if (curCount > 0) throw new BusinessException("一个项目每个月只能做一个单据。");

//        一个项目当前最多只能有一个非生效态单据。
        LambdaQueryWrapper<MonthProjectEntity> lambda = Wrappers.<MonthProjectEntity>lambdaQuery();
        lambda.eq(MonthProjectEntity::getProjectId, saveOrUpdateVO.getProjectId());
        lambda.notIn(MonthProjectEntity::getBillState, 1,3);
        lambda.ne(saveOrUpdateVO.getId() != null, MonthProjectEntity::getId, saveOrUpdateVO.getId());
        int curCount2 = service.count(lambda);
        if (curCount2 > 0) throw new BusinessException(" 一个项目当前最多只能有一个非生效态单据。");


    	MonthProjectEntity entity = BeanMapper.map(saveOrUpdateVO, MonthProjectEntity.class);
    	if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
    	service.saveOrUpdate(entity, false);
    	MonthProjectVO vo = BeanMapper.map(entity, MonthProjectVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }
    @ApiOperation("根据项目id校验数据是否能新增")
    @RequestMapping(value = "/queryDetailByProjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MonthBooleanVO> queryDetailByProjectId(@RequestParam(required = false) Long projectId, @RequestParam(required = false) Long id) {
        LambdaQueryWrapper<MonthProjectEntity> lambda = Wrappers.<MonthProjectEntity>lambdaQuery();
        lambda.eq(MonthProjectEntity::getProjectId,projectId);
        lambda.notIn(id != null,MonthProjectEntity::getId,id);
        lambda.orderByDesc(MonthProjectEntity::getId);
        List<MonthProjectEntity> monthPlanEntities = service.list(lambda);
        MonthBooleanVO booleanVO = new MonthBooleanVO();
        Boolean b = true;
        if (CollectionUtils.isNotEmpty(monthPlanEntities)){
            boolean match = monthPlanEntities.stream().anyMatch(s -> s.getBillState() == 0);
            if (match){
                b = false;
            }
        }
        booleanVO.setB(b);
        if (CollectionUtils.isNotEmpty(monthPlanEntities)){
            booleanVO.setDate(monthPlanEntities.stream().findFirst().get().getMonth());
        }


        return CommonResponse.success("查询详情数据成功！",booleanVO);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<MonthProjectVO> queryDetail(Long id) {
        MonthProjectEntity entity = service.selectById(id);
        MonthProjectVO vo = BeanMapper.map(entity, MonthProjectVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }
    /**
     * @Description queryDetail 根据二级组织查询子表详情
     */
    @RequestMapping(value = "/queryDetailByOrgId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<MonthOrgDetailVO>> queryDetailByOrgId(Long orgId, String month) {

        List<MonthOrgDetailVO> detailVOList = service.queryDetailByOrgId(orgId,month);
        return CommonResponse.success("查询详情数据成功！",detailVOList);
    }
    /**
     * @Description queryDetail 根据项目id和月份查询数据
     */
    @RequestMapping(value = "/queryDataById", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<MonthProjectDetailVO>> queryDataById(Long projectId,String month) {
        List<MonthProjectDetailVO> detailVOList = service.queryDataById(projectId,month);
        return CommonResponse.success("查询详情数据成功！",detailVOList);
    }
    /**
     * 企业大屏-主要物资投入情况
     */
    @RequestMapping(value = "/getInNumByOrgId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<BigScreenVO>> getInNumByOrgId() {
        List<BigScreenVO> detailVOList = service.getInNumByOrgId();
        return CommonResponse.success("查询详情数据成功！",detailVOList);
    }
    /**
     * 企业大屏-物资计划执行率展示
     * type 1-总计划 2- 月度计划
     */
    @RequestMapping(value = "/getPlanRateByOrgId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<BigScreenVO>> getPlanRateByOrgId(Integer type, String month) {
        List<BigScreenVO> detailVOList = service.getPlanRateByOrgId(type,month);
        return CommonResponse.success("查询详情数据成功！",detailVOList);
    }
    /**
     * 企业大屏-主材材料节超率分析(损耗率)
     * type
     */
    @RequestMapping(value = "/getDiffRateOrgId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<BigScreenVO>> getDiffRateOrgId(String month) {
        List<BigScreenVO> detailVOList = service.getDiffRateOrgId(month);
        return CommonResponse.success("查询详情数据成功！",detailVOList);
    }
    /**
     * 企业大屏-主材材料节超率分析(损耗率)
     * type
     */
    @RequestMapping(value = "/getDiffRateProjectId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<BigScreenVO>> getDiffRateProjectId(Long id) {
        List<BigScreenVO> detailVOList = service.getDiffRateProjectId(id);
        return CommonResponse.success("查询详情数据成功！",detailVOList);
    }
    /**
     * 企业大屏-废旧物资季度处置情况
     */
    @RequestMapping(value = "/getQuarterData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<BigScreenVO>> getQuarterData(String year) {
        List<BigScreenVO> detailVOList = service.getQuarterData(year);
        return CommonResponse.success("查询详情数据成功！",detailVOList);
    }
    /**
     * 企业大屏-分供方评价排名十佳榜
     * type 1-月度, 2-年度
     * yearType 1-上半年, 2-下半年
     *
     */
    @RequestMapping(value = "/getSupplierTopTen", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<BigScreenVO>> getSupplierTopTen(String month) {
        List<BigScreenVO> detailVOList = service.getSupplierTopTen(month);
        return CommonResponse.success("查询详情数据成功！",detailVOList);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<MonthProjectVO> vos) {

        service.removeByIds(vos.stream().map(MonthProjectVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<MonthProjectVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<MonthProjectEntity> page = service.queryPage(param,false);
        IPage<MonthProjectVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), MonthProjectVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<MonthProjectEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        List<MonthProjectVO> monthProjectVOList = BeanMapper.mapList(list, MonthProjectVO.class);
        monthProjectVOList.forEach(e -> {
            e.setBillStateName(BillStateEnum.getEnumByStateCode(e.getBillState()).getDescription());
        });
        beans.put("records", monthProjectVOList);
        ExcelExport.getInstance().export("MonthProject-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refMonthProjectData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<MonthProjectVO>> refMonthProjectData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<MonthProjectEntity> page = service.queryPage(param,false);
        IPage<MonthProjectVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), MonthProjectVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
