package com.ejianc.business.material.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.bean.RealtimebalanceEntity;
import com.ejianc.business.material.bean.SurplusmaterialapprovetailEntity;
import com.ejianc.business.material.service.IRealtimebalanceService;
import com.ejianc.business.material.utils.DateUtils;
import com.ejianc.business.material.vo.DealTypeEnum;
import com.ejianc.business.material.vo.SurplusmaterialapprovetailVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.business.material.bean.SurplusmaterialapproveEntity;
import com.ejianc.business.material.service.ISurplusmaterialapproveService;
import com.ejianc.business.material.vo.SurplusmaterialapproveVO;

/**
 * 剩余/废旧物资评估确认及处置审批表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("surplusmaterialapprove")
public class SurplusmaterialapproveController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private SessionManager sessionManager;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private ISurplusmaterialapproveService service;
    @Autowired
    private IRealtimebalanceService realtimebalanceService;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<SurplusmaterialapproveVO> saveOrUpdate(@RequestBody SurplusmaterialapproveVO saveorUpdateVO) {
        saveorUpdateVO.setUseStatus(1);
        for (SurplusmaterialapprovetailVO surplusmaterialapprovetailEntity : saveorUpdateVO.getSurplusmaterialapprovetailEntities()){
            surplusmaterialapprovetailEntity.setUseDetailStatus(1);
        }
    	SurplusmaterialapproveEntity entity = BeanMapper.map(saveorUpdateVO, SurplusmaterialapproveEntity.class);

    	//设置使用状态
    	if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
//                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        if(entity.getSurplusmaterialapprovetailEntities().size() > 0 && entity.getSurplusmaterialapprovetailEntities() != null){
            for(SurplusmaterialapprovetailEntity entity1 : entity.getSurplusmaterialapprovetailEntities()){
                QueryWrapper<RealtimebalanceEntity> queryWrapper = new QueryWrapper<>();
                queryWrapper.eq("project_id",entity.getProjectId());
                queryWrapper.eq("store_id",entity.getStoreId());
                queryWrapper.eq("material_category_code",entity1.getMaterialCategoryCode());
                queryWrapper.eq("material_code",entity1.getMaterialCode());
                RealtimebalanceEntity realtimebalanceEntity = realtimebalanceService.getOne(queryWrapper);
                if(realtimebalanceEntity != null && entity1.getMaterialNumber().compareTo(realtimebalanceEntity.getQuantity()) > 0){
                    throw  new BusinessException("物资编码:" + entity1.getMaterialCode() + ",物资名称:" + entity1.getMaterialName() + "数量大于可用库存数量!");
                }
            }
        }
    	service.saveOrUpdate(entity, false);
    	SurplusmaterialapproveVO vo = BeanMapper.map(entity, SurplusmaterialapproveVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<SurplusmaterialapproveVO> queryDetail(Long id) {
    	SurplusmaterialapproveEntity entity = service.selectById(id);
    	SurplusmaterialapproveVO vo = BeanMapper.map(entity, SurplusmaterialapproveVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<SurplusmaterialapproveVO> vos) {
        service.removeByIds(vos.stream().map(SurplusmaterialapproveVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<SurplusmaterialapproveVO>> queryList(@RequestBody QueryParam param) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("applyunit_name");
        fuzzyFields.add("project_name");
        fuzzyFields.add("billCode");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
//        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        IPage<SurplusmaterialapproveEntity> page = service.queryPage(param,false);
        IPage<SurplusmaterialapproveVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), SurplusmaterialapproveVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("applyunit_name");
        fuzzyFields.add("project_name");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("projectDepartmentId", new Parameter(QueryParam.IN, departmentIds));
        }
        List<SurplusmaterialapproveEntity> list = service.queryList(param);
        //todo:字段翻译等等
        List<SurplusmaterialapproveVO> SurplusmaterialapproveVOList = BeanMapper.mapList(list, SurplusmaterialapproveVO.class);
        for (int i = 0; i < SurplusmaterialapproveVOList.size(); i++) {
            SurplusmaterialapproveVO SurplusmaterialapproveVO = SurplusmaterialapproveVOList.get(i);
            SurplusmaterialapproveVO.setNum(String.valueOf(i + 1));
            if (SurplusmaterialapproveVO.getCreateTime() != null) {
                SurplusmaterialapproveVO.setCreateTimeShow(DateUtils.dateSimple2(SurplusmaterialapproveVO.getCreateTime()));
            }
            if (SurplusmaterialapproveVO.getApprovematerialTime() != null) {
                SurplusmaterialapproveVO.setResultDateShow(DateUtils.dateSimple2(SurplusmaterialapproveVO.getApprovematerialTime()));
            }
            String billStateStr = SurplusmaterialapproveVO.getBillState().toString();
            if (billStateStr != null) {
                if ("0".equals(billStateStr)) {//自由态
                    billStateStr = "自由态";
                } else if ("1".equals(billStateStr)) {//已提交
                    billStateStr = "已提交";
                } else if ("2".equals(billStateStr) || "5".equals(billStateStr)) {//审批中
                    billStateStr = "审批中";
                } else if ("3".equals(billStateStr)) {//审批通过
                    billStateStr = "审批通过";
                } else if ("4".equals(billStateStr)) {//驳回
                    billStateStr = "驳回";
                }

                SurplusmaterialapproveVO.setBillStateStr(billStateStr);
            }
            if (SurplusmaterialapproveVO.getDealType() != null){
                SurplusmaterialapproveVO.setDealTypeName(DealTypeEnum.getEnumByStateCode(SurplusmaterialapproveVO.getDealType()).getDescription());
            }

        }

        Map<String, Object> beans = new HashMap<>();
        beans.put("records", SurplusmaterialapproveVOList);
        ExcelExport.getInstance().export("Surplusmaterialapprove-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refSurplusmaterialapproveData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<SurplusmaterialapproveVO>> refSurplusmaterialapproveData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("projectName");
        fuzzyFields.add("applyunitName");

        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        //审批通过
        param.getParams().put("billState", new Parameter(QueryParam.IN, "1,3"));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
            if(_con.get("projectId")!=null){
                param.getParams().put("projectId", new Parameter(QueryParam.EQ, _con.get("projectId")));
            }
            if(_con.get("dealType")!=null){
                param.getParams().put("dealType", new Parameter(QueryParam.IN, _con.get("dealType")));
            }
            if(_con.get("type")!=null){
                param.getParams().put("useStatus", new Parameter(QueryParam.EQ, 1));
            }
        }



        IPage<SurplusmaterialapproveEntity> page = service.queryPage(param,false);
        IPage<SurplusmaterialapproveVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        List<SurplusmaterialapproveVO> surplusmaterialapproveVOS = BeanMapper.mapList(page.getRecords(), SurplusmaterialapproveVO.class);
        for (SurplusmaterialapproveVO surplusmaterialapproveVO : surplusmaterialapproveVOS){
            if (surplusmaterialapproveVO.getDealType() != null){
                surplusmaterialapproveVO.setDealTypeName(DealTypeEnum.getEnumByStateCode(surplusmaterialapproveVO.getDealType()).getDescription());
            }
        }

        pageData.setRecords(surplusmaterialapproveVOS);

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
