package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ejianc.business.material.bean.SurplusmaterialapproveEntity;
import com.ejianc.business.material.bean.SurplusmaterialrecordEntity;
import com.ejianc.business.material.bean.DeviceverificationrecordsEntity;
import com.ejianc.business.material.bean.SurplusmaterialrecordEntity;
import com.ejianc.business.material.service.ISurplusmaterialapproveService;
import com.ejianc.business.material.service.ISurplusmaterialrecordService;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;

import java.util.List;

@Service("surplusmaterialapprove") 
public class SurplusmaterialapproveBpmServiceImpl implements ICommonBusinessService {

	@Autowired
	private ISurplusmaterialapproveService service;

	@Autowired
	private ISurplusmaterialrecordService surplusmaterialrecordService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		SurplusmaterialapproveEntity surplusmaterialapproveEntity = service.selectById(billId);

		LambdaQueryWrapper<SurplusmaterialrecordEntity> queryWrapper = new LambdaQueryWrapper<>();
		queryWrapper.eq(SurplusmaterialrecordEntity::getDisposalCode, surplusmaterialapproveEntity.getBillCode());
		List<SurplusmaterialrecordEntity> deviceexitrecordsEntityList = surplusmaterialrecordService.list(queryWrapper);

		if(CollectionUtils.isNotEmpty(deviceexitrecordsEntityList)){
			return CommonResponse.error("撤回失败,该单据已经被剩余废旧物资处理记录引用！");
		}
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		SurplusmaterialapproveEntity surplusmaterialapproveEntity = service.selectById(billId);

		LambdaQueryWrapper<SurplusmaterialrecordEntity> queryWrapper = new LambdaQueryWrapper<>();
		queryWrapper.eq(SurplusmaterialrecordEntity::getDisposalCode, surplusmaterialapproveEntity.getBillCode());
		List<SurplusmaterialrecordEntity> deviceexitrecordsEntityList = surplusmaterialrecordService.list(queryWrapper);

		if(CollectionUtils.isNotEmpty(deviceexitrecordsEntityList)){
			return CommonResponse.error("撤回失败,该单据已经被剩余废旧物资处理记录引用！");
		}
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

}
