package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.bean.*;
import com.ejianc.business.material.service.IDeliveryrecordService;
import com.ejianc.business.material.service.IFlowmeterService;
import com.ejianc.business.material.service.IRealtimebalanceService;
import com.ejianc.business.material.service.IWastematerialresultService;
import com.ejianc.framework.core.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@Service("wastematerialresult") 
public class WastematerialresultBpmServiceImpl implements ICommonBusinessService {

	private Logger logger = LoggerFactory.getLogger(this.getClass());
	@Autowired
	private IWastematerialresultService wastematerialresultService;
	@Autowired
	private IRealtimebalanceService realtimebalanceService;
	@Autowired
	private IFlowmeterService flowmeterService;
	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	};

	/**
	 * 提交完回调
	 *
	 * @param
	 * @return
	 */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode){
		logger.info("出库提交--------------");
//		WastematerialresultEntity wastematerialresultEntity = wastematerialresultService.selectById(billId);
//		List<FlowmeterEntity> list = new ArrayList<>();//出入库流水记录表
//		List<RealtimebalanceEntity> realList = new ArrayList<>();//修改实时物资结存
//		List<RealtimebalanceEntity> realList1 = new ArrayList<>();//新增实时物资结存
//		List<WastematerialresulttailEntity> wastematerialresulttailEntities = wastematerialresultEntity.getWastematerialresulttailEntities();
//		if(wastematerialresulttailEntities != null && wastematerialresulttailEntities.size() > 0){
//			for(WastematerialresulttailEntity entity : wastematerialresulttailEntities){
//				//实时物资结存
//				QueryWrapper<RealtimebalanceEntity> queryWrapper = new QueryWrapper<>();
//				queryWrapper.eq("project_id",entity.getProjectId());
//				queryWrapper.eq("material_code",entity.getMaterialCode());
//				queryWrapper.eq("material_category_code",entity.getMaterialCategoryCode());
//				queryWrapper.eq("store_id",entity.getStoreId());
//				RealtimebalanceEntity realtimebalanceEntity = realtimebalanceService.getOne(queryWrapper);
//				if(realtimebalanceEntity != null){
//					if(realtimebalanceEntity.getQuantity().compareTo(BigDecimal.ZERO) == 0 || realtimebalanceEntity.getQuantity().compareTo(entity.getMaterialNumber()) < 0){
//						throw new BusinessException("物资编码:" + entity.getMaterialCode() + ",物资名称:" + entity.getMaterialName() + "库存不足，无法处置确认!");
//					}else{
//						FlowmeterEntity flowmeterEntity = this.createrFlowmeter(wastematerialresultEntity,entity);
//						list.add(flowmeterEntity);
//						realtimebalanceEntity.setQuantity(realtimebalanceEntity.getQuantity().subtract(entity.getMaterialNumber()));
//						if(realtimebalanceEntity.getQuantity().compareTo(BigDecimal.ZERO) != 0){
//							realtimebalanceEntity.setAmountIncluetax(realtimebalanceEntity.getAmountIncluetax().subtract(entity.getAmountIncluetax()));
//							realtimebalanceEntity.setAmountExcluetax(realtimebalanceEntity.getAmountExcluetax().subtract(entity.getAmountExcluetax()));
//							realtimebalanceEntity.setUnitPriceIncluetax(realtimebalanceEntity.getAmountIncluetax().divide(realtimebalanceEntity.getQuantity(),8,BigDecimal.ROUND_HALF_UP));
//							realtimebalanceEntity.setUnitPriceExcluetax(realtimebalanceEntity.getAmountExcluetax().divide(realtimebalanceEntity.getQuantity(),8,BigDecimal.ROUND_HALF_UP));
//						}else{
//							realtimebalanceEntity.setAmountIncluetax(new BigDecimal(0.00));
//							realtimebalanceEntity.setAmountExcluetax(new BigDecimal(0.00));
//							realtimebalanceEntity.setUnitPriceIncluetax(new BigDecimal(0.00));
//							realtimebalanceEntity.setUnitPriceExcluetax(new BigDecimal(0.00));
//						}
//						realList.add(realtimebalanceEntity);
//					}
//
//				}else{
//					throw new BusinessException("该物资编码:" + entity.getMaterialCode() + "，物资名称:" + entity.getMaterialName() + "没有库存，无法处置确认!");
//				}
//			}
//
//			if(list.size() > 0){
//				flowmeterService.saveBatch(list,list.size());
//			}
//			if(realList.size() > 0){
//				realtimebalanceService.updateBatchById(realList,realList.size());
//			}
//		}
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 有审批流的撤回前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
		return CommonResponse.success();
	};

	/**
	 * 有审批流的撤回后回调
	 *
	 * @param
	 * @return
	 */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode){
		logger.info("处置撤回--------------");
		WastematerialresultEntity wastematerialresultEntity = wastematerialresultService.selectById(billId);
		List<FlowmeterEntity> list = new ArrayList<>();//出入库流水记录表
		List<RealtimebalanceEntity> realList = new ArrayList<>();//修改实时物资结存
		List<RealtimebalanceEntity> realList1 = new ArrayList<>();//新增实时物资结存
		List<WastematerialresulttailEntity> wastematerialresulttailEntities = wastematerialresultEntity.getWastematerialresulttailEntities();
		if(wastematerialresulttailEntities.size() > 0 && wastematerialresulttailEntities != null){
			for(WastematerialresulttailEntity entity : wastematerialresulttailEntities){
				QueryWrapper<FlowmeterEntity> queryWrapper = new QueryWrapper<>();
				queryWrapper.eq("detail_id",entity.getId());
				FlowmeterEntity flowmeterEntity = flowmeterService.getOne(queryWrapper);
				list.add(flowmeterEntity);
				QueryWrapper<RealtimebalanceEntity> queryWrapper1 = new QueryWrapper<>();
				queryWrapper1.eq("project_id",wastematerialresultEntity.getProjectId());
				queryWrapper1.eq("material_category_code",entity.getMaterialCategoryCode());
				queryWrapper1.eq("material_code",entity.getMaterialCode());
				queryWrapper1.eq("store_id",entity.getStoreId());
				RealtimebalanceEntity realtimebalanceEntity = realtimebalanceService.getOne(queryWrapper1);
				realtimebalanceEntity.setQuantity(realtimebalanceEntity.getQuantity().add(entity.getMaterialNumber()));
				realtimebalanceEntity.setAmountIncluetax(realtimebalanceEntity.getAmountIncluetax().add(entity.getAmountIncluetax()));
				realtimebalanceEntity.setAmountExcluetax(realtimebalanceEntity.getAmountExcluetax().add(entity.getAmountExcluetax()));
				if(realtimebalanceEntity.getQuantity().compareTo(BigDecimal.ZERO) != 0){
					realtimebalanceEntity.setUnitPriceIncluetax(realtimebalanceEntity.getAmountIncluetax().divide(realtimebalanceEntity.getQuantity(),8,BigDecimal.ROUND_HALF_UP));
					realtimebalanceEntity.setUnitPriceExcluetax(realtimebalanceEntity.getAmountExcluetax().divide(realtimebalanceEntity.getQuantity(),8,BigDecimal.ROUND_HALF_UP));
				}else{
					realtimebalanceEntity.setUnitPriceIncluetax(new BigDecimal(0.00));
					realtimebalanceEntity.setUnitPriceExcluetax(new BigDecimal(0.00));
				}
				realList.add(realtimebalanceEntity);
			}

			if(list.size() > 0){
				flowmeterService.removeByIds(list.stream().map(FlowmeterEntity::getId).collect(Collectors.toList()),true);//删除出入库流水记录表
			}

			if(realList.size() > 0){
				realtimebalanceService.updateBatchById(realList,realList.size());
			}
		}
		return CommonResponse.success();
	};

	/**
	 * 审批节点审批中时节点审批前回调
	 *
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
		return CommonResponse.success();
	};

	/**
	 * 终审审核前回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 终审审核完回调
	 * 
	 * @param
	 * @return
	 */
	@Override
	public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		//TODO
		return CommonResponse.success();
	}

	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param state
	 * @return
	 */
	@Override
	@Transactional(rollbackFor = Exception.class)
	public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
		logger.info("处置弃审--------------");
		WastematerialresultEntity wastematerialresultEntity = wastematerialresultService.selectById(billId);
		List<FlowmeterEntity> list = new ArrayList<>();//出入库流水记录表
		List<RealtimebalanceEntity> realList = new ArrayList<>();//修改实时物资结存
		List<RealtimebalanceEntity> realList1 = new ArrayList<>();//新增实时物资结存
		List<WastematerialresulttailEntity> wastematerialresulttailEntities = wastematerialresultEntity.getWastematerialresulttailEntities();
		if(wastematerialresulttailEntities.size() > 0 && wastematerialresulttailEntities != null){
			for(WastematerialresulttailEntity entity : wastematerialresulttailEntities){
				QueryWrapper<FlowmeterEntity> queryWrapper = new QueryWrapper<>();
				queryWrapper.eq("detail_id",entity.getId());
				FlowmeterEntity flowmeterEntity = flowmeterService.getOne(queryWrapper);
				list.add(flowmeterEntity);
				QueryWrapper<RealtimebalanceEntity> queryWrapper1 = new QueryWrapper<>();
				queryWrapper1.eq("project_id",wastematerialresultEntity.getProjectId());
				queryWrapper1.eq("material_category_code",entity.getMaterialCategoryCode());
				queryWrapper1.eq("material_code",entity.getMaterialCode());
				queryWrapper1.eq("store_id",entity.getStoreId());
				RealtimebalanceEntity realtimebalanceEntity = realtimebalanceService.getOne(queryWrapper1);
				realtimebalanceEntity.setQuantity(realtimebalanceEntity.getQuantity().add(entity.getMaterialNumber()));
				realtimebalanceEntity.setAmountIncluetax(realtimebalanceEntity.getAmountIncluetax().add(entity.getAmountIncluetax()));
				realtimebalanceEntity.setAmountExcluetax(realtimebalanceEntity.getAmountExcluetax().add(entity.getAmountExcluetax()));
				if(realtimebalanceEntity.getQuantity().compareTo(BigDecimal.ZERO) != 0){
					realtimebalanceEntity.setUnitPriceIncluetax(realtimebalanceEntity.getAmountIncluetax().divide(realtimebalanceEntity.getQuantity(),8,BigDecimal.ROUND_HALF_UP));
					realtimebalanceEntity.setUnitPriceExcluetax(realtimebalanceEntity.getAmountExcluetax().divide(realtimebalanceEntity.getQuantity(),8,BigDecimal.ROUND_HALF_UP));
				}else{
					realtimebalanceEntity.setUnitPriceIncluetax(new BigDecimal(0.00));
					realtimebalanceEntity.setUnitPriceExcluetax(new BigDecimal(0.00));
				}
				realList.add(realtimebalanceEntity);
			}

			if(list.size() > 0){
				flowmeterService.removeByIds(list.stream().map(FlowmeterEntity::getId).collect(Collectors.toList()),true);//删除出入库流水记录表
			}

			if(realList.size() > 0){
				realtimebalanceService.updateBatchById(realList,realList.size());
			}
		}
		//TODO
		return CommonResponse.success();
	}

	private FlowmeterEntity createrFlowmeter(WastematerialresultEntity wastematerialresultEntity,WastematerialresulttailEntity entity){
		FlowmeterEntity flowmeterEntity = new FlowmeterEntity();
		flowmeterEntity.setMid(wastematerialresultEntity.getId());
		flowmeterEntity.setDetailId(entity.getId());
		flowmeterEntity.setBillCode(wastematerialresultEntity.getBillCode());
		flowmeterEntity.setProjectId(entity.getProjectId());
		flowmeterEntity.setProjectName(entity.getProjectName());
		flowmeterEntity.setStoreId(entity.getStoreId());
		flowmeterEntity.setStoreName(entity.getStoreName());
		flowmeterEntity.setMaterialCode(entity.getMaterialCode());
		flowmeterEntity.setMaterialName(entity.getMaterialName());
		flowmeterEntity.setMaterialCategoryId(entity.getMaterialCategoryId());
		flowmeterEntity.setMaterialCategoryCode(entity.getMaterialCategoryCode());
		flowmeterEntity.setMaterialCategoryName(entity.getMaterialCategoryName());
		flowmeterEntity.setOperationType("出库");
		flowmeterEntity.setAccessType("处置");
		flowmeterEntity.setQuantity(entity.getMaterialNumber());
		flowmeterEntity.setUnitPriceIncluetax(entity.getUnitPriceIncluetax());
		flowmeterEntity.setUnitPriceExcluetax(entity.getUnitPriceExcluetax());
		flowmeterEntity.setAmountIncluetax(entity.getAmountIncluetax());
		flowmeterEntity.setAmountExcluetax(entity.getAmountExcluetax());
		flowmeterEntity.setTime(entity.getPuinTime());
		flowmeterEntity.setOrgId(wastematerialresultEntity.getOrgId());
		flowmeterEntity.setOrgName(wastematerialresultEntity.getOrgName());
		flowmeterEntity.setMeasurementUnit(entity.getMaterialUnit());
		flowmeterEntity.setSpecialModel(entity.getMaterialSpecifications());
		flowmeterEntity.setProjectDepartmentId(wastematerialresultEntity.getProjectDepartmentId());
		return  flowmeterEntity;
	}

}
