package com.ejianc.business.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.material.bean.*;
import com.ejianc.business.material.service.*;
import com.ejianc.business.material.vo.WastematerialresultVO;
import com.ejianc.business.material.vo.WastematerialresulttailVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.material.mapper.WastematerialresultMapper;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 废旧物资处置结果确认表
 * 
 * @author generator
 * 
 */
@Service("wastematerialresultService")
public class WastematerialresultServiceImpl extends BaseServiceImpl<WastematerialresultMapper, WastematerialresultEntity> implements IWastematerialresultService{

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private ISurplusmaterialrecordService surplusmaterialrecordService;
    @Autowired
    private ISurplusmaterialrecordtailService surplusmaterialrecordtailService;
    @Autowired
    private IWastematerialresulttailService wastematerialresulttailService;
    @Autowired
    private ISurplusmaterialapproveService surplusmaterialapproveService;
    private static final String BILL_CODE = "ZJKJ_ACTUAL_CODE";//此处需要根据实际修改


    @Transactional
    @Override
    public WastematerialresultVO saveOrUpdate(WastematerialresultVO saveorUpdateVO) {
        WastematerialresultEntity entity = BeanMapper.map(saveorUpdateVO, WastematerialresultEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        List<WastematerialresulttailEntity> wastematerialresulttailEntities = entity.getWastematerialresulttailEntities();
        SurplusmaterialapproveEntity surplusmaterialapproveEntity = surplusmaterialapproveService.getById(entity.getResultcodeId());
        for (WastematerialresulttailEntity item : wastematerialresulttailEntities) {
            item.setProjectId(entity.getProjectId());
            item.setProjectName(entity.getProjectName());
            item.setStoreId(surplusmaterialapproveEntity.getStoreId());
            item.setPuinTime(surplusmaterialapproveEntity.getApprovematerialTime());
            item.setTenantId(entity.getTenantId());
            item.setOrgId(entity.getOrgId());
            item.setProjectDepartmentId(entity.getProjectDepartmentId());
        }

        //回写记录表, 一条记录只能被确认一次
        //撤回之前的状态
        if (saveorUpdateVO.getId() != null){
            WastematerialresultEntity wastematerialresultEntity = super.selectById(saveorUpdateVO.getId());
            List<WastematerialresulttailEntity> wastematerialresulttailList = wastematerialresultEntity.getWastematerialresulttailEntities();
            if (CollectionUtils.isNotEmpty(wastematerialresulttailList)){
                List<Long> recordDetailIds = wastematerialresulttailList.stream().map(WastematerialresulttailEntity::getRecordDetailId).distinct().collect(Collectors.toList());
                List<Long> recordIds = wastematerialresulttailList.stream().map(WastematerialresulttailEntity::getRecordId).distinct().collect(Collectors.toList());
                //记录主表
                LambdaQueryWrapper<SurplusmaterialrecordEntity> lambdaRecord = Wrappers.<SurplusmaterialrecordEntity>lambdaQuery();
                lambdaRecord.in(SurplusmaterialrecordEntity::getId, recordIds);
                List<SurplusmaterialrecordEntity> recordList = surplusmaterialrecordService.list(lambdaRecord);
                for (SurplusmaterialrecordEntity surplusmaterialrecordEntity : recordList){
                    surplusmaterialrecordEntity.setUseStatus(1);
                }
                if (CollectionUtils.isNotEmpty(recordList)){
                    surplusmaterialrecordService.updateBatchById(recordList);
                }

                //记录子表
                LambdaQueryWrapper<SurplusmaterialrecordtailEntity> lambdaRecordDetail = Wrappers.<SurplusmaterialrecordtailEntity>lambdaQuery();
                lambdaRecordDetail.in(SurplusmaterialrecordtailEntity::getId, recordDetailIds);
                List<SurplusmaterialrecordtailEntity> recordDetailList = surplusmaterialrecordtailService.list(lambdaRecordDetail);
                for (SurplusmaterialrecordtailEntity surplusmaterialrecordtailEntity : recordDetailList){
                    surplusmaterialrecordtailEntity.setUseDetailStatus(1);
                }
                if (CollectionUtils.isNotEmpty(recordDetailList)){
                    surplusmaterialrecordtailService.updateBatchById(recordDetailList);
                }

            }
        }

        //更新最新的记录状态
        List<WastematerialresulttailVO> wastematerialresulttailVOS = saveorUpdateVO.getWastematerialresulttailEntities();
        if (CollectionUtils.isNotEmpty(wastematerialresulttailVOS)){
            List<Long> recordDetailIds = wastematerialresulttailVOS.stream().filter(s->s.getRowState() == null || !s.getRowState().equals("del")).map(WastematerialresulttailVO::getRecordDetailId).distinct().collect(Collectors.toList());
            List<Long> recordIds = wastematerialresulttailVOS.stream().filter(s->s.getRowState() == null || !s.getRowState().equals("del")).map(WastematerialresulttailVO::getRecordId).distinct().collect(Collectors.toList());
            //记录主表
            LambdaQueryWrapper<SurplusmaterialrecordEntity> lambdaRecord = Wrappers.<SurplusmaterialrecordEntity>lambdaQuery();
            lambdaRecord.in(SurplusmaterialrecordEntity::getId, recordIds);
            List<SurplusmaterialrecordEntity> recordList = surplusmaterialrecordService.list(lambdaRecord);
            for (SurplusmaterialrecordEntity surplusmaterialrecordEntity : recordList){
                surplusmaterialrecordEntity.setUseStatus(2);
            }
            if (CollectionUtils.isNotEmpty(recordList)){
                surplusmaterialrecordService.updateBatchById(recordList);
            }
            //记录子表
            LambdaQueryWrapper<SurplusmaterialrecordtailEntity> lambdaRecordDetail = Wrappers.<SurplusmaterialrecordtailEntity>lambdaQuery();
            lambdaRecordDetail.in(SurplusmaterialrecordtailEntity::getId, recordDetailIds);
            List<SurplusmaterialrecordtailEntity> recordDetailList = surplusmaterialrecordtailService.list(lambdaRecordDetail);
            for (SurplusmaterialrecordtailEntity surplusmaterialrecordtailEntity : recordDetailList){
                surplusmaterialrecordtailEntity.setUseDetailStatus(2);
            }
            if (CollectionUtils.isNotEmpty(recordDetailList)){
                surplusmaterialrecordtailService.updateBatchById(recordDetailList);
            }

        }



        super.saveOrUpdate(entity, false);
        WastematerialresultVO vo = BeanMapper.map(entity, WastematerialresultVO.class);
        return vo;
      }
    @Transactional
    @Override
    public void delete(List<WastematerialresultVO> vos) {
        List<Long> ids = vos.stream().map(WastematerialresultVO::getId).collect(Collectors.toList());
        LambdaQueryWrapper<WastematerialresulttailEntity> lambdaResultDetail = Wrappers.<WastematerialresulttailEntity>lambdaQuery();
        lambdaResultDetail.in(WastematerialresulttailEntity::getMid, ids);
        List<WastematerialresulttailEntity> recordDetailList = wastematerialresulttailService.list(lambdaResultDetail);
        //回写处置记录状态
        if (CollectionUtils.isNotEmpty(recordDetailList)){
            List<Long> recordDetailIds = recordDetailList.stream().map(WastematerialresulttailEntity::getRecordDetailId).distinct().collect(Collectors.toList());
            List<Long> recordIds = recordDetailList.stream().map(WastematerialresulttailEntity::getRecordId).distinct().collect(Collectors.toList());
            //记录主表
            LambdaQueryWrapper<SurplusmaterialrecordEntity> lambdaRecord = Wrappers.<SurplusmaterialrecordEntity>lambdaQuery();
            lambdaRecord.in(SurplusmaterialrecordEntity::getId, recordIds);
            List<SurplusmaterialrecordEntity> recordList = surplusmaterialrecordService.list(lambdaRecord);
            for (SurplusmaterialrecordEntity surplusmaterialrecordEntity : recordList){
                surplusmaterialrecordEntity.setUseStatus(1);
            }
            if (CollectionUtils.isNotEmpty(recordList)){
                surplusmaterialrecordService.updateBatchById(recordList);
            }

            //记录子表
            LambdaQueryWrapper<SurplusmaterialrecordtailEntity> lambdaRecordDetail = Wrappers.<SurplusmaterialrecordtailEntity>lambdaQuery();
            lambdaRecordDetail.in(SurplusmaterialrecordtailEntity::getId, recordDetailIds);
            List<SurplusmaterialrecordtailEntity> recordDetailList1 = surplusmaterialrecordtailService.list(lambdaRecordDetail);
            for (SurplusmaterialrecordtailEntity surplusmaterialrecordtailEntity : recordDetailList1){
                surplusmaterialrecordtailEntity.setUseDetailStatus(1);
            }
            if (CollectionUtils.isNotEmpty(recordDetailList1)){
                surplusmaterialrecordtailService.updateBatchById(recordDetailList1);
            }
        }

        super.removeByIds(vos.stream().map(WastematerialresultVO::getId).collect(Collectors.toList()),true);
    }
}
