package com.ejianc.business.material.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 物资出库记录
 *
 * @author generator
 *
 */
public class SupDeliveryrecordVO{
    private static final long serialVersionUID = 1L;
    private Long id;
    private String billCode; // 单据编号
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private Date approveTime; // 审批通过日期
    private Long projectdeptId; // 项目部人员id
    private String projectdept; // 项目部人员
    @JsonFormat(shape = JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd",timezone = "GMT+8")
    private Date billsTime; // 单据日期
    private String brands; // 品牌
    @JsonFormat(shape = JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd",timezone = "GMT+8")
    private Date pickingTime; // 领料日期
    private String pickingUnit; // 领料单位
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private Long projectDepartmentId; // 项目部id
    private Long changeId; // 变更单据id
    private String changeState; // 变更状态，1:未变更;2:变更中;3:已变更
    private String remarks; // 备注
    private Long agentId; // 经办人
    private String agentName; // 经办人姓名
    private String issueNum; // 出库编号
    private String receivingPurpose; // 领用用途
    private String signatureCust; // 保管员签字
    private String projectMaterial; // 项目物资部
    private String projectEngineer; // 项目管理部
    private String ministry; // 商务部
    @JsonFormat(shape = JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd",timezone = "GMT+8")
    private Date approvalDate; // 审批日期
    private Long pickingunitId; // 领料单位id
    private Integer deliveryType; // 出库类型 0-自动出库 1-手动出库
    private String deliveryTypeName;//出库类型 0-自动出库 1-手动出库
    private Integer deliveryTypes; // 出库类型 0-成品出库 1-成品退库 2-直入直出退库  3-废旧物资出库 4-资产出库 5-废旧物资退库 6-资产退库7-直入直出退供应商 8-无来源退库
    private String deliveryTypesName; // 出库类型 0-成品出库 1-成品退库 2-直入直出退库  3-废旧物资出库 4-资产出库 5-废旧物资退库 6-资产退库7-直入直出退供应商 8-无来源退库
    private Long warehousingId; // 入库单id
    private String num; // 序号
    private String createTimeShow;
    private String billStateStr;
    private String resultDateShow;
    private Long deliveryId; // 出库单id
    private BigDecimal notDeliveryQuantity;//未出库数量
    private Long receiptDocId; // 入库单id参照使用
    private Long returnedStoreId; // 退库仓库id
    private String returnedStoreName; // 退库仓库名称
    @JsonFormat(shape = JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd",timezone = "GMT+8")
    private Date returnedStoreDate; // 退库仓库日期
    private Long storeId;
    private String storeName;//仓库名称

    private String selfState; // 是否自施 0-否 1-是
    private BigDecimal outMnyTax; // 出库金额(含税)
    private BigDecimal outMny; // 出库金额
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date puinTimeLimit; // 入库单的入库日期校验用
    /**
     * 来源业务系统id
     */
    private String systemId;

    private Long sourceId;

    private Integer signStatus;//分包签字状态 1-未签字,2-已签字


    private List<SupDeliveryrecorddetailVO> deliveryrecorddetailEntityList = new ArrayList<>(); // 物资出库记录子表

    public Integer getSignStatus() {
        return signStatus;
    }

    public void setSignStatus(Integer signStatus) {
        this.signStatus = signStatus;
    }

    public String getSystemId() {
        return systemId;
    }

    public void setSystemId(String systemId) {
        this.systemId = systemId;
    }

    public Long getSourceId() {
        return sourceId;
    }

    public void setSourceId(Long sourceId) {
        this.sourceId = sourceId;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Date getPuinTimeLimit() {
        return puinTimeLimit;
    }

    public void setPuinTimeLimit(Date puinTimeLimit) {
        this.puinTimeLimit = puinTimeLimit;
    }

    public BigDecimal getOutMnyTax() {
        return outMnyTax;
    }

    public void setOutMnyTax(BigDecimal outMnyTax) {
        this.outMnyTax = outMnyTax;
    }

    public BigDecimal getOutMny() {
        return outMny;
    }

    public void setOutMny(BigDecimal outMny) {
        this.outMny = outMny;
    }

    public String getDeliveryTypesName() {
        return deliveryTypesName;
    }

    public void setDeliveryTypesName(String deliveryTypesName) {
        this.deliveryTypesName = deliveryTypesName;
    }

    public String getDeliveryTypeName() {
        return deliveryTypeName;
    }

    public void setDeliveryTypeName(String deliveryTypeName) {
        this.deliveryTypeName = deliveryTypeName;
    }

    public String getSelfState() {
        return selfState;
    }

    public void setSelfState(String selfState) {
        this.selfState = selfState;
    }


    public Date getReturnedStoreDate() {
        return returnedStoreDate;
    }

    public void setReturnedStoreDate(Date returnedStoreDate) {
        this.returnedStoreDate = returnedStoreDate;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 审批通过日期
     */
    public Date getApproveTime() {
        return approveTime;
    }

    /**
     * 审批通过日期
     */
    public void setApproveTime(Date approveTime) {
        this.approveTime = approveTime;
    }
    /**
     * 项目部人员id
     */
    @ReferSerialTransfer(referCode="idm-user")
    public Long getProjectdeptId() {
        return projectdeptId;
    }

    /**
     * 项目部人员id
     */
    @ReferDeserialTransfer
    public void setProjectdeptId(Long projectdeptId) {
        this.projectdeptId = projectdeptId;
    }
    /**
     * 项目部人员
     */
    public String getProjectdept() {
        return projectdept;
    }

    /**
     * 项目部人员
     */
    public void setProjectdept(String projectdept) {
        this.projectdept = projectdept;
    }
    /**
     * 单据日期
     */
    public Date getBillsTime() {
        return billsTime;
    }

    /**
     * 单据日期
     */
    public void setBillsTime(Date billsTime) {
        this.billsTime = billsTime;
    }
    /**
     * 品牌
     */
    public String getBrands() {
        return brands;
    }

    /**
     * 品牌
     */
    public void setBrands(String brands) {
        this.brands = brands;
    }
    /**
     * 领料日期
     */
    public Date getPickingTime() {
        return pickingTime;
    }

    /**
     * 领料日期
     */
    public void setPickingTime(Date pickingTime) {
        this.pickingTime = pickingTime;
    }
    /**
     * 领料单位
     */
    public String getPickingUnit() {
        return pickingUnit;
    }

    /**
     * 领料单位
     */
    public void setPickingUnit(String pickingUnit) {
        this.pickingUnit = pickingUnit;
    }
    /**
     * 项目id
     */
    @ReferSerialTransfer(referCode="ejc-zjkj-project")
    public Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    /**
     * 所属组织id
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织id
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 所属组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 所属组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部id
     */
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    /**
     * 项目部id
     */
    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    /**
     * 变更单据id
     */
    public Long getChangeId() {
        return changeId;
    }

    /**
     * 变更单据id
     */
    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }
    /**
     * 变更状态，1:未变更;2:变更中;3:已变更
     */
    public String getChangeState() {
        return changeState;
    }

    /**
     * 变更状态，1:未变更;2:变更中;3:已变更
     */
    public void setChangeState(String changeState) {
        this.changeState = changeState;
    }
    /**
     * 备注
     */
    public String getRemarks() {
        return remarks;
    }

    /**
     * 备注
     */
    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
    /**
     * 经办人
     */
    public Long getAgentId() {
        return agentId;
    }

    /**
     * 经办人
     */
    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }
    /**
     * 经办人姓名
     */
    public String getAgentName() {
        return agentName;
    }

    /**
     * 经办人姓名
     */
    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }
    /**
     * 出库编号
     */
    public String getIssueNum() {
        return issueNum;
    }

    /**
     * 出库编号
     */
    public void setIssueNum(String issueNum) {
        this.issueNum = issueNum;
    }
    /**
     * 领用用途
     */
    public String getReceivingPurpose() {
        return receivingPurpose;
    }

    /**
     * 领用用途
     */
    public void setReceivingPurpose(String receivingPurpose) {
        this.receivingPurpose = receivingPurpose;
    }
    /**
     * 保管员签字
     */
    public String getSignatureCust() {
        return signatureCust;
    }

    /**
     * 保管员签字
     */
    public void setSignatureCust(String signatureCust) {
        this.signatureCust = signatureCust;
    }
    /**
     * 项目物资部
     */
    public String getProjectMaterial() {
        return projectMaterial;
    }

    /**
     * 项目物资部
     */
    public void setProjectMaterial(String projectMaterial) {
        this.projectMaterial = projectMaterial;
    }
    /**
     * 项目管理部
     */
    public String getProjectEngineer() {
        return projectEngineer;
    }

    /**
     * 项目管理部
     */
    public void setProjectEngineer(String projectEngineer) {
        this.projectEngineer = projectEngineer;
    }
    /**
     * 商务部
     */
    public String getMinistry() {
        return ministry;
    }

    /**
     * 商务部
     */
    public void setMinistry(String ministry) {
        this.ministry = ministry;
    }
    /**
     * 审批日期
     */
    public Date getApprovalDate() {
        return approvalDate;
    }

    /**
     * 审批日期
     */
    public void setApprovalDate(Date approvalDate) {
        this.approvalDate = approvalDate;
    }


    public List<SupDeliveryrecorddetailVO> getDeliveryrecorddetailEntityList() {
        return deliveryrecorddetailEntityList;
    }

    public void setDeliveryrecorddetailEntityList(List<SupDeliveryrecorddetailVO> deliveryrecorddetailEntityList) {
        this.deliveryrecorddetailEntityList = deliveryrecorddetailEntityList;
    }

    @ReferSerialTransfer(referCode = "support-supplier")
    public Long getPickingunitId() {
        return pickingunitId;
    }

    @ReferDeserialTransfer
    public void setPickingunitId(Long pickingunitId) {
        this.pickingunitId = pickingunitId;
    }

    public String getNum() {
        return num;
    }

    public void setNum(String num) {
        this.num = num;
    }

    public String getCreateTimeShow() {
        return createTimeShow;
    }

    public void setCreateTimeShow(String createTimeShow) {
        this.createTimeShow = createTimeShow;
    }

    public String getBillStateStr() {
        return billStateStr;
    }

    public void setBillStateStr(String billStateStr) {
        this.billStateStr = billStateStr;
    }

    public String getResultDateShow() {
        return resultDateShow;
    }

    public void setResultDateShow(String resultDateShow) {
        this.resultDateShow = resultDateShow;
    }

    @ReferSerialTransfer(referCode="StoreRef")
    public Long getStoreId() {
        return storeId;
    }

    @ReferDeserialTransfer
    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }

    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }

    public Integer getDeliveryType() {
        return deliveryType;
    }

    public void setDeliveryType(Integer deliveryType) {
        this.deliveryType = deliveryType;
    }

    public Long getWarehousingId() {
        return warehousingId;
    }

    public void setWarehousingId(Long warehousingId) {
        this.warehousingId = warehousingId;
    }

    public Integer getDeliveryTypes() {
        return deliveryTypes;
    }

    public void setDeliveryTypes(Integer deliveryTypes) {
        this.deliveryTypes = deliveryTypes;
    }

    @ReferSerialTransfer(referCode="DeliveryrecordRef")
    public Long getDeliveryId() {
        return deliveryId;
    }

    @ReferDeserialTransfer
    public void setDeliveryId(Long deliveryId) {
        this.deliveryId = deliveryId;
    }

    public BigDecimal getNotDeliveryQuantity() {
        return notDeliveryQuantity;
    }

    public void setNotDeliveryQuantity(BigDecimal notDeliveryQuantity) {
        this.notDeliveryQuantity = notDeliveryQuantity;
    }
    @ReferSerialTransfer(referCode = "MaterialWarehousingRef")
    public Long getReceiptDocId() {
        return receiptDocId;
    }

    @ReferDeserialTransfer
    public void setReceiptDocId(Long receiptDocId) {
        this.receiptDocId = receiptDocId;
    }

    @ReferSerialTransfer(referCode="StoreRef")
    public Long getReturnedStoreId() {
        return returnedStoreId;
    }

    @ReferDeserialTransfer
    public void setReturnedStoreId(Long returnedStoreId) {
        this.returnedStoreId = returnedStoreId;
    }

    public String getReturnedStoreName() {
        return returnedStoreName;
    }

    public void setReturnedStoreName(String returnedStoreName) {
        this.returnedStoreName = returnedStoreName;
    }
}
