package com.ejianc.business.outputValue.controller;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.outputValue.bean.CompanyMonthEntity;
import com.ejianc.business.outputValue.bean.CompanyMonthProjectDetailEntity;
import com.ejianc.business.outputValue.bean.CompanyMonthRecordEntity;
import com.ejianc.business.outputValue.service.ICompanyMonthProjectDetailService;
import com.ejianc.business.outputValue.service.ICompanyMonthRecordService;
import com.ejianc.business.outputValue.service.ICompanyMonthService;
import com.ejianc.business.outputValue.vo.CompanyBusinessQuotaRecordVO;
import com.ejianc.business.outputValue.vo.CompanyMonthProjectDetailVO;
import com.ejianc.business.outputValue.vo.CompanyMonthVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 公司月度产值录入
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("companyMonth")
public class CompanyMonthController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private ICompanyMonthService service;
    @Autowired
    private ICompanyMonthProjectDetailService detailService;
    @Autowired
    private ICompanyMonthRecordService recordService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<CompanyMonthVO> saveOrUpdate(@RequestBody CompanyMonthVO saveOrUpdateVO) {
        CompanyMonthEntity entity = BeanMapper.map(saveOrUpdateVO, CompanyMonthEntity.class);
        QueryWrapper<CompanyMonthEntity> wrapper = new QueryWrapper<>();
        if(entity.getId() != null){
            wrapper.ne("id", entity.getId());
        }
        wrapper.eq("year", entity.getYear());
        wrapper.eq("month", entity.getYear());
        wrapper.eq("org_id", entity.getOrgId());
        Integer count = service.count(wrapper);
        if(count>0){
            throw new BusinessException("该公司本年本月已存在产值录入！");
        }
        if(StringUtils.isBlank(entity.getChangeState())){
            entity.setChangeState("1");//未变更
        }
    	if(entity.getId() == null || entity.getId() == 0){

        }
    	service.saveOrUpdate(entity, false);
    	CompanyMonthVO vo = BeanMapper.map(entity, CompanyMonthVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<CompanyMonthVO> queryDetail(Long id) {
    	CompanyMonthEntity entity = service.selectById(id);
        QueryWrapper<CompanyMonthProjectDetailEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("company_month_id", id);
        wrapper.orderByAsc("pc_factory");
        wrapper.orderByDesc("create_time");
        List<CompanyMonthProjectDetailEntity> list = detailService.list(wrapper);
        entity.setDetailList(list);
    	CompanyMonthVO vo = BeanMapper.map(entity, CompanyMonthVO.class);

        //当前单据变更过则显示变更记录
        QueryWrapper<CompanyMonthRecordEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("dr", 0);
        queryWrapper.eq("company_month_id", id);
        List<CompanyMonthRecordEntity> records = recordService.list(queryWrapper);
        if(records!=null&&records.size()>0){
            vo.setRecordList(BeanMapper.mapList(records, CompanyBusinessQuotaRecordVO.class));
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<CompanyMonthVO> vos) {
        service.removeByIds(vos.stream().map(CompanyMonthVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<CompanyMonthVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("orgShortName");
        fuzzyFields.add("year");
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<CompanyMonthEntity> page = service.queryPage(param,false);
        IPage<CompanyMonthVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), CompanyMonthVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("billCode");
        fuzzyFields.add("orgName");
        fuzzyFields.add("orgShortName");
        fuzzyFields.add("year");
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */
        List<CompanyMonthEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("CompanyMonth-export.xlsx", beans, response);
    }

    /**
     * @Description queryProjectByOrgId 查询公司下的所有项目+工厂
     * @param id
     */
    @RequestMapping(value = "/queryProjectByOrgId", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<CompanyMonthProjectDetailVO>> queryProjectByOrgId(Long orgId,String year, String month) {
        List<CompanyMonthProjectDetailVO> list = detailService.queryProjectByOrgId(orgId, year, month);
        return CommonResponse.success("查询详情数据成功！",list);
    }

}
