package com.ejianc.business.outputValue.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.utils.CommonUtils;
import com.ejianc.business.outputValue.bean.CompanyBusinessQuotaEntity;
import com.ejianc.business.outputValue.bean.ProjectSupplementEntity;
import com.ejianc.business.outputValue.mapper.CompanyBusinessQuotaMapper;
import com.ejianc.business.outputValue.mapper.PcMonthActualOutputValueMapper;
import com.ejianc.business.outputValue.mapper.ProjectMonthActualOutputValueMapper;
import com.ejianc.business.outputValue.mapper.ProjectSupplementMapper;
import com.ejianc.business.outputValue.service.ICompanyBusinessQuotaService;
import com.ejianc.business.outputValue.service.IProjectSupplementService;
import com.ejianc.business.outputValue.vo.CompanyBusinessQuotaVO;
import com.ejianc.business.outputValue.vo.PcMonthActualOutputValueVO;
import com.ejianc.business.outputValue.vo.ProjectMonthActualOutputValueVO;
import com.ejianc.business.outputValue.vo.ProjectSupplementVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 公司经营指标 （产值）
 * 
 * @author generator
 * 
 */
@Service("companyBusinessQuotaService")
public class CompanyBusinessQuotaServiceImpl extends BaseServiceImpl<CompanyBusinessQuotaMapper, CompanyBusinessQuotaEntity> implements ICompanyBusinessQuotaService {

    @Autowired
    private IOrgApi iOrgApi;

    @Autowired
    private IProjectSupplementService projectSupplementService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ProjectSupplementMapper projectSupplementMapper;
    @Autowired
    private PcMonthActualOutputValueMapper pcMonthActualOutputValueMapper;
    @Autowired
    private ProjectMonthActualOutputValueMapper projectMonthActualOutputValueMapper;

    @Override
    public CompanyBusinessQuotaVO queryInfoByOrgId(Long orgId, String year) {
        List<OrgVO> orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(orgId), true, "查询失败，获取当前本下组织信息失败。");
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        orgVOList.stream().forEach(org -> {
            if(5 != org.getOrgType()){
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });

        CompanyBusinessQuotaVO vo = new CompanyBusinessQuotaVO();
        QueryWrapper<CompanyBusinessQuotaEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("org_id", orgId);
        //上一年
        String lastYear = String.valueOf(Integer.parseInt(year) -1);
        wrapper.eq("year", year);
        wrapper.orderByDesc("create_time");
        List<CompanyBusinessQuotaEntity> list = this.list(wrapper);
        if(list!=null && list.size()>0){
            CompanyBusinessQuotaEntity lastEntity = list.get(0);

            vo.setLastYearCompletedSpace(lastEntity.getThisYearCompleteCompletedSpace());// 上年竣工面积（万平米）
            vo.setLastYearProjectConfirmedOutputValue(lastEntity.getThisYearCompleteProjectConfirmedOutputValue()); // 上年项目确认产值(亿元)
            vo.setLastYearProjectCompletedOutputValue(lastEntity.getThisYearCompleteProjectOutputValue()); // 上年项目完成产值(亿元)
            vo.setLastYearStartWorkSpace(lastEntity.getThisYearCompleteStartWorkSpace()); // 上年开工面积（万平米）
            vo.setLastYearPcOutputValue(lastEntity.getThisYearCompletePcOutputValue()); // 上年PC工厂产值(亿元)
            vo.setLastYearCompleteTotalOutputValue(lastEntity.getThisYearCompleteTotalOutputValue()); // 上年完成总产值(亿元)
        }else{
            vo.setLastYearCompletedSpace(new BigDecimal(0));// 上年竣工面积（万平米）
            vo.setLastYearProjectConfirmedOutputValue(new BigDecimal(0)); // 上年项目确认产值(亿元)
            vo.setLastYearProjectCompletedOutputValue(new BigDecimal(0)); // 上年项目完成产值(亿元)
            vo.setLastYearStartWorkSpace(new BigDecimal(0)); // 上年开工面积（万平米）
            vo.setLastYearPcOutputValue(new BigDecimal(0)); // 上年PC工厂产值(亿元)
            vo.setLastYearCompleteTotalOutputValue(new BigDecimal(0)); // 上年完成总产值(亿元)
        }
        QueryWrapper<ProjectSupplementEntity> projectWrapper = new QueryWrapper<>();
        projectWrapper.like("effect_last_date", lastYear);
        projectWrapper.in("bill_state", 1,3);
        projectWrapper.in("project_status", "竣工未结","竣工已结");//竣工的
        projectWrapper.in("org_id", commonOrgIds);

        Integer lastYearCompletedProjectNumber = projectSupplementService.count(projectWrapper);
        vo.setLastYearCompletedProjectNumber(Long.parseLong(lastYearCompletedProjectNumber.toString())); // 上年竣工项目数（个）

        QueryWrapper<ProjectSupplementEntity> projectWrapper2 = new QueryWrapper<>();
        projectWrapper2.like("effect_last_date", lastYear);
        projectWrapper2.in("bill_state", 1,3);
        projectWrapper2.in("project_status", "在施");//在施
        projectWrapper2.in("org_id", commonOrgIds);
        Integer lastYearStartWorkProjectNumber = projectSupplementService.count(projectWrapper2);
        vo.setLastYearStartWorkProjectNumber(Long.parseLong(lastYearStartWorkProjectNumber.toString())); // 上年开工项目数（个）

        Map<String,Object> param = new HashMap<>();
        param.put("twoOrgId", orgId);
        param.put("year", year);
        ProjectMonthActualOutputValueVO projectData = projectMonthActualOutputValueMapper.selectSumData(param);
        if(projectData!=null && projectData.getThisMonthActualOutputValue()!=null){
            // 本月实际完成产值       万元--->亿元
            vo.setThisYearCompleteProjectOutputValue(CommonUtils.parseDivide4(projectData.getThisMonthActualOutputValue(), 4));
            // 本月确认产值       万元--->亿元
            vo.setThisYearCompleteProjectConfirmedOutputValue(CommonUtils.parseDivide4(projectData.getThisMonthConfirmedOutputValue(), 4));
        }else{
            // 本月实际完成产值       万元--->亿元
            vo.setThisYearCompleteProjectOutputValue(new BigDecimal(0));
            // 本月确认产值       万元--->亿元
            vo.setThisYearCompleteProjectConfirmedOutputValue(new BigDecimal(0));
        }
        PcMonthActualOutputValueVO pcData = pcMonthActualOutputValueMapper.selectSumData(param);
        if(pcData!=null && pcData.getThisMonthCompletedTotalOutputValue()!=null){
            //万元--->亿元
            vo.setThisYearCompletePcOutputValue(CommonUtils.parseDivide4(pcData.getThisMonthCompletedTotalOutputValue(), 4));
        }else{
            vo.setThisYearCompletePcOutputValue(new BigDecimal(0));
        }
        // 本年完成产值-总完成产值(亿元)
        vo.setThisYearCompleteTotalOutputValue(CommonUtils.addBigDecimal(vo.getThisYearCompleteProjectOutputValue(),vo.getThisYearCompletePcOutputValue()));

        QueryWrapper<ProjectSupplementEntity> projectWrapper3 = new QueryWrapper<>();
        projectWrapper3.like("effect_last_date", year);
        projectWrapper3.in("bill_state", 1,3);
        projectWrapper3.in("project_status", "在施");//在施
        projectWrapper3.in("org_id", commonOrgIds);

        Integer thisYearCompleteBuildingProjectNumber = projectSupplementService.count(projectWrapper3);
        vo.setThisYearCompleteBuildingProjectNumber(Long.parseLong(thisYearCompleteBuildingProjectNumber.toString())); // 在施项目数（个）

        //获取项目档案中的基本信息
        ProjectSupplementVO building = projectSupplementMapper.selectSumData(commonOrgIds, year, "'在施'");//在施
        if(building!=null){
            vo.setThisYearCompleteStartWorkSpace(CommonUtils.parseDivide4(building.getBuiltAllArea(),4)); // 本年完成产值-开工面积(万平米)
            vo.setThisYearCompleteBuildingSpace(CommonUtils.parseDivide4(building.getBuiltAllArea(),4)); // 本年完成产值-施工面积（万平方米）
            vo.setThisYearCompleteBuildingProjectContractSurplus(CommonUtils.parseDivide8(building.getContractAmount(),4)); // 本年完成产值-在施项目合同余量(亿元)
            vo.setThisYearCompleteBuildingProjectContractAmount(CommonUtils.parseDivide8(building.getContractAmount(),4)); // 本年完成产值-在施项目合同额(亿元)
        }else{
            vo.setThisYearCompleteStartWorkSpace(new BigDecimal(0)); // 本年完成产值-开工面积(万平米)
            vo.setThisYearCompleteBuildingSpace(new BigDecimal(0)); // 本年完成产值-施工面积（万平方米）
            vo.setThisYearCompleteBuildingProjectContractSurplus(new BigDecimal(0)); // 本年完成产值-在施项目合同余量(亿元)
            vo.setThisYearCompleteBuildingProjectContractAmount(new BigDecimal(0)); // 本年完成产值-在施项目合同额(亿元)
        }
        ProjectSupplementVO finish = projectSupplementMapper.selectSumData(commonOrgIds, year, "'竣工未结','竣工已结'");//在施
        if(finish!=null){
            vo.setThisYearCompleteCompletedSpace(CommonUtils.parseDivide4(finish.getBuiltAllArea(),4)); // 本年完成产值-竣工面积(万平米)
        }else{
            vo.setThisYearCompleteCompletedSpace(new BigDecimal(0)); // 本年完成产值-开工面积(万平米)
        }
        return vo;
    }
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }

    @Override
    public void updateProjectPcInfo(Long orgId, String year){
        //更新公司经营指标---先判断该组织是否存在单据，存在则修改
        QueryWrapper<CompanyBusinessQuotaEntity> companyWrapper = new QueryWrapper<>();
        companyWrapper.eq("org_id", orgId);
        companyWrapper.eq("year", year);
        companyWrapper.in("bill_state", 1,3);
        List<CompanyBusinessQuotaEntity> companyList = this.list(companyWrapper);
        if(companyList!=null && companyList.size()>0){
            CompanyBusinessQuotaEntity companyEntity = companyList.get(0);
            Map<String,Object> param = new HashMap<>();
            param.put("twoOrgId", orgId);
            param.put("year", year);
            ProjectMonthActualOutputValueVO sumData = projectMonthActualOutputValueMapper.selectSumData(param);
            if(sumData!=null){
                // 本月实际完成产值       万元--->亿元
                companyEntity.setThisYearCompleteProjectOutputValue(CommonUtils.parseDivide4(sumData.getThisMonthActualOutputValue(), 4));
                // 本月确认产值       万元--->亿元
                companyEntity.setThisYearCompleteProjectConfirmedOutputValue(CommonUtils.parseDivide4(sumData.getThisMonthConfirmedOutputValue(), 4));
            }else{
                companyEntity.setThisYearCompleteProjectOutputValue(new BigDecimal(0));
                // 本月确认产值       万元--->亿元
                companyEntity.setThisYearCompleteProjectConfirmedOutputValue(new BigDecimal(0));
            }
            PcMonthActualOutputValueVO pcData = pcMonthActualOutputValueMapper.selectSumData(param);
            if(pcData!=null){
                companyEntity.setThisYearCompletePcOutputValue(CommonUtils.parseDivide4(pcData.getThisMonthCompletedTotalOutputValue(), 4));
            }else{
                companyEntity.setThisYearCompletePcOutputValue(new BigDecimal(0));
            }
            // 本年完成产值-总完成产值(亿元)
            companyEntity.setThisYearCompleteTotalOutputValue(CommonUtils.addBigDecimal(companyEntity.getThisYearCompleteProjectOutputValue(),companyEntity.getThisYearCompletePcOutputValue()));
            this.saveOrUpdate(companyEntity, false);
        }
    }
}
