package com.ejianc.business.outputValue.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.utils.CommonUtils;
import com.ejianc.business.outputValue.bean.ProjectMonthActualOutputValueEntity;
import com.ejianc.business.outputValue.bean.ProjectPcYearBusinessQuotaEntity;
import com.ejianc.business.outputValue.mapper.ProjectMonthActualOutputValueMapper;
import com.ejianc.business.outputValue.service.ICompanyBusinessQuotaService;
import com.ejianc.business.outputValue.service.IProjectMonthActualOutputValueService;
import com.ejianc.business.outputValue.service.IProjectPcYearBusinessQuotaService;
import com.ejianc.business.outputValue.utils.OutputValueUtils;
import com.ejianc.business.outputValue.vo.ProjectMonthActualOutputValueVO;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

/**
 * 项目月度计划产值
 * 
 * @author generator
 * 
 */
@Service("projectMonthActualOutputValueService")
public class ProjectMonthActualOutputValueServiceImpl extends BaseServiceImpl<ProjectMonthActualOutputValueMapper, ProjectMonthActualOutputValueEntity> implements IProjectMonthActualOutputValueService {

    @Autowired
    private ProjectMonthActualOutputValueMapper projectMonthActualOutputValueMapper;
    @Autowired
    private IProjectPcYearBusinessQuotaService projectPcYearBusinessQuotaService;


    @Override
    public ProjectMonthActualOutputValueVO queryOtherInfoByProjectId(Long projectId, String year, String month, Long id) {
        ProjectMonthActualOutputValueVO vo = new ProjectMonthActualOutputValueVO();
        //获取本项目本年累计数据，当前月份之前的
        Map<String,Object> param = new HashMap<>();
        param.put("projectId", projectId);
        param.put("year", year);
        param.put("months", OutputValueUtils.getMonths(month));
        if(id != null){
            param.put("neId", id);
        }
        ProjectMonthActualOutputValueVO projectData = projectMonthActualOutputValueMapper.selectSumData(param);
        if(projectData!=null){
            vo.setLastAllMonthActualOutputValue(projectData.getThisMonthActualOutputValue()); // 本年到上月项目累计完成产值（万元）
            vo.setLastAllMonthConfirmedOutputValue(projectData.getThisMonthConfirmedOutputValue()); // 本年到上月项目累计确认产值（万元）
        }else{
            vo.setLastAllMonthActualOutputValue(new BigDecimal(0)); // 本年到上月项目累计完成产值（万元）
            vo.setLastAllMonthConfirmedOutputValue(new BigDecimal(0)); // 本年到上月项目累计确认产值（万元）
        }
        // 本月商务系统实际完成产值（万元）
        //获取规则------------获取【项目商务运营分析表】中【本月实际完成产值(万元)(production_money)】
        String reportingMonth = OutputValueUtils.getReportingMonth(year, month);
        BigDecimal thisMonthCommerceActualCompletedOutputValue = projectMonthActualOutputValueMapper.getAnalysisBusinessData(projectId, reportingMonth);
        if(thisMonthCommerceActualCompletedOutputValue!=null){
            vo.setThisMonthCommerceActualCompletedOutputValue(CommonUtils.parseDivide4(thisMonthCommerceActualCompletedOutputValue, 4));
        }else{
            vo.setThisMonthCommerceActualCompletedOutputValue(new BigDecimal(0));
        }

        QueryWrapper<ProjectPcYearBusinessQuotaEntity> projectPcWarpper = new QueryWrapper<>();
        projectPcWarpper.eq("project_id", projectId);
        projectPcWarpper.eq("year", year);
        ProjectPcYearBusinessQuotaEntity projectPcYearBusinessQuotaEntity = projectPcYearBusinessQuotaService.getOne(projectPcWarpper);
        if(projectPcYearBusinessQuotaEntity!=null){
            vo.setYearTargetOutputValue(projectPcYearBusinessQuotaEntity.getYearPlanOutputValue()); // '年度目标产值'--
            BigDecimal yearTargetOutputValueMargin = OutputValueUtils.getMarginValue(projectPcYearBusinessQuotaEntity, month); // 年度目标产值余量====当前项目年度计划产值-以往月份的计划产值合计
            if(yearTargetOutputValueMargin!=null){
                vo.setYearTargetOutputValueMargin(yearTargetOutputValueMargin);
            }else{
                vo.setYearTargetOutputValueMargin(new BigDecimal(0));
            }
        }else{
            vo.setYearTargetOutputValue(new BigDecimal(0)); // '年度目标产值'--
            vo.setYearTargetOutputValueMargin(new BigDecimal(0));
        }
        return vo;
    }
}
