package com.ejianc.business.outputValue.utils;

import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.metadata.data.CellData;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.style.column.AbstractColumnWidthStyleStrategy;
import org.apache.poi.ss.usermodel.Cell;
import org.springframework.util.CollectionUtils;

import java.util.*;

/**
 * EasyExcel导出自动列宽设置
 */
public class Custemhandler extends AbstractColumnWidthStyleStrategy {
    private static final int MAX_COLUMN_WIDTH = 150;
    //因为在自动列宽的过程中，有些设置地方让列宽显得紧凑，所以做出了个判断
    private static final int COLUMN_WIDTH = 20;
    private Map<Integer, Map<Integer, Integer>> CACHE = new HashMap(8);
    public Custemhandler() {
    }
    @Override
    protected void setColumnWidth(WriteSheetHolder writeSheetHolder, List<WriteCellData<?>> cellDataList, Cell cell, Head head, Integer relativeRowIndex, Boolean isHead) {
        boolean needSetWidth = isHead || !CollectionUtils.isEmpty(cellDataList);
        if (needSetWidth) {
            List<Integer> width5 = new ArrayList<>();
            Collections.addAll(width5,0,1,13,14,15);
            List<Integer> width20 = new ArrayList<>();
            Collections.addAll(width20,3);
            List<Integer> width9 = new ArrayList<>();
            Collections.addAll(width9,4,5,6);
            List<Integer> width8 = new ArrayList<>();
            Collections.addAll(width8,2,7,8,9,10,11,12,16,17,18,19,20,21,22,23,24,25,26,27,28);
            // 设置宽度为5字符
            if (width5.contains(cell.getColumnIndex())) {
                writeSheetHolder.getSheet().setColumnWidth(cell.getColumnIndex(), 5 * 256);
            }
            // 设置宽度为20字符
            if (width20.contains(cell.getColumnIndex())) {
                writeSheetHolder.getSheet().setColumnWidth(cell.getColumnIndex(), 20 * 256);
            }
            // 设置宽度为9字符
            if (width9.contains(cell.getColumnIndex())) {
                writeSheetHolder.getSheet().setColumnWidth(cell.getColumnIndex(), 9 * 256);
            }
            // 设置宽度为8字符
            if (width8.contains(cell.getColumnIndex())) {
                writeSheetHolder.getSheet().setColumnWidth(cell.getColumnIndex(), 8 * 256);
            }

            /*
            Map<Integer, Integer> maxColumnWidthMap = (Map) CACHE.get(writeSheetHolder.getSheetNo());
            if (maxColumnWidthMap == null) {
                maxColumnWidthMap = new HashMap(16);
                CACHE.put(writeSheetHolder.getSheetNo(), maxColumnWidthMap);
            }
            Integer columnWidth = this.dataLength(cellDataList, cell, isHead);
            if (columnWidth >= 0) {
                if (columnWidth > MAX_COLUMN_WIDTH) {
                    columnWidth = MAX_COLUMN_WIDTH;
                } else {
                    if (columnWidth < COLUMN_WIDTH) {
                        columnWidth = columnWidth * 2;
                    }
                }
                Integer maxColumnWidth = (Integer) ((Map) maxColumnWidthMap).get(cell.getColumnIndex());
                if (maxColumnWidth == null || columnWidth > maxColumnWidth) {
                    ((Map) maxColumnWidthMap).put(cell.getColumnIndex(), columnWidth);
                    writeSheetHolder.getSheet().setColumnWidth(cell.getColumnIndex(), columnWidth * 200);
                }
            }
            */
        }
    }
    private Integer dataLength(List<WriteCellData<?>> cellDataList, Cell cell, Boolean isHead) {
        if (isHead) {
            return cell.getStringCellValue().getBytes().length;
        } else {
            CellData cellData = (CellData) cellDataList.get(0);
            CellDataTypeEnum type = cellData.getType();
            if (type == null) {
                return -1;
            } else {
                switch (type) {
                    case STRING:
                        return cellData.getStringValue().getBytes().length;
                    case BOOLEAN:
                        return cellData.getBooleanValue().toString().getBytes().length;
                    case NUMBER:
                        return cellData.getNumberValue().toString().getBytes().length;
                    default:
                        return -1;
                }
            }
        }
    }
}
