package com.ejianc.business.outputValue.utils;

import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.write.handler.CellWriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteTableHolder;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * EasyExcel行合并
 */
public class ExcelFillCellMerge implements CellWriteHandler {
    private static final String KEY ="%s-%s";
    //所有的合并信息都存在了这个map里面
    Map<String, Integer> mergeRowInfo = new HashMap<>();//单独行合并
    //所有的合并信息都存在了这个map里面
    Map<String, Integer> mergeColInfo = new HashMap<>();//单独列合并
    //所有的合并信息都存在了这个map里面
    Map<String, List<Integer>> mergeAllInfo = new HashMap<>();//行列都要合并,值说明，先是行数，后面一个是列数，只支持两个数据，其他的不管

    public Map<String, Integer> getMergeRowInfo() {
        return mergeRowInfo;
    }

    public void setMergeRowInfo(Map<String, Integer> mergeRowInfo) {
        this.mergeRowInfo = mergeRowInfo;
    }

    public Map<String, Integer> getMergeColInfo() {
        return mergeColInfo;
    }

    public void setMergeColInfo(Map<String, Integer> mergeColInfo) {
        this.mergeColInfo = mergeColInfo;
    }

    public Map<String, List<Integer>> getMergeAllInfo() {
        return mergeAllInfo;
    }

    public void setMergeAllInfo(Map<String, List<Integer>> mergeAllInfo) {
        this.mergeAllInfo = mergeAllInfo;
    }

    public ExcelFillCellMerge() {
    }
    @Override
    public void beforeCellCreate(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Row row, Head head, Integer integer, Integer integer1, Boolean aBoolean) {
    }
    @Override
    public void afterCellCreate(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Cell cell, Head head, Integer integer, Boolean aBoolean) {
    }
    @Override
    public void afterCellDataConverted(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, WriteCellData<?> cellData, Cell cell, Head head, Integer integer, Boolean aBoolean) {
    }
    @Override
    public void afterCellDispose(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, List<WriteCellData<?>> list, Cell cell, Head head, Integer integer, Boolean aBoolean) {
        //当前行
        int curRowIndex = cell.getRowIndex();
        //当前列
        int curColIndex = cell.getColumnIndex();
        String key = String.format(KEY, curRowIndex, curColIndex);
        if(mergeAllInfo.get(key)!=null){
            List<Integer> info = mergeAllInfo.get(key);
            mergeWithPrevCol(writeSheetHolder, cell, curRowIndex, curColIndex, info.get(0), info.get(1));
        }else if(mergeRowInfo.get(key)!=null){
            //行合并
            mergeWithPrevCol(writeSheetHolder, cell, curRowIndex, curColIndex, 0, mergeRowInfo.get(key));
        }else if(mergeColInfo.get(key)!=null){
            //列合并
            mergeWithPrevCol(writeSheetHolder, cell, curRowIndex, curColIndex, mergeColInfo.get(key), 0);
        }
    }
    public void mergeWithPrevCol(WriteSheetHolder writeSheetHolder, Cell cell, int curRowIndex, int curColIndex, int rowNum, int colNum) {
        Sheet sheet = writeSheetHolder.getSheet();
        CellRangeAddress cellRangeAddress = new CellRangeAddress(curRowIndex, curRowIndex+rowNum, curColIndex, curColIndex + colNum);
        sheet.addMergedRegion(cellRangeAddress);
    }

    // curRowIndex 在第几行进行行合并
    // curColIndex 在第几列进行合并
    // num 再合并多少格
    public void addRow (int curRowIndex, int curColIndex , int num){
        mergeRowInfo.put(String.format(KEY, curRowIndex, curColIndex),num);
    }

    // curRowIndex 在第几行进行行合并
    // curColIndex 在第几列进行合并
    // num 再合并多少格
    public void addCol (int curRowIndex, int curColIndex , int num){
        mergeColInfo.put(String.format(KEY, curRowIndex, curColIndex),num);
    }

    // curRowIndex 在第几行进行行合并
    // curColIndex 在第几列进行合并
    // rowNum 再合并多少行格
    // colNum 再合并多少列格
    public void addAll (int curRowIndex, int curColIndex , int rowNum , int colNum){
        List<Integer> info = new ArrayList<>();
        info.add(colNum);
        info.add(rowNum);
        mergeAllInfo.put(String.format(KEY, curRowIndex, curColIndex),info);
    }
}