package com.ejianc.business.outputValue.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 工厂月度实际产值
 *
 * @author generator
 *
 */
public class PcMonthActualOutputValueRecordVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String changeReason; // 变更原因
    private Long dataId; // 项目补充信息id
    private String billVersion; // 单据版本
    private String billCode; // 单据编号
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private Long projectId; // 项目id
    private String projectName; // 项目名称
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private Long projectDepartmentId; // 项目部id
    private Long twoOrgId; // 二级组织
    private String twoOrgName; // 二级组织名称
    private String year; // 年度
    private String month; // 月份
    private Long thisMonthPresenceManagementPersonNum; //本月在场管理人员数量
    private Long thisMonthOwnIndustryPersonNum; // 本月自有产业工人数量
    private Long thisMonthExternalLaborPersonNum; // 本月外部劳务工人数量

    private BigDecimal thisMonthCompletedTotalOutputValue; // 本月完成总产值（万元）
    private BigDecimal thisMonthWithinOutputValue; // 本月中建科技内总产值（万元）
    private BigDecimal thisMonthBrotherOutputValue; // 本月中建内(除科技)总产值（万元）
    private BigDecimal thisMonthOutsideOutputValue; // 本月中建外总产值（万元）

    private String rewardPunishmentSituation; // '奖罚情况'
    private String remarks; // '备注'

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date effectLastDate; // 最后生效日期

    public String getChangeReason() {
        return changeReason;
    }

    public void setChangeReason(String changeReason) {
        this.changeReason = changeReason;
    }

    public Long getDataId() {
        return dataId;
    }

    public void setDataId(Long dataId) {
        this.dataId = dataId;
    }

    public String getBillVersion() {
        return billVersion;
    }

    public void setBillVersion(String billVersion) {
        this.billVersion = billVersion;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    @ReferSerialTransfer(referCode = "ejc-zjkj-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }

    public Long getTwoOrgId() {
        return twoOrgId;
    }

    public void setTwoOrgId(Long twoOrgId) {
        this.twoOrgId = twoOrgId;
    }

    public String getTwoOrgName() {
        return twoOrgName;
    }

    public void setTwoOrgName(String twoOrgName) {
        this.twoOrgName = twoOrgName;
    }

    public String getYear() {
        return year;
    }

    public void setYear(String year) {
        this.year = year;
    }

    public String getMonth() {
        return month;
    }

    public void setMonth(String month) {
        this.month = month;
    }

    public Long getThisMonthPresenceManagementPersonNum() {
        return thisMonthPresenceManagementPersonNum;
    }

    public void setThisMonthPresenceManagementPersonNum(Long thisMonthPresenceManagementPersonNum) {
        this.thisMonthPresenceManagementPersonNum = thisMonthPresenceManagementPersonNum;
    }

    public Long getThisMonthOwnIndustryPersonNum() {
        return thisMonthOwnIndustryPersonNum;
    }

    public void setThisMonthOwnIndustryPersonNum(Long thisMonthOwnIndustryPersonNum) {
        this.thisMonthOwnIndustryPersonNum = thisMonthOwnIndustryPersonNum;
    }

    public Long getThisMonthExternalLaborPersonNum() {
        return thisMonthExternalLaborPersonNum;
    }

    public void setThisMonthExternalLaborPersonNum(Long thisMonthExternalLaborPersonNum) {
        this.thisMonthExternalLaborPersonNum = thisMonthExternalLaborPersonNum;
    }

    public BigDecimal getThisMonthCompletedTotalOutputValue() {
        return thisMonthCompletedTotalOutputValue;
    }

    public void setThisMonthCompletedTotalOutputValue(BigDecimal thisMonthCompletedTotalOutputValue) {
        this.thisMonthCompletedTotalOutputValue = thisMonthCompletedTotalOutputValue;
    }

    public BigDecimal getThisMonthWithinOutputValue() {
        return thisMonthWithinOutputValue;
    }

    public void setThisMonthWithinOutputValue(BigDecimal thisMonthWithinOutputValue) {
        this.thisMonthWithinOutputValue = thisMonthWithinOutputValue;
    }

    public BigDecimal getThisMonthBrotherOutputValue() {
        return thisMonthBrotherOutputValue;
    }

    public void setThisMonthBrotherOutputValue(BigDecimal thisMonthBrotherOutputValue) {
        this.thisMonthBrotherOutputValue = thisMonthBrotherOutputValue;
    }

    public BigDecimal getThisMonthOutsideOutputValue() {
        return thisMonthOutsideOutputValue;
    }

    public void setThisMonthOutsideOutputValue(BigDecimal thisMonthOutsideOutputValue) {
        this.thisMonthOutsideOutputValue = thisMonthOutsideOutputValue;
    }

    public String getRewardPunishmentSituation() {
        return rewardPunishmentSituation;
    }

    public void setRewardPunishmentSituation(String rewardPunishmentSituation) {
        this.rewardPunishmentSituation = rewardPunishmentSituation;
    }

    public String getRemarks() {
        return remarks;
    }

    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }

    public Date getEffectLastDate() {
        return effectLastDate;
    }

    public void setEffectLastDate(Date effectLastDate) {
        this.effectLastDate = effectLastDate;
    }
}
