package com.ejianc.business.outputValue.vo;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 项目信息补充与维护
 *
 * @author generator
 *
 */
public class ProjectSupplementVO extends BaseVO {
    private static final long serialVersionUID = 1L;


    private String changeState; // 变更状态
    private Long changeId; // 变更单据
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    private Long projectId; // 项目id
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long orgId; // 所属组织id
    private String orgName; // 所属组织名称
    private Long projectDepartmentId; // 项目部id

    private Integer projectNum; // 项目序号
    private Boolean pcFactory; // 是否PC厂
    private String projectStatus; // 项目状态
    private String graphicProgress; // 形象进度
    private String projectNature; // 项目性质
    private BigDecimal provisionalAmount; // 暂列金金额
    private Boolean hasConstructionPermit; // 是/否办理施工许可证
    private String permitExplain; // 未办理施工许可证说明

    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date planStartDate; // 计划开工日期
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date planEndDate; // 计划竣工日期'
    private Integer planDuration; // 计划工期（日历天）
    private String contractNodes; // 合同过程重大节点
    private Boolean establishProjectDepartment; // 是/否建立项目经理部
    private String projectDepartmentExplain; // 未建立项目经理部情况说明
    private Integer managementPersonNum; // 管理人员数量
    private Integer laborPersonNum; // 劳务人员数量
    private String contractGoal; // 合同创优目标
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss",timezone = "GMT+8")
    private Date effectLastDate; // 最后生效日期

    private BigDecimal contractAmount; // 合同额(元)

    private BigDecimal builtAllArea; // 建筑总面积

    private List<ProjectSupplementRecordVO> recordList = new ArrayList<>();

    public String getChangeState() {
        return changeState;
    }

    public void setChangeState(String changeState) {
        this.changeState = changeState;
    }

    public Long getChangeId() {
        return changeId;
    }

    public void setChangeId(Long changeId) {
        this.changeId = changeId;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    @ReferSerialTransfer(referCode = "ejc-zjkj-project")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }

    public Integer getProjectNum() {
        return projectNum;
    }

    public void setProjectNum(Integer projectNum) {
        this.projectNum = projectNum;
    }

    public Boolean getPcFactory() {
        return pcFactory;
    }

    public void setPcFactory(Boolean pcFactory) {
        this.pcFactory = pcFactory;
    }

    public String getProjectStatus() {
        return projectStatus;
    }

    public void setProjectStatus(String projectStatus) {
        this.projectStatus = projectStatus;
    }

    public String getGraphicProgress() {
        return graphicProgress;
    }

    public void setGraphicProgress(String graphicProgress) {
        this.graphicProgress = graphicProgress;
    }

    public String getProjectNature() {
        return projectNature;
    }

    public void setProjectNature(String projectNature) {
        this.projectNature = projectNature;
    }

    public BigDecimal getProvisionalAmount() {
        return provisionalAmount;
    }

    public void setProvisionalAmount(BigDecimal provisionalAmount) {
        this.provisionalAmount = provisionalAmount;
    }

    public Boolean getHasConstructionPermit() {
        return hasConstructionPermit;
    }

    public void setHasConstructionPermit(Boolean hasConstructionPermit) {
        this.hasConstructionPermit = hasConstructionPermit;
    }

    public String getPermitExplain() {
        return permitExplain;
    }

    public void setPermitExplain(String permitExplain) {
        this.permitExplain = permitExplain;
    }

    public Date getPlanStartDate() {
        return planStartDate;
    }

    public void setPlanStartDate(Date planStartDate) {
        this.planStartDate = planStartDate;
    }

    public Date getPlanEndDate() {
        return planEndDate;
    }

    public void setPlanEndDate(Date planEndDate) {
        this.planEndDate = planEndDate;
    }

    public Integer getPlanDuration() {
        return planDuration;
    }

    public void setPlanDuration(Integer planDuration) {
        this.planDuration = planDuration;
    }

    public String getContractNodes() {
        return contractNodes;
    }

    public void setContractNodes(String contractNodes) {
        this.contractNodes = contractNodes;
    }

    public Boolean getEstablishProjectDepartment() {
        return establishProjectDepartment;
    }

    public void setEstablishProjectDepartment(Boolean establishProjectDepartment) {
        this.establishProjectDepartment = establishProjectDepartment;
    }

    public String getProjectDepartmentExplain() {
        return projectDepartmentExplain;
    }

    public void setProjectDepartmentExplain(String projectDepartmentExplain) {
        this.projectDepartmentExplain = projectDepartmentExplain;
    }

    public Integer getManagementPersonNum() {
        return managementPersonNum;
    }

    public void setManagementPersonNum(Integer managementPersonNum) {
        this.managementPersonNum = managementPersonNum;
    }

    public Integer getLaborPersonNum() {
        return laborPersonNum;
    }

    public void setLaborPersonNum(Integer laborPersonNum) {
        this.laborPersonNum = laborPersonNum;
    }

    public String getContractGoal() {
        return contractGoal;
    }

    public void setContractGoal(String contractGoal) {
        this.contractGoal = contractGoal;
    }

    public Date getEffectLastDate() {
        return effectLastDate;
    }

    public void setEffectLastDate(Date effectLastDate) {
        this.effectLastDate = effectLastDate;
    }

    public BigDecimal getContractAmount() {
        return contractAmount;
    }

    public void setContractAmount(BigDecimal contractAmount) {
        this.contractAmount = contractAmount;
    }

    public BigDecimal getBuiltAllArea() {
        return builtAllArea;
    }

    public void setBuiltAllArea(BigDecimal builtAllArea) {
        this.builtAllArea = builtAllArea;
    }

    public List<ProjectSupplementRecordVO> getRecordList() {
        return recordList;
    }

    public void setRecordList(List<ProjectSupplementRecordVO> recordList) {
        this.recordList = recordList;
    }
}
