/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.material.utils;

import com.ejianc.framework.cache.redissonlock.RedissonLocker;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BillLockUtil {
    private static RedissonLocker redissonLocker;
    private static final String LOCK_KEY = "BILLKEY-";

    @Autowired
    public void setRedissonLocker(RedissonLocker redissonLocker) {
        BillLockUtil.redissonLocker = redissonLocker;
    }

    public static Boolean getLock(Long id) {
        if (id == null) {
            return false;
        }
        redissonLocker.lock(LOCK_KEY + id, TimeUnit.SECONDS, 30);
        return true;
    }

    public static Boolean getLock(String lockKey, Long id) {
        if (id == null) {
            return false;
        }
        redissonLocker.lock(lockKey + "::" + id, TimeUnit.SECONDS, 30);
        return true;
    }

    public static void releaseLock(Long id) {
        if (id == null) {
            return;
        }
        redissonLocker.unlock(LOCK_KEY + id);
    }

    public static void releaseLock(String lockKey, Long id) {
        if (id == null) {
            return;
        }
        redissonLocker.unlock(lockKey + "::" + id);
    }
}

