/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.outputValue.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.material.utils.CommonUtils;
import com.ejianc.business.outputValue.bean.ProjectMonthActualOutputValueEntity;
import com.ejianc.business.outputValue.bean.ProjectSupplementEntity;
import com.ejianc.business.outputValue.mapper.ProjectMonthActualOutputValueMapper;
import com.ejianc.business.outputValue.service.ICompanyBusinessQuotaService;
import com.ejianc.business.outputValue.service.IProjectMonthActualOutputValueService;
import com.ejianc.business.outputValue.service.IProjectSupplementService;
import com.ejianc.business.outputValue.utils.OutputValueUtils;
import com.ejianc.business.outputValue.vo.ProjectMonthActualOutputValueVO;
import com.ejianc.foundation.share.api.IZjkjProjectApi;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="projectMonthActualOutputValue")
public class ProjectMonthActualOutputValueBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IProjectMonthActualOutputValueService projectMonthActualOutputValueService;
    @Autowired
    private ProjectMonthActualOutputValueMapper projectMonthActualOutputValueMapper;
    @Autowired
    private ICompanyBusinessQuotaService companyBusinessQuotaService;
    @Autowired
    private IProjectSupplementService projectSupplementService;
    @Autowired
    private IZjkjProjectApi projectApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ProjectMonthActualOutputValueEntity entity = (ProjectMonthActualOutputValueEntity)((Object)this.projectMonthActualOutputValueService.selectById(billId));
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"project_id", (Object)entity.getProjectId());
        wrapper.eq((Object)"year", (Object)entity.getYear());
        wrapper.gt((Object)"month", (Object)entity.getMonth());
        wrapper.orderByAsc((Object)"month");
        List list = this.projectMonthActualOutputValueService.list((Wrapper)wrapper);
        if (list != null && list.size() > 0 && !((ProjectMonthActualOutputValueEntity)((Object)list.get(0))).getId().equals(billId)) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("projectId", entity.getProjectId());
            param.put("year", entity.getYear());
            param.put("months", OutputValueUtils.getMonths(entity.getMonth()));
            ProjectMonthActualOutputValueVO projectData = this.projectMonthActualOutputValueMapper.selectSumData(param);
            BigDecimal lastAllMonthActualOutputValue = projectData.getThisMonthActualOutputValue();
            BigDecimal lastAllMonthConfirmedOutputValue = projectData.getThisMonthConfirmedOutputValue();
            for (ProjectMonthActualOutputValueEntity en : list) {
                lastAllMonthActualOutputValue = CommonUtils.addBigDecimal(lastAllMonthActualOutputValue, en.getThisMonthActualOutputValue());
                lastAllMonthConfirmedOutputValue = CommonUtils.addBigDecimal(lastAllMonthConfirmedOutputValue, en.getThisMonthConfirmedOutputValue());
                en.setThisYearAccumulateCompletedOutputValue(lastAllMonthActualOutputValue);
                en.setThisYearConfirmedOutputValue(lastAllMonthConfirmedOutputValue);
                en.setProjectAccumulatedCompletedOutputValue(lastAllMonthActualOutputValue);
                en.setProjectAccumulatedConfirmedOutputValue(lastAllMonthConfirmedOutputValue);
            }
            this.projectMonthActualOutputValueService.saveOrUpdateBatch(list, list.size(), false);
        }
        this.companyBusinessQuotaService.updateProjectPcInfo(entity.getTwoOrgId(), entity.getYear());
        ProjectSupplementEntity projectSupplement = (ProjectSupplementEntity)((Object)this.projectSupplementService.selectById(entity.getProjectId()));
        if (!entity.getProjectImageProgress().equals(projectSupplement.getGraphicProgress())) {
            projectSupplement.setGraphicProgress(entity.getProjectImageProgress());
            this.projectSupplementService.saveOrUpdate((Object)projectSupplement, false);
            CommonResponse projectResponse = this.projectApi.queryDetailById(entity.getProjectId());
            if (projectResponse.isSuccess() && projectResponse.getData() != null) {
                ProjectVO projectVO = (ProjectVO)projectResponse.getData();
                projectVO.setGraphicProgress(projectSupplement.getGraphicProgress());
                CommonResponse saveback = this.projectApi.saveProject(projectVO);
                if (!saveback.isSuccess()) {
                    this.logger.info("\u53cd\u5199\u9879\u76ee\u4fe1\u606f\u5931\u8d25----------------->" + saveback.getMsg());
                }
            } else {
                return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u9879\u76ee\u4fe1\u606f");
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

