/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.outputValue.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.business.outputValue.bean.ProjectSupplementChangeEntity;
import com.ejianc.business.outputValue.bean.ProjectSupplementEntity;
import com.ejianc.business.outputValue.bean.ProjectSupplementRecordEntity;
import com.ejianc.business.outputValue.service.IProjectSupplementChangeService;
import com.ejianc.business.outputValue.service.IProjectSupplementRecordService;
import com.ejianc.business.outputValue.service.IProjectSupplementService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.share.api.IZjkjProjectApi;
import com.ejianc.foundation.share.vo.ProjectVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.support.idworker.util.IdWorker;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="projectSupplementChange")
public class ProjectSupplementChangeBpmServiceImpl
implements ICommonBusinessService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String PROJECTSUPPLEMENT_SOURCETYPE = "incontract";
    private static final String PROJECTSUPPLEMENT_CHANGE_SOURCETYPE = "incontractChange";
    private static final String PROJECTSUPPLEMENT_RECORD_SOURCETYPE = "incontractRecord";
    private static final String PROJECTSUPPLEMENT_BILLTYPE_CODE = "EJCBT202411000001";
    private static final String PROJECTSUPPLEMENT_CHANGE_BILLTYPE_CODE = "EJCBT202411000007";
    private static final String PROJECTSUPPLEMENT_RECORD_BILLTYPE_CODE = "EJCBT202411000008";
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private IProjectSupplementService projectSupplementService;
    @Autowired
    private IProjectSupplementChangeService changeService;
    @Autowired
    private IProjectSupplementRecordService recordService;
    @Autowired
    private IZjkjProjectApi zjkjProjectApi;

    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    public void clearBaseData(BaseEntity entity) {
        entity.setTenantId(null);
        entity.setUpdateTime(null);
        entity.setUpdateUserCode(null);
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        ProjectSupplementChangeEntity changeEntity = (ProjectSupplementChangeEntity)((Object)this.changeService.selectById(billId));
        ProjectSupplementEntity projectSupplementEntity = (ProjectSupplementEntity)((Object)this.projectSupplementService.selectById(changeEntity.getDataId()));
        QueryWrapper recordWrapper = new QueryWrapper();
        recordWrapper.eq((Object)"data_id", (Object)projectSupplementEntity.getId());
        recordWrapper.eq((Object)"dr", (Object)0);
        Integer count = this.recordService.count((Wrapper)recordWrapper);
        ProjectSupplementRecordEntity recordEntity = (ProjectSupplementRecordEntity)((Object)BeanMapper.map((Object)((Object)projectSupplementEntity), ProjectSupplementRecordEntity.class));
        Long recordId = IdWorker.getId();
        this.clearBaseData(recordEntity);
        recordEntity.setBillState(null);
        recordEntity.setDataId(projectSupplementEntity.getId());
        recordEntity.setBillVersion(String.valueOf(count + 1));
        recordEntity.setId(recordId);
        recordEntity.setChangeReason(changeEntity.getChangeReason());
        String sourceBillType = PROJECTSUPPLEMENT_BILLTYPE_CODE;
        String targetBillType = PROJECTSUPPLEMENT_RECORD_BILLTYPE_CODE;
        this.attachmentApi.copyFilesFromSourceBillToTargetBill(projectSupplementEntity.getId().toString(), sourceBillType, PROJECTSUPPLEMENT_SOURCETYPE, recordId.toString(), targetBillType, PROJECTSUPPLEMENT_RECORD_SOURCETYPE);
        this.recordService.saveOrUpdate((Object)recordEntity, false);
        this.logger.info("---------\u751f\u6210\u5408\u540c\u4fe1\u606f\u5b8c\u6210--------");
        ProjectSupplementEntity newContractEntity = (ProjectSupplementEntity)((Object)BeanMapper.map((Object)((Object)changeEntity), ProjectSupplementEntity.class));
        newContractEntity.setChangeState("3");
        newContractEntity.setChangeId(null);
        newContractEntity.setBillState(projectSupplementEntity.getBillState());
        newContractEntity.setId(projectSupplementEntity.getId());
        newContractEntity.setCreateTime(projectSupplementEntity.getCreateTime());
        newContractEntity.setCreateUserCode(projectSupplementEntity.getCreateUserCode());
        newContractEntity.setTenantId(projectSupplementEntity.getTenantId());
        newContractEntity.setVersion(projectSupplementEntity.getVersion());
        newContractEntity.setEffectLastDate(new Date());
        this.projectSupplementService.saveOrUpdate((Object)newContractEntity, false);
        sourceBillType = PROJECTSUPPLEMENT_CHANGE_BILLTYPE_CODE;
        targetBillType = PROJECTSUPPLEMENT_BILLTYPE_CODE;
        this.attachmentApi.copyFilesFromSourceBillToTargetBill(changeEntity.getId().toString(), sourceBillType, PROJECTSUPPLEMENT_CHANGE_SOURCETYPE, projectSupplementEntity.getId().toString(), targetBillType, PROJECTSUPPLEMENT_SOURCETYPE);
        this.logger.info("---------\u4fee\u6539\u5408\u540c\u4fe1\u606f\u5b8c\u6210--------");
        if (changeEntity.getProjectId() != null) {
            CommonResponse projectData = this.zjkjProjectApi.queryDetailById(changeEntity.getProjectId());
            if (projectData.isSuccess() && projectData.getData() != null) {
                ProjectVO projectVO = (ProjectVO)projectData.getData();
                projectVO.setProjectNum(changeEntity.getProjectNum());
                projectVO.setPcFactory(changeEntity.getPcFactory());
                projectVO.setProjectStatus(changeEntity.getProjectStatus());
                projectVO.setGraphicProgress(changeEntity.getGraphicProgress());
                projectVO.setProjectNature(changeEntity.getProjectNature());
                projectVO.setProvisionalAmount(changeEntity.getProvisionalAmount());
                projectVO.setHasConstructionPermit(changeEntity.getHasConstructionPermit());
                projectVO.setPermitExplain(changeEntity.getPermitExplain());
                projectVO.setPlanStartDate(changeEntity.getPlanStartDate());
                projectVO.setPlanEndDate(changeEntity.getPlanEndDate());
                projectVO.setPlanDuration(changeEntity.getPlanDuration());
                projectVO.setContractNodes(changeEntity.getContractNodes());
                projectVO.setEstablishProjectDepartment(changeEntity.getEstablishProjectDepartment());
                projectVO.setProjectDepartmentExplain(changeEntity.getProjectDepartmentExplain());
                projectVO.setManagementPersonNum(changeEntity.getManagementPersonNum());
                projectVO.setLaborPersonNum(changeEntity.getLaborPersonNum());
                projectVO.setContractGoal(changeEntity.getContractGoal());
                CommonResponse saveback = this.zjkjProjectApi.saveProject(projectVO);
                if (!saveback.isSuccess()) {
                    this.logger.info("\u53cd\u5199\u9879\u76ee\u4fe1\u606f\u5931\u8d25----------------->" + saveback.getMsg());
                    return CommonResponse.error((String)"\u53cd\u5199\u9879\u76ee\u4fe1\u606f\u5931\u8d25");
                }
            } else {
                return CommonResponse.error((String)"\u672a\u67e5\u8be2\u5230\u9879\u76ee\u4fe1\u606f");
            }
        }
        return CommonResponse.success();
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.error((String)"\u53d8\u66f4\u5355\u4e0d\u5141\u8bb8\u5f03\u5ba1");
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }
}

