package com.ejianc.business.material.bean;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 出入库流水表
 *
 * @author generator
 *
 */
 @TableName("ejc_material_flowmeter")
public class FlowmeterEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value="bill_state")
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    @TableField(value="org_id")
    private Long orgId; // 所属组织id
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="mid")
    private Long mid; // 表头id
    @TableField(value="detail_id")
    private Long detailId; // 明细id
    @TableField(value="project_id")
    private Long projectId; // 项目id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="material_id")
    private Long materialId; // 物资id
    @TableField(value="material_code")
    private String materialCode; // 物资编码
    @TableField(value="material_name")
    private String materialName; // 物资名称
    @TableField(value="material_category_id")
    private Long materialCategoryId; // 物资分类id
    @TableField(value="material_category_code")
    private String materialCategoryCode; // 物资分类编码
    @TableField(value="material_category_name")
    private String materialCategoryName; // 物资分类编码
    @TableField(value="store_id")
    private Long storeId; // 仓库id
    @TableField(value="store_name")
    private String storeName; // 仓库名称
    @TableField(value="store_type")
    private Integer storeType; // 仓库类型 0-成品库 1-废旧物资库 2-资产库
    @TableField(value="operation_type")
    private String operationType; // 操作类型（入库、出库.调拨入库，调拨出库）
    @TableField(value="access_type")
    private String accessType; // 出入库类型（入库、调入、出库、调出、处置、）
    @TableField(value="quantity")
    private BigDecimal quantity; // 数量
    @TableField(value="unit_price_incluetax")
    private BigDecimal unitPriceIncluetax; // 单价（含税）
    @TableField(value="unit_price_excluetax")
    private BigDecimal unitPriceExcluetax; // 单价（无税）
    @TableField(value="amount_incluetax")
    private BigDecimal amountIncluetax; // 金额（含税）
    @TableField(value="amount_excluetax")
    private BigDecimal amountExcluetax; // 金额（无税）
    @TableField(value="time")
    private Date time; // 日期
    @JsonFormat(shape = JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd",timezone = "GMT+8")
    @TableField(value="approve_time")
    private Date approveTime; // 审批时间
    @JsonFormat(shape = JsonFormat.Shape.STRING,pattern = "yyyy-MM-dd",timezone = "GMT+8")
    @TableField(value="bill_time")
    private Date billTime; // 单据日期
    @TableField(value="bill_status")
    private Integer billStatus; // 单据状态 0-自由态,1-审批通过
    @TableField(value="special_model")
    private String specialModel; // 规格型号
    @TableField(value="measurement_unit")
    private String measurementUnit; // 计量单位
    @TableField(value="bill_code")
    private java.lang.String billCode; // 单据编号
    @TableField(value="project_department_id")
    private java.lang.Long projectDepartmentId; // 项目部id
    @TableField(value="supplier_id")
    private Long supplierId; // 供应商id
    @TableField(value="supplier_name")
    private String supplierName; // 供应商名称
    @TableField(value="transferorder_type")
    private String transferorderType; // 是否调拨入库出库 调拨入库  调拨出库
    @TableField(value="bill_type")
    private Integer billType; // 来源单据节点类型,0-入库单,1-出库单,2-调拨单,3-处置单
    @TableField(value="out_id")
    private Long outId; // 出库单id
    //不是本表数据 sql返回数据
    @TableField(exist = false)
    private BigDecimal enterQuantity;//入库数量
    @TableField(exist = false)
    private BigDecimal enterAmountIncluetax;//入库含税金额
    @TableField(exist = false)
    private BigDecimal enterAmountExcluetax;//入库无税金额
    @TableField(exist = false)
    private BigDecimal enterUnitPriceIncluetax;//本期入库含税单价
    @TableField(exist = false)
    private BigDecimal enterUnitPriceExcluetax;//本期入库不含税单价
    @TableField(exist = false)
    private BigDecimal deliveryQuantity;//出库数量
    @TableField(exist = false)
    private BigDecimal deliveryAmountIncluetax;//出库含税金额
    @TableField(exist = false)
    private BigDecimal deliveryAmountExcluetax;//出库无税金额
    @TableField(exist = false)
    private BigDecimal deliveryUnitPriceIncluetax;//本期出库含税单价
    @TableField(exist = false)
    private BigDecimal deliveryUnitPriceExcluetax;//本期出库不含税单价
    @TableField(value="sub_unit_id")
    private Long subUnitId; // 分包单位id
    @TableField(value="sub_unit_name")
    private String subUnitName; // 分包单位name

    public Long getSubUnitId() {
        return subUnitId;
    }

    public void setSubUnitId(Long subUnitId) {
        this.subUnitId = subUnitId;
    }

    public String getSubUnitName() {
        return subUnitName;
    }

    public void setSubUnitName(String subUnitName) {
        this.subUnitName = subUnitName;
    }

    public Long getOutId() {
        return outId;
    }

    public void setOutId(Long outId) {
        this.outId = outId;
    }

    public Integer getBillType() {
        return billType;
    }

    public void setBillType(Integer billType) {
        this.billType = billType;
    }

    public Integer getStoreType() {
        return storeType;
    }

    public void setStoreType(Integer storeType) {
        this.storeType = storeType;
    }

    public Date getApproveTime() {
        return approveTime;
    }

    public void setApproveTime(Date approveTime) {
        this.approveTime = approveTime;
    }

    public Date getBillTime() {
        return billTime;
    }

    public void setBillTime(Date billTime) {
        this.billTime = billTime;
    }

    public Integer getBillStatus() {
        return billStatus;
    }

    public void setBillStatus(Integer billStatus) {
        this.billStatus = billStatus;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public Long getMid() {
        return mid;
    }

    public void setMid(Long mid) {
        this.mid = mid;
    }
    public Long getDetailId() {
        return detailId;
    }

    public void setDetailId(Long detailId) {
        this.detailId = detailId;
    }
    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }
    public Long getMaterialId() {
        return materialId;
    }

    public void setMaterialId(Long materialId) {
        this.materialId = materialId;
    }
    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode;
    }
    public String getMaterialName() {
        return materialName;
    }

    public void setMaterialName(String materialName) {
        this.materialName = materialName;
    }
    public Long getMaterialCategoryId() {
        return materialCategoryId;
    }

    public void setMaterialCategoryId(Long materialCategoryId) {
        this.materialCategoryId = materialCategoryId;
    }
    public String getMaterialCategoryCode() {
        return materialCategoryCode;
    }

    public void setMaterialCategoryCode(String materialCategoryCode) {
        this.materialCategoryCode = materialCategoryCode;
    }
    public String getMaterialCategoryName() {
        return materialCategoryName;
    }

    public void setMaterialCategoryName(String materialCategoryName) {
        this.materialCategoryName = materialCategoryName;
    }
    public Long getStoreId() {
        return storeId;
    }

    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }
    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }
    public String getOperationType() {
        return operationType;
    }

    public void setOperationType(String operationType) {
        this.operationType = operationType;
    }
    public String getAccessType() {
        return accessType;
    }

    public void setAccessType(String accessType) {
        this.accessType = accessType;
    }
    public BigDecimal getQuantity() {
        return quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }
    public BigDecimal getUnitPriceIncluetax() {
        return unitPriceIncluetax;
    }

    public void setUnitPriceIncluetax(BigDecimal unitPriceIncluetax) {
        this.unitPriceIncluetax = unitPriceIncluetax;
    }
    public BigDecimal getUnitPriceExcluetax() {
        return unitPriceExcluetax;
    }

    public void setUnitPriceExcluetax(BigDecimal unitPriceExcluetax) {
        this.unitPriceExcluetax = unitPriceExcluetax;
    }
    public BigDecimal getAmountIncluetax() {
        return amountIncluetax;
    }

    public void setAmountIncluetax(BigDecimal amountIncluetax) {
        this.amountIncluetax = amountIncluetax;
    }
    public BigDecimal getAmountExcluetax() {
        return amountExcluetax;
    }

    public void setAmountExcluetax(BigDecimal amountExcluetax) {
        this.amountExcluetax = amountExcluetax;
    }
    public Date getTime() {
        return time;
    }

    public void setTime(Date time) {
        this.time = time;
    }
    public String getSpecialModel() {
        return specialModel;
    }

    public void setSpecialModel(String specialModel) {
        this.specialModel = specialModel;
    }
    public String getMeasurementUnit() {
        return measurementUnit;
    }

    public void setMeasurementUnit(String measurementUnit) {
        this.measurementUnit = measurementUnit;
    }

    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    public BigDecimal getEnterQuantity() {
        return enterQuantity;
    }

    public void setEnterQuantity(BigDecimal enterQuantity) {
        this.enterQuantity = enterQuantity;
    }

    public BigDecimal getDeliveryQuantity() {
        return deliveryQuantity;
    }

    public void setDeliveryQuantity(BigDecimal deliveryQuantity) {
        this.deliveryQuantity = deliveryQuantity;
    }

    public BigDecimal getEnterAmountIncluetax() {
        return enterAmountIncluetax;
    }

    public void setEnterAmountIncluetax(BigDecimal enterAmountIncluetax) {
        this.enterAmountIncluetax = enterAmountIncluetax;
    }

    public BigDecimal getEnterAmountExcluetax() {
        return enterAmountExcluetax;
    }

    public void setEnterAmountExcluetax(BigDecimal enterAmountExcluetax) {
        this.enterAmountExcluetax = enterAmountExcluetax;
    }

    public BigDecimal getDeliveryAmountIncluetax() {
        return deliveryAmountIncluetax;
    }

    public void setDeliveryAmountIncluetax(BigDecimal deliveryAmountIncluetax) {
        this.deliveryAmountIncluetax = deliveryAmountIncluetax;
    }

    public BigDecimal getDeliveryAmountExcluetax() {
        return deliveryAmountExcluetax;
    }

    public void setDeliveryAmountExcluetax(BigDecimal deliveryAmountExcluetax) {
        this.deliveryAmountExcluetax = deliveryAmountExcluetax;
    }

    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }

    public Long getSupplierId() {
        return supplierId;
    }

    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }

    public String getTransferorderType() {
        return transferorderType;
    }

    public void setTransferorderType(String transferorderType) {
        this.transferorderType = transferorderType;
    }


    public BigDecimal getDeliveryUnitPriceIncluetax() {
        return deliveryUnitPriceIncluetax;
    }

    public void setDeliveryUnitPriceIncluetax(BigDecimal deliveryUnitPriceIncluetax) {
        this.deliveryUnitPriceIncluetax = deliveryUnitPriceIncluetax;
    }

    public BigDecimal getDeliveryUnitPriceExcluetax() {
        return deliveryUnitPriceExcluetax;
    }

    public void setDeliveryUnitPriceExcluetax(BigDecimal deliveryUnitPriceExcluetax) {
        this.deliveryUnitPriceExcluetax = deliveryUnitPriceExcluetax;
    }

    public BigDecimal getEnterUnitPriceIncluetax() {
        return enterUnitPriceIncluetax;
    }

    public void setEnterUnitPriceIncluetax(BigDecimal enterUnitPriceIncluetax) {
        this.enterUnitPriceIncluetax = enterUnitPriceIncluetax;
    }

    public BigDecimal getEnterUnitPriceExcluetax() {
        return enterUnitPriceExcluetax;
    }

    public void setEnterUnitPriceExcluetax(BigDecimal enterUnitPriceExcluetax) {
        this.enterUnitPriceExcluetax = enterUnitPriceExcluetax;
    }
}
