package com.ejianc.business.material.bean;

import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import com.ejianc.business.material.bean.MaterialinventorydetailEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 物资库存及可调拨材料记录
 * 
 * @author generator
 * 
 */
 @TableName("ejc_material_materialinventory")
public class MaterialInventoryEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private java.lang.String billCode; // 单据编号
    @TableField(value="bill_state")
    private java.lang.Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    @TableField(value="approve_time")
    private java.util.Date approveTime; // 审批通过日期
    @TableField(value="agentdept_id")
    private java.lang.Long agentdeptId; // 经办人部门id
    @TableField(value="agentdept_name")
    private java.lang.String agentdeptName; // 经办人部门
    @TableField(value="bills_time")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date billsTime; // 单据日期
    @TableField(value="project_code")
    private java.lang.String projectCode; // 项目编码
    @TableField(value="project_id")
    private java.lang.Long projectId; // 项目id
    @TableField(value="project_name")
    private java.lang.String projectName; // 项目名称
    @TableField(value="org_id")
    private java.lang.Long orgId; // 所属组织id
    @TableField(value="org_name")
    private java.lang.String orgName; // 所属组织名称
    @TableField(value="project_department_id")
    private java.lang.Long projectDepartmentId; // 项目部id
    @TableField(value="change_id")
    private java.lang.Long changeId; // 变更单据id
    @TableField(value="change_state")
    private java.lang.String changeState; // 变更状态，1:未变更;2:变更中;3:已变更
    @TableField(value="remarks")
    private java.lang.String remarks; // 备注
    @TableField(value="agent_id")
    private java.lang.Long agentId; // 经办人
    @TableField(value="agent_name")
    private java.lang.String agentName; // 经办人姓名
    @TableField(value="signature_keeper")
    private java.lang.String signatureKeeper; // 库管员签字
    @TableField(value="project_department")
    private java.lang.String projectDepartment; // 项目物资部
    @TableField(value="project_engineer")
    private java.lang.String projectEngineer; // 项目工程部
    @TableField(value="commerce")
    private java.lang.String commerce; // 商务部
    @TableField(value="approval_date")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date approvalDate; // 审批日期
    @TableField(value="data_date")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date dataDate; // 单据日期
    @TableField(value="store_id")
    private Long storeId;
    @TableField(value="store_name")
    private java.lang.String storeName; // 仓库名称
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="materialinventorydetailService",pidName = "mid")
    private List<MaterialinventorydetailEntity> materialinventorydetailEntities = new ArrayList<>(); // 物资库存及可调拨材料记录子表
    

    /**
     * 单据编号
     */
    public java.lang.String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(java.lang.String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public java.lang.Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public void setBillState(java.lang.Integer billState) {
        this.billState = billState;
    }
    /**
     * 审批通过日期
     */
    public java.util.Date getApproveTime() {
        return approveTime;
    }

    /**
     * 审批通过日期
     */
    public void setApproveTime(java.util.Date approveTime) {
        this.approveTime = approveTime;
    }
    /**
     * 经办人部门id
     */
    public java.lang.Long getAgentdeptId() {
        return agentdeptId;
    }

    /**
     * 经办人部门id
     */
    public void setAgentdeptId(java.lang.Long agentdeptId) {
        this.agentdeptId = agentdeptId;
    }
    /**
     * 经办人部门
     */
    public java.lang.String getAgentdeptName() {
        return agentdeptName;
    }

    /**
     * 经办人部门
     */
    public void setAgentdeptName(java.lang.String agentdeptName) {
        this.agentdeptName = agentdeptName;
    }
    /**
     * 单据日期
     */
    public java.util.Date getBillsTime() {
        return billsTime;
    }

    /**
     * 单据日期
     */
    public void setBillsTime(java.util.Date billsTime) {
        this.billsTime = billsTime;
    }
    /**
     * 项目编码
     */
    public java.lang.String getProjectCode() {
        return projectCode;
    }

    /**
     * 项目编码
     */
    public void setProjectCode(java.lang.String projectCode) {
        this.projectCode = projectCode;
    }
    /**
     * 项目id
     */
    public java.lang.Long getProjectId() {
        return projectId;
    }

    /**
     * 项目id
     */
    public void setProjectId(java.lang.Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public java.lang.String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(java.lang.String projectName) {
        this.projectName = projectName;
    }
    /**
     * 所属组织id
     */
    public java.lang.Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织id
     */
    public void setOrgId(java.lang.Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 所属组织名称
     */
    public java.lang.String getOrgName() {
        return orgName;
    }

    /**
     * 所属组织名称
     */
    public void setOrgName(java.lang.String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部id
     */
    public java.lang.Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    /**
     * 项目部id
     */
    public void setProjectDepartmentId(java.lang.Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    /**
     * 变更单据id
     */
    public java.lang.Long getChangeId() {
        return changeId;
    }

    /**
     * 变更单据id
     */
    public void setChangeId(java.lang.Long changeId) {
        this.changeId = changeId;
    }
    /**
     * 变更状态，1:未变更;2:变更中;3:已变更
     */
    public java.lang.String getChangeState() {
        return changeState;
    }

    /**
     * 变更状态，1:未变更;2:变更中;3:已变更
     */
    public void setChangeState(java.lang.String changeState) {
        this.changeState = changeState;
    }
    /**
     * 备注
     */
    public java.lang.String getRemarks() {
        return remarks;
    }

    /**
     * 备注
     */
    public void setRemarks(java.lang.String remarks) {
        this.remarks = remarks;
    }
    /**
     * 经办人
     */
    public java.lang.Long getAgentId() {
        return agentId;
    }

    /**
     * 经办人
     */
    public void setAgentId(java.lang.Long agentId) {
        this.agentId = agentId;
    }
    /**
     * 经办人姓名
     */
    public java.lang.String getAgentName() {
        return agentName;
    }

    /**
     * 经办人姓名
     */
    public void setAgentName(java.lang.String agentName) {
        this.agentName = agentName;
    }
    /**
     * 库管员签字
     */
    public java.lang.String getSignatureKeeper() {
        return signatureKeeper;
    }

    /**
     * 库管员签字
     */
    public void setSignatureKeeper(java.lang.String signatureKeeper) {
        this.signatureKeeper = signatureKeeper;
    }
    /**
     * 项目物资部
     */
    public java.lang.String getProjectDepartment() {
        return projectDepartment;
    }

    /**
     * 项目物资部
     */
    public void setProjectDepartment(java.lang.String projectDepartment) {
        this.projectDepartment = projectDepartment;
    }
    /**
     * 项目工程部
     */
    public java.lang.String getProjectEngineer() {
        return projectEngineer;
    }

    /**
     * 项目工程部
     */
    public void setProjectEngineer(java.lang.String projectEngineer) {
        this.projectEngineer = projectEngineer;
    }
    /**
     * 商务部
     */
    public java.lang.String getCommerce() {
        return commerce;
    }

    /**
     * 商务部
     */
    public void setCommerce(java.lang.String commerce) {
        this.commerce = commerce;
    }
    /**
     * 审批日期
     */
    public java.util.Date getApprovalDate() {
        return approvalDate;
    }

    /**
     * 审批日期
     */
    public void setApprovalDate(java.util.Date approvalDate) {
        this.approvalDate = approvalDate;
    }
    
    /**
     * 物资库存及可调拨材料记录子表
     */
    public List<MaterialinventorydetailEntity> getMaterialinventorydetailEntities() {
        return materialinventorydetailEntities;
    }

    /**
     * 物资库存及可调拨材料记录子表
     */
    public void setMaterialinventorydetailEntities(List<MaterialinventorydetailEntity> materialinventorydetailEntities) {
        this.materialinventorydetailEntities = materialinventorydetailEntities;
    }

    public java.util.Date getDataDate() {
        return dataDate;
    }

    public void setDataDate(java.util.Date dataDate) {
        this.dataDate = dataDate;
    }

    public Long getStoreId() {
        return storeId;
    }

    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }

    public String getStoreName() {
        return storeName;
    }

    public void setStoreName(String storeName) {
        this.storeName = storeName;
    }
}
