package com.ejianc.business.material.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.util.ArrayList;
import java.util.List;
/**
 * 物资/周转材退场记录单
 * 
 * @author generator
 * 
 */
 @TableName("ejc_material_materialsreturn")
public class MaterialsreturnEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private String billCode; // 单据编号
    @TableField(value="bill_state")
    private Integer billState; // 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
    @TableField(value="approve_time")
    private java.util.Date approveTime; // 审批日期
    @TableField(value="remarks")
    private String remarks; // 备注
    @TableField(value="agent_id")
    private Long agentId; // 经办人
    @TableField(value="agent_name")
    private String agentName; // 经办人姓名
    @TableField(value="agentdep_id")
    private Long agentdepId; // 经办部门
    @TableField(value="agentdep_name")
    private String agentdepName; // 经办部门名称
    @TableField(value="bill_time")
    private java.util.Date billTime; // 单据日期
    @TableField(value="contract_id")
    private Long contractId; // 合同id
    @TableField(value="contract_name")
    private String contractName; // 合同id
    @TableField(value="project_name")
    private String projectName; // 项目名称
    @TableField(value="contract_code")
    private String contractCode; // 合同编号
    @TableField(value="supplier_id")
    private Long supplierId; // 供应商id
    @TableField(value="supplier_name")
    private String supplierName; // 供应商名称
    @TableField(value="enter_code")
    private String enterCode; // 进场编号
    @TableField(value="enter_id")
    private Long enterId; // 进场id
    @TableField(value="return_time")
    private java.util.Date returnTime; // 退场日期
    @TableField(value="project_material")
    private String projectMaterial; // 项目物资部
    @TableField(value="project_engineering")
    private String projectEngineering; // 项目工程部
    @TableField(value="verification_time")
    private java.util.Date verificationTime; // 验证日期
    @TableField(value="subcontractor_id")
    private Long subcontractorId; // 分包方id
    @TableField(value="subcontractor_name")
    private String subcontractorName; // 分包方（使用单位）
    @TableField(value="org_id")
    private Long orgId; // 所属组织id
    @TableField(value="org_name")
    private String orgName; // 所属组织名称
    @TableField(value="project_department_id")
    private Long projectDepartmentId; // 项目部id
    @TableField(value="project_id")
    private java.lang.Long projectId; // 项目id
    
    
    @TableField(exist=false)
    @SubEntity(serviceName="materialsreturndetailService", pidName = "mid")
    private List<MaterialsreturndetailEntity> materialsreturndetailEntities = new ArrayList<>(); // 物资/周转材退场记录单子表

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    /**
     * 单据编号
     */
    public String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态: 0自由态,1已提交,2审批中,3审批通过,4驳回,5提交后有人审批中
     */
    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    /**
     * 审批日期
     */
    public java.util.Date getApproveTime() {
        return approveTime;
    }

    /**
     * 审批日期
     */
    public void setApproveTime(java.util.Date approveTime) {
        this.approveTime = approveTime;
    }
    /**
     * 备注
     */
    public String getRemarks() {
        return remarks;
    }

    /**
     * 备注
     */
    public void setRemarks(String remarks) {
        this.remarks = remarks;
    }
    /**
     * 经办人
     */
    public Long getAgentId() {
        return agentId;
    }

    /**
     * 经办人
     */
    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }
    /**
     * 经办人姓名
     */
    public String getAgentName() {
        return agentName;
    }

    /**
     * 经办人姓名
     */
    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }
    /**
     * 经办部门
     */
    public Long getAgentdepId() {
        return agentdepId;
    }

    /**
     * 经办部门
     */
    public void setAgentdepId(Long agentdepId) {
        this.agentdepId = agentdepId;
    }
    /**
     * 经办部门名称
     */
    public String getAgentdepName() {
        return agentdepName;
    }

    /**
     * 经办部门名称
     */
    public void setAgentdepName(String agentdepName) {
        this.agentdepName = agentdepName;
    }
    /**
     * 单据日期
     */
    public java.util.Date getBillTime() {
        return billTime;
    }

    /**
     * 单据日期
     */
    public void setBillTime(java.util.Date billTime) {
        this.billTime = billTime;
    }
    /**
     * 合同id
     */
    public Long getContractId() {
        return contractId;
    }

    /**
     * 合同id
     */
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    /**
     * 合同id
     */
    public String getContractName() {
        return contractName;
    }

    /**
     * 合同id
     */
    public void setContractName(String contractName) {
        this.contractName = contractName;
    }
    /**
     * 合同编号
     */
    public String getContractCode() {
        return contractCode;
    }

    /**
     * 合同编号
     */
    public void setContractCode(String contractCode) {
        this.contractCode = contractCode;
    }
    /**
     * 供应商id
     */
    public Long getSupplierId() {
        return supplierId;
    }

    /**
     * 供应商id
     */
    public void setSupplierId(Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供应商名称
     */
    public String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称
     */
    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 进场编号
     */
    public String getEnterCode() {
        return enterCode;
    }

    /**
     * 进场编号
     */
    public void setEnterCode(String enterCode) {
        this.enterCode = enterCode;
    }
    /**
     * 进场id
     */
    public Long getEnterId() {
        return enterId;
    }

    /**
     * 进场id
     */
    public void setEnterId(Long enterId) {
        this.enterId = enterId;
    }
    /**
     * 退场日期
     */
    public java.util.Date getReturnTime() {
        return returnTime;
    }

    /**
     * 退场日期
     */
    public void setReturnTime(java.util.Date returnTime) {
        this.returnTime = returnTime;
    }
    /**
     * 项目物资部
     */
    public String getProjectMaterial() {
        return projectMaterial;
    }

    /**
     * 项目物资部
     */
    public void setProjectMaterial(String projectMaterial) {
        this.projectMaterial = projectMaterial;
    }
    /**
     * 项目工程部
     */
    public String getProjectEngineering() {
        return projectEngineering;
    }

    /**
     * 项目工程部
     */
    public void setProjectEngineering(String projectEngineering) {
        this.projectEngineering = projectEngineering;
    }
    /**
     * 验证日期
     */
    public java.util.Date getVerificationTime() {
        return verificationTime;
    }

    /**
     * 验证日期
     */
    public void setVerificationTime(java.util.Date verificationTime) {
        this.verificationTime = verificationTime;
    }
    /**
     * 分包方id
     */
    public Long getSubcontractorId() {
        return subcontractorId;
    }

    /**
     * 分包方id
     */
    public void setSubcontractorId(Long subcontractorId) {
        this.subcontractorId = subcontractorId;
    }
    /**
     * 分包方（使用单位）
     */
    public String getSubcontractorName() {
        return subcontractorName;
    }

    /**
     * 分包方（使用单位）
     */
    public void setSubcontractorName(String subcontractorName) {
        this.subcontractorName = subcontractorName;
    }
    /**
     * 所属组织id
     */
    public Long getOrgId() {
        return orgId;
    }

    /**
     * 所属组织id
     */
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 所属组织名称
     */
    public String getOrgName() {
        return orgName;
    }

    /**
     * 所属组织名称
     */
    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    /**
     * 项目部id
     */
    public Long getProjectDepartmentId() {
        return projectDepartmentId;
    }

    /**
     * 项目部id
     */
    public void setProjectDepartmentId(Long projectDepartmentId) {
        this.projectDepartmentId = projectDepartmentId;
    }
    
    /**
     * 物资/周转材退场记录单子表
     */
    public List<MaterialsreturndetailEntity> getMaterialsreturndetailEntities() {
        return materialsreturndetailEntities;
    }

    /**
     * 物资/周转材退场记录单子表
     */
    public void setMaterialsreturndetailEntities(List<MaterialsreturndetailEntity> materialsreturndetailEntities) {
        this.materialsreturndetailEntities = materialsreturndetailEntities;
    }
}
